/*
 * Decompiled with CFR 0.152.
 */
package de.jave.preferences;

import de.jave.ascii.IAsciiGuiConstants;
import de.jave.preferences.SmartPreferences;
import java.awt.Font;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.swing.font.FontFactory;
import net.disy.commons.swing.fontchooser.model.FontModel;

public final class JavePreferences
extends SmartPreferences {
    private static final int DEFAULT_FONT_SIZE = IAsciiGuiConstants.DEFAULT_ASCII_FONT.getSize();
    private static final int DEFAULT_FONT_STYLE = IAsciiGuiConstants.DEFAULT_ASCII_FONT.getStyle();
    private static final String DEFAULT_FONT_FAMILY_NAME = IAsciiGuiConstants.DEFAULT_ASCII_FONT.getFamily();
    private FontModel displayFontModel;

    public JavePreferences() {
        super(Preferences.userRoot().node("JavE"));
        String fontFamilyName = this.get("fontFamilyName", DEFAULT_FONT_FAMILY_NAME);
        int fontStyle = this.getInt("fontStyle", DEFAULT_FONT_STYLE);
        int fontSize = this.getInt("fontSize", DEFAULT_FONT_SIZE);
        this.displayFontModel = new FontModel(new Font(fontFamilyName, fontStyle, fontSize));
        this.displayFontModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                JavePreferences.this.put("fontFamilyName", JavePreferences.this.displayFontModel.getFontFamilyName());
                JavePreferences.this.putInt("fontStyle", FontFactory.getAwtStyle(JavePreferences.this.displayFontModel.getFontStyle()));
                JavePreferences.this.putInt("fontSize", JavePreferences.this.displayFontModel.getFontSize());
                JavePreferences.this.flush();
            }
        });
    }

    public final FontModel getDisplayFontModel() {
        return this.displayFontModel;
    }
}

