/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib.net;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public final class HtmlUtilities {
    private static Map entityTableDecode;
    private static final Map entityTableEncode;
    private static final String[] ENTITIES;

    private HtmlUtilities() {
    }

    private static void buildEntityTables() {
        entityTableDecode = new HashMap(ENTITIES.length);
        for (int i = 0; i < ENTITIES.length; i += 2) {
            if (entityTableDecode.containsKey(ENTITIES[i])) continue;
            entityTableDecode.put(ENTITIES[i], ENTITIES[i + 1]);
        }
    }

    public static final String decodeEntities(String source) {
        StringBuffer result = new StringBuffer(source.length());
        int i0 = -1;
        int i1 = source.indexOf("&");
        while (i1 != -1) {
            result.append(source.substring(i0 + 1, i1));
            i0 = source.indexOf(";", i1);
            if (i0 == -1) {
                i0 = source.length() - 1;
                break;
            }
            result.append(HtmlUtilities.decodeEntity(source.substring(i1, i0 + 1)));
            i1 = source.indexOf("&", i0);
        }
        result.append(source.substring(i0 + 1, source.length()));
        return result.toString();
    }

    public static final String decodeEntity(String entity) {
        String s;
        if (entityTableDecode == null) {
            HtmlUtilities.buildEntityTables();
        }
        if ((s = (String)entityTableDecode.get(entity)) == null) {
            System.err.println("Unknown HTML-Entity '" + entity + "' in HTMLTools.decodeEntity(). Ignored");
            return entity;
        }
        return s;
    }

    public static final String encode(String s) {
        return HtmlUtilities.encode(s, "");
    }

    public static final String encode(String text, String ignore) {
        ignore = "'" + ignore;
        StringBuffer sb = new StringBuffer(text.length() * 2);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch >= '?' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || HtmlUtilities.contains(ignore, ch)) {
                sb.append(ch);
                continue;
            }
            sb.append(HtmlUtilities.encodeSingleChar(new Character(ch)));
        }
        return sb.toString();
    }

    private static boolean contains(String text, char ch) {
        return text.indexOf(ch) != -1;
    }

    private static final String encodeSingleChar(Character ch) {
        String s = (String)entityTableEncode.get(ch);
        if (s == null) {
            return ch.toString();
        }
        return s;
    }

    public static final String toHexString(Color color) {
        String red = HtmlUtilities.convertToHex(color.getRed());
        String green = HtmlUtilities.convertToHex(color.getGreen());
        String blue = HtmlUtilities.convertToHex(color.getBlue());
        return red + green + blue;
    }

    private static String convertToHex(int value) {
        String converted = Integer.toHexString(value);
        if (converted.length() == 1) {
            converted = "0" + converted;
        }
        return converted;
    }

    static {
        entityTableEncode = new HashMap(){
            {
                this.put('-', "-");
                this.put('\n', "&#13;");
                this.put(' ', " ");
                this.put('\u00dc', "&Uuml;");
                this.put('\u00c4', "&Auml;");
                this.put('\u00d6', "&Ouml;");
                this.put('\u00cb', "&Euml;");
                this.put('\u00c7', "&Ccedil;");
                this.put('\u00c6', "&AElig;");
                this.put('\u00c5', "&Aring;");
                this.put('\u00d8', "&Oslash;");
                this.put('\'', "&apos;");
                this.put('\u00fc', "&uuml;");
                this.put('\u00e4', "&auml;");
                this.put('\u00f6', "&ouml;");
                this.put('\u00eb', "&euml;");
                this.put('\"', "&#34;");
                this.put('\u00df', "&szlig;");
                this.put('\u00e7', "&ccedil;");
                this.put('\u00e5', "&aring;");
                this.put('\u00f8', "&oslash;");
                this.put('\u00e0', "&agrave;");
                this.put('\u00e8', "&egrave;");
                this.put('\u00ec', "&igrave;");
                this.put('\u00f2', "&ograve;");
                this.put('\u00f9', "&ugrave;");
                this.put('&', "&amp;");
                this.put('>', "&gt;");
                this.put('<', "&lt;");
                this.put('\u00a2', "&cent;");
                this.put('\u00a3', "&pound;");
                this.put('\u00ab', "&laquo;");
                this.put('\u00bb', "&raquo;");
                this.put('\u00e1', "&aacute;");
                this.put('\u00fa', "&uacute;");
                this.put('\u00f3', "&oacute;");
                this.put('\u00e9', "&eacute;");
                this.put('\u00ed', "&iacute;");
                this.put('\u00f1', "&ntilde;");
                this.put('\u00a7', "&sect;");
                this.put('\u00ee', "&icirc;");
                this.put('\u00f4', "&ocirc;");
                this.put('\u00e2', "&acirc;");
                this.put('\u00fb', "&ucirc;");
                this.put('\u00ea', "&ecirc;");
                this.put('\u00e6', "&aelig;");
                this.put('\u00a1', "&iexcl;");
                this.put('\u007f', "&nbsp;");
                this.put('\u009f', "&#159;");
                this.put('\u009b', "&#155;");
                this.put('\u009e', "&#158;");
                this.put('\u0092', "&#146;");
                this.put('\u0084', "&#132;");
            }

            private void put(char key, String value) {
                Character keyValue = new Character(key);
                if (this.containsKey(keyValue)) {
                    throw new RuntimeException("Key " + key + " already defined as '" + this.get(keyValue) + "'");
                }
                this.put(keyValue, value);
            }
        };
        ENTITIES = new String[]{" ", " ", "-", "-", "`", "`", " ", " ", "&#013;", "\n", "&#32;", " ", "&Uuml;", "\u00dc", "&Auml;", "\u00c4", "&Ouml;", "\u00d6", "&Euml;", "\u00cb", "&Ccedil;", "\u00c7", "&AElig;", "\u00c6", "&Aring;", "\u00c5", "&Oslash;", "\u00d8", "&apos;", "'", "&uuml;", "\u00fc", "&auml;", "\u00e4", "&ouml;", "\u00f6", "&euml;", "\u00eb", "&ccedil;", "\u00e7", "&aring;", "\u00e5", "&oslash;", "\u00f8", "&grave;", "`", "&agrave;", "\u00e0", "&egrave;", "\u00e8", "&igrave;", "\u00ec", "&ograve;", "\u00f2", "&ugrave;", "\u00f9", "&amp;", "&", "&#34;", "\"", "&szlig;", "\u00df", "&nbsp;", " ", "&gt;", ">", "&lt;", "<", "&copy;", "(C)", "&cent;", "\u00a2", "&pound;", "\u00a3", "&laquo;", "\u00ab", "&raquo;", "\u00bb", "&reg;", "(R)", "&middot;", " - ", "&times;", " x ", "&acute;", "'", "&aacute;", "\u00e1", "&uacute;", "\u00fa", "&oacute;", "\u00f3", "&eacute;", "\u00e9", "&iacute;", "\u00ed", "&ntilde;", "\u00f1", "&sect;", "\u00a7", "&egrave;", "\u00e8", "&icirc;", "\u00ee", "&ocirc;", "\u00f4", "&acirc;", "\u00e2", "&ucirc;", "\u00fb", "&ecirc;", "\u00ea", "&aelig;", "\u00e6", "&iexcl;", "\u00a1", "&#151;", "-", "&#0151;", "-", "&#0146;", "'", "&#146;", "'", "&#0145;", "'", "&#145;", "'", "&quot;", "\"", "&nbsp;", String.valueOf('\u007f'), "&#159;", String.valueOf('\u009f'), "&#155;", String.valueOf('\u009b'), "&#158;", String.valueOf('\u009e'), "&#146;", String.valueOf('\u0092'), "&#132;", String.valueOf('\u0084')};
    }
}

