/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib.job;

import de.jave.lib.job.IJobProcessor;
import de.jave.lib.job.JobProcessingContext;

public final class AsynchronousDroppingJobProcessor {
    private JobProcessingContext currentProcessingContext;
    private IJobProcessor processor;
    private Object job;
    private boolean running;

    public AsynchronousDroppingJobProcessor(IJobProcessor processor) {
        this.processor = processor;
    }

    private synchronized JobProcessingContext pop() {
        if (this.job == null) {
            return null;
        }
        Object result = this.job;
        this.job = null;
        this.currentProcessingContext = new JobProcessingContext(result);
        return this.currentProcessingContext;
    }

    private synchronized boolean reRun() {
        if (this.job == null) {
            this.running = false;
            return false;
        }
        return true;
    }

    private synchronized void push(Object job) {
        this.job = job;
        if (!this.running) {
            this.running = true;
            new Thread(this.createRunnable()).start();
            return;
        }
        if (this.currentProcessingContext != null) {
            this.currentProcessingContext.setCanceled(true);
        }
    }

    private Runnable createRunnable() {
        return new Runnable(){

            public final void run() {
                Exception exception = null;
                do {
                    JobProcessingContext job;
                    if ((job = AsynchronousDroppingJobProcessor.this.pop()) == null) continue;
                    try {
                        AsynchronousDroppingJobProcessor.this.processor.process(job);
                    }
                    catch (Exception exception2) {
                        Exception e = exception2;
                        exception = exception2;
                    }
                } while (AsynchronousDroppingJobProcessor.this.reRun());
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    public final void startJob(Object job) {
        this.push(job);
    }
}

