/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;

public final class IoUtilities {
    private IoUtilities() {
    }

    public static final URL toUrl(String name) {
        URL url = null;
        try {
            url = new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            url = IoUtilities.toURL(new File(name));
        }
        return url;
    }

    public static final URL toURL(File file) {
        try {
            String path = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/") && file.isDirectory()) {
                path = path + "/";
            }
            return new URL("file", "", path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File sourceFile, File destinationFile) throws IOException {
        if (!IoUtilities.ensureFoldersExist(destinationFile.getParentFile())) {
            throw new IOException("Unable to create necessary output directory " + destinationFile.getParentFile());
        }
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bos = new BufferedOutputStream(new FileOutputStream(destinationFile));
            IoUtilities.copyStream(bis, bos);
        }
        catch (Throwable throwable) {
            IoUtilities.close(bis);
            IoUtilities.close(bos);
            throw throwable;
        }
        IoUtilities.close(bis);
        IoUtilities.close(bos);
    }

    public static final boolean ensureFoldersExist(File folder) {
        if (folder.exists()) {
            return true;
        }
        return folder.mkdirs();
    }

    public static final void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static final void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static final void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static final void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static final void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        return;
    }
}

