/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib.collections;

import java.io.Serializable;

public final class IntVector
implements Cloneable,
Serializable {
    protected int[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public IntVector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new int[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public IntVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntVector() {
        this(10);
    }

    private void ensureCapacityHelper(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final int size() {
        return this.elementCount;
    }

    public final synchronized int elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final synchronized void addElement(int obj) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = obj;
    }

    public final synchronized Object clone() {
        try {
            IntVector v = (IntVector)super.clone();
            ((IntVector)super.clone()).elementData = new int[this.elementCount];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
            return v;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final synchronized int[] toArray() {
        int[] result = new int[this.elementCount];
        System.arraycopy(this.elementData, 0, result, 0, this.elementCount);
        return result;
    }

    public final synchronized int get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elementData[index];
    }

    public final synchronized boolean add(int o) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = o;
        return true;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer("{");
        for (int i = 0; i < this.size(); ++i) {
            result.append(this.get(i));
            if (i >= this.size() - 1) continue;
            result.append(';');
        }
        result.append('}');
        return result.toString();
    }
}

