/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.javeplayer.JavePlayerUtilities;
import de.jave.javeplayer.ZIPTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.disy.commons.core.util.Ensure;

public final class JaveAnimationFile {
    private File file;
    private AnimationMetaData metaData = new AnimationMetaData();
    private AnimationProperties properties = new AnimationProperties();
    private final List frames = new ArrayList();

    public JaveAnimationFile(File file) {
        this.file = file;
    }

    public JaveAnimationFile() {
        this(null);
    }

    public final AnimationMetaData getMetaData() {
        return this.metaData;
    }

    public final void setMetaData(AnimationMetaData metaData) {
        Ensure.ensureArgumentNotNull(metaData);
        this.metaData = metaData;
    }

    public final AnimationProperties getProperties() {
        return this.properties;
    }

    public final void setProperties(AnimationProperties properties) {
        Ensure.ensureArgumentNotNull(properties);
        this.properties = properties;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void load(URL url) throws Exception {
        BufferedReader reader;
        block37: {
            String s;
            this.frames.clear();
            reader = null;
            reader = new BufferedReader(new InputStreamReader(ZIPTool.openPossiblyZipped(url.openStream())));
            boolean frameCount = false;
            this.setProperties(new AnimationProperties());
            JaveAnimationFrame currentFrame = null;
            String lastContent = null;
            while ((s = reader.readLine()) != null) {
                if (s.startsWith("J:")) {
                    String content;
                    if (currentFrame != null) {
                        this.frames.add(currentFrame);
                    }
                    currentFrame = new JaveAnimationFrame();
                    if (s.length() == 2) {
                        currentFrame.setContent(lastContent);
                        continue;
                    }
                    char ch = s.charAt(2);
                    if (ch >= '0' && ch <= '9') {
                        try {
                            boolean i1 = false;
                            int i2 = s.indexOf(32, 3);
                            int i3 = s.indexOf(32, i2 + 1);
                            int i4 = s.indexOf(32, i3 + 1);
                            int i5 = s.indexOf(32, i4 + 1);
                            String s1 = s.substring(2, i2);
                            String s2 = s.substring(i2 + 1, i3);
                            String s3 = s.substring(i3 + 1, i4);
                            String s4 = null;
                            s4 = i5 != -1 ? s.substring(i4 + 1, i5) : s.substring(i4 + 1);
                            int scrollX = Integer.parseInt(s1);
                            int scrollY = Integer.parseInt(s2);
                            int cursorX = Integer.parseInt(s3);
                            int cursorY = Integer.parseInt(s4);
                            String content2 = null;
                            content2 = i5 == -1 ? lastContent : s.substring(i5 + 1);
                            lastContent = content2;
                            currentFrame.setContent(content2);
                            currentFrame.setScrollX(scrollX);
                            currentFrame.setScrollY(scrollY);
                            currentFrame.setCursorX(cursorX);
                            currentFrame.setCursorY(cursorY);
                        }
                        catch (Exception e) {
                            System.err.println("Warning: Error in format of JavE Animation." + e);
                        }
                        continue;
                    }
                    lastContent = content = s.substring(2);
                    currentFrame.setContent(content);
                    continue;
                }
                if (s.startsWith("S:")) {
                    if (currentFrame == null) continue;
                    try {
                        boolean i1 = false;
                        int i2 = s.indexOf(32, 3);
                        int i3 = s.indexOf(32, i2 + 1);
                        String s1 = s.substring(2, i2);
                        String s2 = s.substring(i2 + 1, i3);
                        String content = s.substring(i3 + 1);
                        int selectionX = Integer.parseInt(s1);
                        int selectionY = Integer.parseInt(s2);
                        currentFrame.setSelection(content);
                        currentFrame.setSelectionX(selectionX);
                        currentFrame.setSelectionY(selectionY);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of JavE Animation.");
                    }
                    continue;
                }
                if (s.startsWith("T:")) {
                    if (currentFrame == null) continue;
                    String toolName = s.substring(2);
                    currentFrame.setTool(toolName);
                    continue;
                }
                if (s.startsWith("A:")) {
                    if (currentFrame == null) continue;
                    String actionName = s.substring(2);
                    currentFrame.setAction(actionName);
                    continue;
                }
                if (s.startsWith("+:")) {
                    try {
                        int duration = Integer.parseInt(s.substring(2));
                        this.properties.setFrameDuration(duration);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Warning: Error in format of JavE Animation:  " + s);
                    }
                    continue;
                }
                if (s.startsWith("|:")) {
                    if (currentFrame == null) continue;
                    int i1 = s.indexOf(32, 2);
                    try {
                        int cursorX = Integer.parseInt(s.substring(2, i1));
                        int cursorY = Integer.parseInt(s.substring(i1 + 1));
                        currentFrame.setCursorX(cursorX);
                        currentFrame.setCursorY(cursorY);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of JavE Animation: " + s);
                    }
                    continue;
                }
                if (s.startsWith("^:")) {
                    if (currentFrame == null) continue;
                    int i1 = s.indexOf(32, 2);
                    try {
                        int scrollX = Integer.parseInt(s.substring(2, i1));
                        int scrollY = Integer.parseInt(s.substring(i1 + 1));
                        currentFrame.setScrollX(scrollX);
                        currentFrame.setScrollY(scrollY);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of JavE Animation: " + s);
                    }
                    continue;
                }
                if (s.startsWith("@:")) {
                    if (this.metaData.getAuthorEmail() != null || s.length() <= 2) continue;
                    this.metaData.setAuthorEmail(s.substring(2));
                    continue;
                }
                if (s.startsWith("N:")) {
                    if (this.metaData.getAuthorName() != null || s.length() <= 2) continue;
                    this.metaData.setAuthorName(s.substring(2));
                    continue;
                }
                if (s.startsWith("!:")) {
                    if (this.metaData.getTitle() != null || s.length() <= 2) continue;
                    this.metaData.setTitle(s.substring(2));
                    continue;
                }
                if (s.startsWith("D:")) {
                    if (this.metaData.getDate() != null || s.length() <= 2) continue;
                    this.metaData.setDate(s.substring(2));
                    continue;
                }
                if (s.startsWith("C:")) {
                    try {
                        int i1 = s.indexOf(32, 2);
                        this.properties.setBackgroundColor(JavePlayerUtilities.hexToColor(s.substring(2, i1)));
                        this.properties.setForegroundColor(JavePlayerUtilities.hexToColor(s.substring(i1 + 1)));
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of JavE Animation: " + s);
                    }
                    continue;
                }
                if (s.startsWith("*:")) {
                    if (this.metaData.getSoftware() != null || s.length() <= 2) continue;
                    this.metaData.setSoftware(s.substring(2));
                    continue;
                }
                if (!s.startsWith("#") || currentFrame == null) continue;
                currentFrame.setSoundTrigger(true);
            }
            if (currentFrame == null) break block37;
            this.frames.add(currentFrame);
        }
        Object var23_38 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (Exception exception) {}
        {
            return;
            catch (FileNotFoundException e) {
                throw new Exception("Error loading JavE Animation: File not found: '" + url + "'", e);
            }
            catch (IOException e) {
                throw new Exception("Error loading JavE Animation: Wrong file format.", e);
            }
        }
        catch (Throwable throwable) {
            Object var23_39 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
    }

    public final void add(JaveAnimationFrame newFrame) {
        this.frames.add(newFrame);
    }

    public final void insertFrame(JaveAnimationFrame newFrame, int index) {
        this.frames.add(index, newFrame);
    }

    public final void setFrameAt(JaveAnimationFrame newFrame, int index) {
        this.frames.set(index, newFrame);
    }

    public final void deleteFrame(int index) {
        this.frames.remove(index);
    }

    public final void moveFrameRight(int index) {
        Object frame = this.frames.get(index);
        this.frames.remove(index);
        this.frames.add(index + 1, frame);
    }

    public final void moveFrameLeft(int index) {
        this.moveFrameRight(index - 1);
    }

    public final void setFile(File file) {
        this.file = file;
    }

    public final File getFile() {
        return this.file;
    }

    public final JaveAnimationFrame getFrame(int index) {
        return (JaveAnimationFrame)this.frames.get(index);
    }

    public final int getFrameCount() {
        return this.frames.size();
    }
}

