/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.text;

import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveTextCursor;
import de.jave.jave.Plate;
import de.jave.jave.plate.ActiveEditorModel;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.preferences.BooleanPreferenceModel;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;

public final class CursorBlinkThread
extends Thread
implements FocusListener {
    private boolean shallStop = false;
    private boolean active;
    private boolean cursorShowing;
    private Plate currentPlate;
    private final BooleanPreferenceModel cursorBlockStyle;
    private boolean hasSelection = false;
    private boolean insert = false;

    public CursorBlinkThread(final ActiveEditorModel activePlateModel, BooleanPreferenceModel cursorBlockStyle) {
        super("CursorBlink");
        this.cursorBlockStyle = cursorBlockStyle;
        Ensure.ensureArgumentNotNull(activePlateModel);
        Ensure.ensureArgumentNotNull(cursorBlockStyle);
        activePlateModel.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void stateChanged(ChangeEvent e) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    IDocumentEditor activeEditor;
                    if (CursorBlinkThread.this.currentPlate != null) {
                        CursorBlinkThread.this.currentPlate.removeFocusListener(CursorBlinkThread.this);
                        if (CursorBlinkThread.this.active) {
                            CursorBlinkThread.this.currentPlate.setXORPainter(null);
                        }
                    }
                    if ((activeEditor = activePlateModel.getActiveEditor()) != null) {
                        Plate plate = activeEditor.getPlate();
                        plate.addFocusListener(CursorBlinkThread.this);
                        CursorBlinkThread.this.currentPlate = plate;
                    } else {
                        CursorBlinkThread.this.currentPlate = null;
                    }
                    return;
                }
            }
        });
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        while (!this.shallStop) {
            try {
                Thread.sleep(JaveGlobalRessources.cursorBlinkPause);
            }
            catch (InterruptedException interruptedException) {}
            CursorBlinkThread cursorBlinkThread = this;
            synchronized (cursorBlinkThread) {
                if (this.currentPlate != null && this.active && this.currentPlate.isFocusOwner() && !this.hasSelection) {
                    if (this.cursorShowing) {
                        if (JaveGlobalRessources.cursorBlink) {
                            this.removeCursor();
                        }
                    } else {
                        this.putCursor();
                    }
                }
            }
        }
    }

    public final void focusGained(FocusEvent evt) {
        this.interrupt();
    }

    public final void focusLost(FocusEvent evt) {
        this.removeCursor();
    }

    public final synchronized void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.putCursor();
            return;
        }
        this.removeCursor();
    }

    private synchronized void putCursor() {
        Point cursorLocation = this.currentPlate.getDocument().getCursorLocation();
        if (cursorLocation == null) {
            this.removeCursor();
            return;
        }
        int style = 1;
        if (this.insert) {
            style = 2;
        } else if (this.cursorBlockStyle.getValue()) {
            style = 3;
        }
        this.currentPlate.setXORPainter(new JaveTextCursor(this.currentPlate.getScreenPointFor(cursorLocation), style, this.currentPlate.getCharWidth(), this.currentPlate.getCharHeight()));
        this.cursorShowing = true;
    }

    private synchronized void removeCursor() {
        this.currentPlate.setXORPainter(null);
        this.cursorShowing = false;
    }

    public final synchronized void updateCursor() {
        this.removeCursor();
        this.interrupt();
    }

    public final void setHasSelection(boolean hasSelection) {
        this.hasSelection = hasSelection;
    }

    public final void setInsert(boolean insert) {
        this.insert = insert;
    }
}

