/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.fill;

import de.jave.gui.GTextArea;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.AsciiGradients;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.algorithm.fill.FillMatchMode;
import de.jave.jave.algorithm.fill.FillMode;
import de.jave.jave.algorithm.fill.GradientStyle;
import de.jave.jave.algorithm.fill.GradientStyleUi;
import de.jave.jave.pattern.Pattern;
import de.jave.jave.pattern.PatternDialog;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.MouseCharacterPanel;
import de.jave.jave.tool.fill.FillMatchModeUi;
import de.jave.jave.tool.fill.FillModeUi;
import de.jave.jave.tool.fill.FillOptions;
import de.jave.javeplayer.AsciiPacker;
import de.jave.lib.gui.GuiUtilities;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutDirection;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public final class FillOptionsPanel {
    private JComboBox chMatchMode;
    private JComboBox chGradient;
    private GTextArea patternTextArea;
    private JComboBox gradientComponent;
    private JCheckBox cbDither;
    private JTabbedPane tabbedPane;
    private PatternDialog patternDialog;
    private final JComponent content;
    private final FillOptions options;
    private final MouseCharacterModel mouseCharacterModel;

    public FillOptionsPanel(final FillOptions options, MouseCharacterModel mouseCharacterModel) {
        Ensure.ensureArgumentNotNull(options);
        Ensure.ensureArgumentNotNull(mouseCharacterModel);
        this.options = options;
        this.mouseCharacterModel = mouseCharacterModel;
        this.patternTextArea = new GTextArea(TextTools.toString(options.getPattern().getContent()), 6, 10);
        this.patternTextArea.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.patternTextArea.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                options.setPattern(new Pattern(AsciiPacker.encode(TextTools.toCharField(FillOptionsPanel.this.patternTextArea.getText()))));
            }
        });
        this.gradientComponent = AsciiGradients.createComponent();
        options.setGradient(this.getSelectedGradient());
        this.gradientComponent.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                options.setGradient(FillOptionsPanel.this.getSelectedGradient());
            }
        });
        this.chMatchMode = new JComboBox<FillMatchMode>(FillMatchMode.getAll());
        this.chMatchMode.setRenderer(new ObjectUiListCellRenderer(new FillMatchModeUi()));
        this.chMatchMode.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                options.setMatchMode((FillMatchMode)FillOptionsPanel.this.chMatchMode.getSelectedItem());
            }
        });
        this.chGradient = new JComboBox<GradientStyle>(GradientStyle.getAll());
        this.chGradient.setRenderer(new ObjectUiListCellRenderer(new GradientStyleUi()));
        this.chGradient.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                options.setGradientStyle((GradientStyle)FillOptionsPanel.this.chGradient.getSelectedItem());
            }
        });
        this.cbDither = new JCheckBox("dither", options.isDither());
        this.cbDither.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                options.setDither(FillOptionsPanel.this.cbDither.isSelected());
            }
        });
        JPanel gradientOptionsPanel = new JPanel(new GridDialogLayout(2, false));
        gradientOptionsPanel.add((Component)new JLabel("Gradient:"), GridDialogLayoutData.RIGHT);
        gradientOptionsPanel.add(this.gradientComponent);
        gradientOptionsPanel.add((Component)new JLabel("Style:"), GridDialogLayoutData.RIGHT);
        gradientOptionsPanel.add(this.chGradient);
        gradientOptionsPanel.add(this.cbDither);
        gradientOptionsPanel.setBorder(LayoutUtilities.getDefaultEmptyBorder());
        SmartAction choosePatternAction = new SmartAction("Choose..."){

            protected final void execute(Component parentComponent) {
                FillOptionsPanel.this.performChoosePattern(parentComponent);
            }
        };
        SmartAction addPatternAction = new SmartAction("Add..."){

            protected final void execute(Component parentComponent) {
                JTextField tfAuthor = new JTextField("n/a", 15);
                JTextField tfName = new JTextField("", 20);
                JPanel p = new JPanel(new GridDialogLayout(2, false));
                p.add((Component)new JLabel("Pattern Name:"), GridDialogLayoutData.RIGHT);
                p.add((Component)tfName, GridDialogLayoutData.FILL_HORIZONTAL);
                p.add((Component)new JLabel("Author:"), GridDialogLayoutData.RIGHT);
                p.add((Component)tfAuthor, GridDialogLayoutData.FILL_HORIZONTAL);
                GDialog gd = new GDialog(parentComponent, "Add as new pattern", p, GDialog.OK_CANCEL);
                gd.show();
                int result = gd.getAnswer();
                if (result == -1 || result == 1) {
                    return;
                }
                String name = tfName.getText();
                String author = tfAuthor.getText();
                if (name.trim().length() == 0) {
                    MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "The specified name is not a correct name for a pattern.", MessageType.ERROR));
                    return;
                }
                Pattern newPattern = new Pattern(name, options.getPattern().getCode(), author);
                PatternDialog dialog = FillOptionsPanel.this.getPatternDialog(parentComponent);
                dialog.addPattern(newPattern);
                FillOptionsPanel.this.showPatternDialog(parentComponent);
            }
        };
        ButtonPanelBuilder builder = new ButtonPanelBuilder(LayoutDirection.VERTICAL);
        builder.add(addPatternAction);
        builder.add(choosePatternAction);
        JPanel patternOptionsPanel = new JPanel(new BorderLayout());
        patternOptionsPanel.add((Component)this.patternTextArea.getContent(), "Center");
        patternOptionsPanel.add((Component)builder.createPanel(), "East");
        patternOptionsPanel.setBorder(LayoutUtilities.getDefaultEmptyBorder());
        JPanel solidPanel = new JPanel(new GridDialogLayout(1, false));
        solidPanel.add(new MouseCharacterPanel(mouseCharacterModel).getContent());
        solidPanel.setBorder(LayoutUtilities.getDefaultEmptyBorder());
        this.tabbedPane = new JTabbedPane();
        FillModeUi fillModeUi = new FillModeUi();
        this.tabbedPane.addTab(fillModeUi.getLabel(FillMode.SOLID), solidPanel);
        this.tabbedPane.addTab(fillModeUi.getLabel(FillMode.PATTERN), patternOptionsPanel);
        this.tabbedPane.addTab(fillModeUi.getLabel(FillMode.GRADIENT), gradientOptionsPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                int index = FillOptionsPanel.this.tabbedPane.getSelectedIndex();
                FillMode mode = FillMode.getAll()[index];
                options.setFillMode(mode);
            }
        });
        JPanel pMatchMode = new JPanel(new GridDialogLayout(2, false));
        pMatchMode.add((Component)new JLabel("Match Mode:"), GridDialogLayoutData.RIGHT);
        pMatchMode.add((Component)this.chMatchMode, GridDialogLayoutData.FILL_HORIZONTAL);
        JPanel optionsPanel = new JPanel(new GridDialogLayout(1, false));
        optionsPanel.add((Component)this.tabbedPane, GridDialogLayoutData.FILL_BOTH);
        optionsPanel.add((Component)pMatchMode, GridDialogLayoutData.FILL_HORIZONTAL);
        this.content = optionsPanel;
    }

    public final JComponent getContent() {
        return this.content;
    }

    private char[] getSelectedGradient() {
        String s = (String)this.gradientComponent.getSelectedItem();
        char[] ch = s.toCharArray();
        if (ch.length == 0) {
            ch = new char[]{this.mouseCharacterModel.getCharacter1()};
        }
        return ch;
    }

    private void performChoosePattern(Component parentComponent) {
        this.showPatternDialog(parentComponent);
    }

    private void showPatternDialog(Component parentComponent) {
        PatternDialog dialog = this.getPatternDialog(parentComponent);
        dialog.show();
        if (!dialog.isCanceled()) {
            this.setPattern(dialog.getSelectedPattern());
        }
    }

    private PatternDialog getPatternDialog(Component parentComponent) {
        if (this.patternDialog == null) {
            this.patternDialog = new PatternDialog(parentComponent);
            this.patternDialog.getDialog().pack();
            GuiUtilities.centerOnScreen(this.patternDialog.getDialog());
        }
        return this.patternDialog;
    }

    private void setPattern(Pattern pattern) {
        this.patternTextArea.setText(TextTools.toString(AsciiPacker.decode(pattern.getCode())));
        this.options.setPattern(pattern);
    }
}

