/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.ellipsealgorithmic;

import de.jave.jave.MixCharactersPanel;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.MouseCharacterPanel;
import de.jave.jave.tool.ellipsealgorithmic.AlgorithmicEllipseStyle;
import de.jave.jave.tool.ellipsealgorithmic.AlgorithmicEllipseStyleUi;
import de.jave.jave.tool.ellipsealgorithmic.EllipseAlgorithmicOptions;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public final class EllipseAlgorithmicOptionsPanel {
    private final JComponent content;
    private final EllipseAlgorithmicOptions options;

    public EllipseAlgorithmicOptionsPanel(final EllipseAlgorithmicOptions options, BooleanModel mixCharactersModel, MouseCharacterModel mouseCharacterModel) {
        this.options = options;
        final MouseCharacterPanel mouseCharacterPanel = new MouseCharacterPanel(mouseCharacterModel);
        final JComboBox<AlgorithmicEllipseStyle> chMode = new JComboBox<AlgorithmicEllipseStyle>(AlgorithmicEllipseStyle.getAll());
        chMode.setRenderer(new ObjectUiListCellRenderer(new AlgorithmicEllipseStyleUi()));
        chMode.setSelectedItem(options.getStyle());
        chMode.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                options.setStyle((AlgorithmicEllipseStyle)chMode.getSelectedItem());
                EllipseAlgorithmicOptionsPanel.this.updateMouseCharacterPanelEnabled(mouseCharacterPanel);
            }
        });
        this.updateMouseCharacterPanelEnabled(mouseCharacterPanel);
        MixCharactersPanel mixCharactersPanel = new MixCharactersPanel(mixCharactersModel);
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        panel.add(new JLabel("Style:"));
        panel.add(chMode);
        GridDialogLayoutData data = new GridDialogLayoutData();
        data.setHorizontalSpan(2);
        panel.add((Component)mouseCharacterPanel.getContent(), data);
        panel.add((Component)mixCharactersPanel.getContent(), data);
        this.content = panel;
    }

    protected final void updateMouseCharacterPanelEnabled(MouseCharacterPanel mouseCharacterPanel) {
        mouseCharacterPanel.setEnabled(this.options.getStyle() == AlgorithmicEllipseStyle.CHARACTERS);
    }

    public final JComponent getContent() {
        return this.content;
    }
}

