/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.dialog;

import de.jave.gui.SmallFrame;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.Jave;
import de.jave.jave.Tool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.util.Ensure;

public final class ToolOptionsDialog {
    private Tool tool;
    private Jave jave;
    private final SmallFrame smallFrame;
    private final JDialog dialog;
    private final Container contentPane;
    private final BooleanModel model;

    public ToolOptionsDialog(Jave jave, boolean small, BooleanModel model) {
        Ensure.ensureArgumentNotNull(jave);
        Ensure.ensureArgumentNotNull(model);
        this.jave = jave;
        this.model = model;
        if (small) {
            JPanel panel = new JPanel();
            this.contentPane = panel;
            this.smallFrame = new SmallFrame(jave.getFrame(), "Tool Options", panel);
            this.dialog = null;
        } else {
            this.dialog = GDialog.createJDialog(jave.getFrame(), "Tool Options", false);
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.addWindowListener(new WindowAdapter(){

                public final void windowClosing(WindowEvent e) {
                    ToolOptionsDialog.this.model.setValue(false);
                }
            });
            this.contentPane = this.dialog.getContentPane();
            this.smallFrame = null;
        }
        model.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                ToolOptionsDialog.this.updateVisibility();
            }
        });
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (this.smallFrame != null) {
            this.smallFrame.setVisible(this.model.getValue());
            return;
        }
        this.dialog.setVisible(this.model.getValue());
    }

    public final void setTool(Tool tool) {
        JComponent oldOptionsComponent = this.tool == null ? null : this.tool.getOptionsComponent();
        JComponent newOptionsComponent = tool.getOptionsComponent();
        this.tool = tool;
        if (oldOptionsComponent == newOptionsComponent) {
            return;
        }
        if (this.smallFrame != null) {
            this.contentPane.removeAll();
            this.contentPane.add((Component)newOptionsComponent, "Center");
            this.smallFrame.setTitle(tool.getName() + " Options");
            this.smallFrame.pack();
            return;
        }
        this.dialog.setEnabled(false);
        this.contentPane.removeAll();
        this.dialog.setResizable(true);
        this.contentPane.add((Component)newOptionsComponent, "Center");
        this.dialog.setTitle(tool.getName() + " Options");
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setEnabled(true);
        this.jave.toFront();
        this.jave.getMainPanel().requestFocus();
    }

    public final Point getLocation() {
        if (this.smallFrame != null) {
            return this.smallFrame.getLocation();
        }
        return this.dialog.getLocation();
    }

    public final void toFront() {
        if (this.smallFrame != null) {
            this.smallFrame.toFront();
            return;
        }
        this.dialog.toFront();
    }

    public final void pack() {
        if (this.smallFrame != null) {
            this.smallFrame.pack();
            return;
        }
        this.dialog.pack();
    }

    public final void show() {
        this.setVisible(true);
    }

    public final void setVisible(boolean what) {
        if (this.smallFrame != null) {
            this.smallFrame.setVisible(what && this.model.getValue());
            return;
        }
        this.dialog.setVisible(what && this.model.getValue());
    }

    public final void setLocation(Point location) {
        int x = location.x;
        int y = location.y;
        if (this.smallFrame != null) {
            this.smallFrame.setLocation(x, y);
            return;
        }
        this.dialog.setLocation(x, y);
    }
}

