/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.preferences;

import de.jave.ascii.IAsciiGuiConstants;
import de.jave.jave.preferences.BooleanPreferenceModel;
import de.jave.preferences.JavePreferences;
import de.jave.preferences.SmartPreferences;
import de.jave.util.RecentFileList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.swing.fontchooser.model.FontModel;

public final class JaveApplicationPreferences
extends SmartPreferences {
    private static final String DEFAULT_DISPLAY_FONT_NAME = IAsciiGuiConstants.DEFAULT_ASCII_FONT.getName();
    private final RecentFileList recentFileList = new RecentFileList(new SmartPreferences(this.getSubPreferences("recentFiles")));
    private final FileModel currentDirectoryModel = new FileModel();
    private final BooleanPreferenceModel cursorBlockStyleModel;
    private final FontModel displayFontModel;

    public JaveApplicationPreferences(JavePreferences javePreferences) {
        super(javePreferences.getSubPreferences("application"));
        String directory = this.get("currentDirectory", null);
        if (directory != null) {
            this.currentDirectoryModel.setFile(new File(directory));
        }
        this.currentDirectoryModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                File currentDirectory = JaveApplicationPreferences.this.currentDirectoryModel.getFile();
                JaveApplicationPreferences.this.put("currentDirectory", currentDirectory);
                JaveApplicationPreferences.this.flush();
            }
        });
        this.cursorBlockStyleModel = new BooleanPreferenceModel(this, "cursorBlockStyle", false);
        this.displayFontModel = new FontModel(this.getFont("font"));
        this.displayFontModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                JaveApplicationPreferences.this.putFont("font", JaveApplicationPreferences.this.displayFontModel.getFont());
                JaveApplicationPreferences.this.flush();
            }
        });
    }

    public final FontModel getDisplayFontModel() {
        return this.displayFontModel;
    }

    private void putFont(String keyPrefix, Font font) {
        this.put(keyPrefix + "Name", font.getName());
        this.putInt(keyPrefix + "Size", font.getSize());
        this.putInt(keyPrefix + "Style", font.getStyle());
    }

    private Font getFont(String keyPrefix) {
        String fontName = this.get(keyPrefix + "Name", DEFAULT_DISPLAY_FONT_NAME);
        int fontSize = this.getInt(keyPrefix + "Size", 13);
        int fontStyle = this.getInt(keyPrefix + "Style", 0);
        return new Font(fontName, fontStyle, fontSize);
    }

    public final Rectangle getApplicationFrameBounds() {
        int x = this.getInt("frameX", 0);
        int y = this.getInt("frameY", 10);
        int w = this.getInt("frameWidth", 787);
        int h = this.getInt("frameHeight", 537);
        return new Rectangle(x, y, w, h);
    }

    public final Point getToolDialogLocation() {
        int x = this.getInt("toolDialogLocationX", 600);
        int y = this.getInt("toolDialogLocationY", 90);
        return new Point(x, y);
    }

    public final void setToolDialogLocation(Point location) {
        this.putInt("toolDialogLocationX", location.x);
        this.putInt("toolDialogLocationY", location.y);
    }

    public final RecentFileList getRecentFileList() {
        return this.recentFileList;
    }

    public final Dimension getDefaultDocumentSize() {
        return new Dimension(this.getInt("documentWidth", 71), this.getInt("documentHeight", 30));
    }

    public final void setDefaultDocumentSize(Dimension size) {
        this.putInt("documentWidth", size.width);
        this.putInt("documentHeight", size.height);
    }

    public final FileModel getCurrectDirectoryModel() {
        return this.currentDirectoryModel;
    }

    public final String getAuthorName() {
        return this.get("authorName", "");
    }

    public final void setAuthorName(String authorName) {
        this.put("authorName", authorName);
    }

    public final String getAuthorMail() {
        return this.get("authorMail", "");
    }

    public final void setAuthorMail(String authorMail) {
        this.put("authorMail", authorMail);
    }

    public final BooleanPreferenceModel getCursorBlockStyleModel() {
        return this.cursorBlockStyleModel;
    }

    public final int getApplicationFrameState() {
        return this.getInt("frameState", 0);
    }

    public final void setApplicationFrameState(int frameState, Rectangle bounds) {
        this.putInt("frameState", frameState);
        if (frameState != 6) {
            this.putInt("frameX", bounds.x);
            this.putInt("frameY", bounds.y);
            this.putInt("frameWidth", bounds.width);
            this.putInt("frameHeight", bounds.height);
        }
    }
}

