/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.plate;

import de.jave.gui.CharField;
import de.jave.gui.CharacterModel;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.plate.MouseCharacterModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;

public final class MouseCharacterPanel {
    private final CharacterModel cf1 = new CharacterModel();
    private final CharacterModel cf2 = new CharacterModel();
    private final CharField cfChar1 = new CharField(this.cf1);
    private final CharField cfChar2;
    private final JLabel iconLabel;
    private final JComponent content;

    public MouseCharacterPanel(final MouseCharacterModel model) {
        this.cfChar1.setToolTipText("Character on Left Mouse Button");
        this.cfChar1.setFont(JaveGlobalRessources.FONT_DEFAULT);
        this.cfChar1.setBackground(JaveGlobalRessources.COLOR_CHARFIELD_BACK);
        this.cf1.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                model.setCharacter1(MouseCharacterPanel.this.cf1.getCharacter());
            }
        });
        this.iconLabel = new JLabel(JaveImageProvider.getInstance().getImageIcon("mouse.gif"));
        this.iconLabel.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent evt) {
                if (MouseCharacterPanel.this.iconLabel.isEnabled()) {
                    char ch1 = MouseCharacterPanel.this.cf1.getCharacter();
                    char ch2 = MouseCharacterPanel.this.cf2.getCharacter();
                    model.setCharacter1(ch2);
                    model.setCharacter2(ch1);
                }
            }
        });
        this.cfChar2 = new CharField(this.cf2);
        this.cfChar2.setToolTipText("Character on Right Mouse Button");
        this.cfChar2.setFont(JaveGlobalRessources.FONT_DEFAULT);
        this.cfChar2.setBackground(JaveGlobalRessources.COLOR_CHARFIELD_BACK);
        this.cf2.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                model.setCharacter2(MouseCharacterPanel.this.cf2.getCharacter());
            }
        });
        JPanel panel = new JPanel(new GridDialogLayout(3, false, 0, 0));
        panel.add(this.cfChar1);
        panel.add(this.iconLabel);
        panel.add(this.cfChar2);
        this.content = panel;
        model.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                MouseCharacterPanel.this.updateView(model);
            }
        });
        this.updateView(model);
    }

    private void updateView(MouseCharacterModel model) {
        this.cf1.setCharacter(model.getCharacter1());
        this.cf2.setCharacter(model.getCharacter2());
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void setEnabled(boolean enabled) {
        this.cfChar1.setEnabled(enabled);
        this.cfChar2.setEnabled(enabled);
        this.iconLabel.setEnabled(enabled);
    }
}

