/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.plate;

import de.jave.awt.clipboard.JaveClipboardSelection;
import de.jave.gui.StatusBar;
import de.jave.jave.CompressedDocumentState;
import de.jave.jave.Jave;
import de.jave.jave.JaveSelection;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.Selection;
import de.jave.jave.SelectionTool;
import de.jave.jave.Tool;
import de.jave.jave.browser.JaveDocumentTypeUi;
import de.jave.jave.plate.ActiveEditorModel;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.ToolManager;
import de.jave.jave.watermark.IWatermarkPainter;
import de.jave.lib.CharacterPlate;
import de.jave.swing.tabbedpane.ISmartTabbedPaneCloseListener;
import de.jave.swing.tabbedpane.SmartTabbedPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.util.Ensure;

public final class JaveMainPanel {
    private final ToolManager toolManager = new ToolManager();
    private final List editors = new LinkedList();
    private final SmartTabbedPane tabbedPane;
    private final StatusBar status;
    private final MouseCharacterModel mouseCharacterModel;
    private final List watermarkPainters = new ArrayList();
    private final ActiveEditorModel activeEditorModel = new ActiveEditorModel();
    private final BooleanModel mixCharactersModel = new BooleanModel(true);

    public JaveMainPanel(final Jave jave, StatusBar status, MouseCharacterModel mouseCharacterModel) {
        Ensure.ensureArgumentNotNull(mouseCharacterModel);
        this.status = status;
        this.mouseCharacterModel = mouseCharacterModel;
        this.tabbedPane = new SmartTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                JaveMainPanel.this.activeEditorModel.setActiveEditor(JaveMainPanel.this.getEditor());
            }
        });
        this.tabbedPane.addCloseListener(new ISmartTabbedPaneCloseListener(this){

            public final void tabClosing(SmartTabbedPane tabbedPane, int tabIndex) {
                jave.setCurrentDocument(tabIndex);
                jave.doClose(tabbedPane);
            }
        });
    }

    public final synchronized void addPlate(IDocumentEditor editor) {
        Plate plate = editor.getPlate();
        plate.setStatusDisplay(this.status);
        Iterator iter = this.watermarkPainters.iterator();
        while (iter.hasNext()) {
            IWatermarkPainter painter = (IWatermarkPainter)iter.next();
            plate.addWatermarkPainter(painter);
        }
        Icon icon = JaveDocumentTypeUi.getIcon(editor.getType());
        this.tabbedPane.addTab("", icon, editor.getContent());
        this.editors.add(editor);
        this.updateAllDocumentTitles();
        this.activeEditorModel.setActiveEditor(editor);
    }

    public final void updateAllDocumentTitles() {
        for (int i = 0; i < this.getEditorCount(); ++i) {
            IDocumentEditor editor = this.getEditor(i);
            String title = DocumentEditorTitleFactory.createEditorTabTitle(editor);
            this.tabbedPane.setTitleAt(i, title);
        }
    }

    public final Tool getCurrentTool() {
        return this.toolManager.getCurrentTool();
    }

    public final void setCurrentTool(Tool tool) {
        if (this.getCurrentTool() == tool) {
            return;
        }
        if (this.getCurrentTool() != null) {
            this.getCurrentTool().putAside(tool instanceof SelectionTool);
        }
        this.toolManager.setCurrentTool(tool);
        tool.takeToHand();
        this.requestFocus();
        Plate plate = this.getPlate();
        if (plate != null) {
            plate.setCursor(tool.getCursor());
            if (plate.getSize().height != 0) {
                plate.repaint();
            }
        }
    }

    public final Component getContent() {
        return this.tabbedPane;
    }

    public final synchronized PlateDocument getDocument() {
        Plate plate = this.getPlate();
        if (plate == null) {
            return null;
        }
        return plate.getDocument();
    }

    public final void saveCurrentState(String string) {
        this.getPlate().saveCurrentState(string);
    }

    public final void repaint() {
        Plate plate = this.getPlate();
        if (plate != null) {
            plate.repaint();
        }
    }

    public final void requestFocus() {
        Plate plate = this.getPlate();
        if (plate != null) {
            plate.requestFocus();
        }
    }

    public final boolean hasSelection() {
        Plate plate = this.getPlate();
        if (plate == null) {
            return false;
        }
        return plate.hasSelection();
    }

    public final synchronized void setCurrentEditor(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public final void selectAll() {
        this.getPlate().selectAll();
    }

    public final void unselect() {
        this.getPlate().unselect();
    }

    public final void shrinkSelection() {
        this.getPlate().shrinkSelection();
    }

    public final void expandSelection() {
        this.getPlate().expandSelection();
    }

    public final CharacterPlate getSelectionContent() {
        return this.getPlate().getSelectionContent();
    }

    public final void setContentOfInterest(JaveSelection sel) {
        this.getPlate().setContentOfInterest(sel);
        this.getCurrentTool().checkSize();
    }

    public final void revalidate() {
        this.getPlate().revalidate();
    }

    public final Rectangle getSelectionRegion() {
        return this.getPlate().getSelectionRegion();
    }

    public final void dropSelection() {
        this.getPlate().dropSelection();
    }

    public final void setSelection(Rectangle braceRegion, CharacterPlate cp) {
        this.getPlate().setSelection(braceRegion, cp);
    }

    public final synchronized Plate getPlate() {
        IDocumentEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        return editor.getPlate();
    }

    public final synchronized IDocumentEditor getEditor() {
        if (this.editors.size() == 0) {
            return null;
        }
        int index = this.tabbedPane.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return (IDocumentEditor)this.editors.get(index);
    }

    public final Selection getSelection() {
        return this.getPlate().getSelection();
    }

    public final void clear() {
        this.getPlate().clear();
        this.getCurrentTool().reset();
    }

    public final boolean canUndo() {
        Plate plate = this.getPlate();
        if (plate == null) {
            return false;
        }
        return plate.canUndo();
    }

    public final boolean canRedo() {
        Plate plate = this.getPlate();
        if (plate == null) {
            return false;
        }
        return plate.canRedo();
    }

    public final String getUndoActionName() {
        return this.getPlate().getUndoActionName();
    }

    public final String getRedoActionName() {
        return this.getPlate().getRedoActionName();
    }

    public final void redo() {
        this.getPlate().redo();
    }

    public final void undo() {
        this.getPlate().undo();
    }

    public final void setPlateSize(int newWidth, int newHeight) {
        this.getPlate().setPlateSize(newWidth, newHeight);
    }

    public final void zoomIn() {
        this.getPlate().zoomIn();
    }

    public final void zoomOut() {
        this.getPlate().zoomOut();
    }

    public final CompressedDocumentState getDocumentState(String actionName) {
        return this.getPlate().getDocumentState(actionName);
    }

    public final JaveSelection getContentOfInterest() {
        return this.getPlate().getContentOfInterest();
    }

    public final void setSelectionContent(CharacterPlate cp) {
        this.getPlate().setSelectionContent(cp);
    }

    public final void setContentOfInterest(CharacterPlate cp) {
        if (this.getPlate().hasSelection()) {
            this.getPlate().setSelectionContent(cp);
        } else {
            this.getPlate().setContent(cp);
        }
        this.getCurrentTool().checkSize();
    }

    public final void pasteAsNewSelection(CharacterPlate content, Point location) {
        this.getPlate().pasteAsNewSelection(content, location);
    }

    public final void pasteAsNewSelection(JaveClipboardSelection sel, Point location) {
        this.getPlate().pasteAsNewSelection(sel, location);
    }

    public final Point getPasteLocation() {
        return this.getPlate().getPasteLocation();
    }

    public final void repaintCursor() {
        Plate plate = this.getPlate();
        if (plate != null) {
            plate.repaintCursor();
        }
    }

    public final synchronized void closeCurrentEditor() {
        int index = this.tabbedPane.getSelectedIndex();
        this.editors.remove(index);
        this.tabbedPane.remove(index);
        this.activeEditorModel.setActiveEditor(this.getEditor());
    }

    public final void showStatus(String text) {
        this.status.showStatus(text);
    }

    public final ToolManager getToolManager() {
        return this.toolManager;
    }

    public final Dimension getDocumentSize() {
        PlateDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        return document.getSize();
    }

    public final MouseCharacterModel getMouseCharacterModel() {
        return this.mouseCharacterModel;
    }

    public final void addWatermarkPainter(IWatermarkPainter painter) {
        this.watermarkPainters.add(painter);
    }

    public final ActiveEditorModel getActiveEditorModel() {
        return this.activeEditorModel;
    }

    public final BooleanModel getMixCharactersModel() {
        return this.mixCharactersModel;
    }

    public final IDocumentEditor getEditor(int index) {
        return (IDocumentEditor)this.editors.get(index);
    }

    public final int getEditorCount() {
        return this.editors.size();
    }
}

