/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.games.asctris;

import de.jave.jave.Jave;
import de.jave.jave.JaveGame;
import de.jave.jave.LineAlgorithm;
import de.jave.jave.RectangleAlgorithm;
import de.jave.jave.algorithm.rectangle.RectangleStyle;
import de.jave.jave.games.asctris.AscTrisBlock;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.tool.linealgorithmic.AlgorithmicLineStyle;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public final class AscTris
extends JaveGame
implements Runnable {
    private AscTrisBlock currentBlock;
    private AscTrisBlock nextBlock;
    private static final int[] PAUSE_FOR_LEVEL = new int[]{800, 700, 600, 500, 410, 370, 335, 310, 290};
    private static final int[] SCORE_FOR_LINES = new int[]{40, 100, 300, 1200};
    private boolean shallStop;
    private Thread thread;
    private boolean paused = false;
    private int score;
    private int level;
    private int dropStop;
    private Object synchy = new Object();
    private CharacterPlate tmpBuffer;

    public AscTris(Jave jave) {
        super(jave);
    }

    public final Dimension getPreferredSize() {
        return new Dimension(64, 33);
    }

    protected final String getTitle() {
        return "Asc-Tris 2.0";
    }

    protected final ColorScheme getPreferredColorScheme() {
        return ColorScheme.WHITE_ON_BLACK;
    }

    public final void startGame() {
        this.shallStop = true;
        this.paused = false;
        while (this.thread != null) {
            this.thread.interrupt();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        PixelPlate mp = new PixelPlate(0, 0, 64, 33);
        mp.setMode(PixelPlateMode.CHAR);
        LineAlgorithm.drawLine(mp, 2.0, 0.0, 2.0, 32.0, AlgorithmicLineStyle.VERONICA);
        LineAlgorithm.drawLine(mp, 33.0, 0.0, 33.0, 32.0, AlgorithmicLineStyle.VERONICA);
        LineAlgorithm.drawLine(mp, 2.0, 32.0, 33.0, 32.0, AlgorithmicLineStyle.VERONICA);
        this.plate.clear();
        mp.pasteResultInto(this.plate);
        this.plate.paste("~~~~~~~~~~~~~~", 36, 1);
        this.plate.paste("Score:", 37, 3);
        this.plate.paste("Level:", 37, 2);
        this.plate.paste("~~~~~~~~~~~~~~", 36, 4);
        this.plate.paste("Next:", 35, 23);
        this.plate.paste("  left: Cursor Left\n right: Cursor Right\n  drop: Space\nrotate: Cursor Up\n pause: P\n  quit: Q\nstart new game: S", 35, 6);
        this.plate.paste(".-------.\n|       |\n|       |\n|       |\n|       |\n| _____ |\n||_   _||\n|  | |  |\n|  | |  |\n|  |_|  |\n| ____  |\n||  _ \\ |\n|| |_)/ |\n|| ,-.\\ |\n||_| |_\\|\n'   _   |\n   | |  |\n   | |  |\n   | |  |\n.  |_|  |\n|       |\n| .----.|\n|/   __/|\n|\\___  \\|\n|/     /|\n|`----' |\n|       |\n|   _   |\n| .\\_/. |\n| ||a|| |\n| `/_\\' |\n|       |\n`-------'", 55, 0);
        this.plate.paste(",---------------\n| .-. .-.  .-.\n| .-| `-. (   <>\n| `-^ `-'  `-'\n`---------------", 39, 15);
        this.shallStop = false;
        this.thread = new Thread((Runnable)this, "AscTris");
        this.thread.start();
        this.requestFocus();
    }

    protected final void keyTyped(KeyEvent evt, int code, char ch) {
        if (this.paused) {
            this.plate.delete(4, 11, 30, 14);
            this.tmpBuffer.pasteInto(this.plate, 4, 11);
            this.repaint();
            this.paused = false;
            return;
        }
        if (ch == 'p' && this.thread != null && !this.shallStop) {
            this.paused = true;
            this.tmpBuffer = this.plate.getCopy(4, 11, 27, 4);
            RectangleAlgorithm.drawRectangle(this.plate, new Rectangle(4, 11, 27, 4), RectangleAlgorithm.getCharsForStyle(RectangleStyle.NORMAL));
            this.plate.paste("       * Paused *        ", 5, 12);
            this.plate.paste(" Hit any key to continue ", 5, 13);
            this.repaint();
            return;
        }
        if (ch == 's') {
            this.startGame();
            return;
        }
        if (ch == 'q') {
            this.shallStop = true;
            this.thread = null;
            this.quit();
            return;
        }
    }

    protected final void keyPressed(KeyEvent evt, int code, char ch) {
        if (this.thread == null || this.shallStop || this.paused) {
            return;
        }
        if (ch == ' ') {
            this.drop();
            return;
        }
        if (code == 37) {
            this.moveLeft();
            return;
        }
        if (code == 39) {
            this.moveRight();
            return;
        }
        if (code == 40) {
            this.down();
            return;
        }
        if (code == 38) {
            this.rotateLeft();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.currentBlock = new AscTrisBlock();
        this.currentBlock.xPos = 12;
        this.currentBlock.yPos = 0;
        this.currentBlock.pasteInto(this.plate);
        this.nextBlock = new AscTrisBlock();
        this.nextBlock.xPos = 41;
        this.nextBlock.yPos = 24;
        this.nextBlock.pasteInto(this.plate);
        this.dropStop = 1;
        this.setLevel(1);
        this.resetScore();
        int lineCount = 0;
        long time1 = System.currentTimeMillis();
        while (!this.shallStop) {
            long wait = (long)PAUSE_FOR_LEVEL[this.level - 1] - (System.currentTimeMillis() - time1);
            if (wait > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {}
            }
            while (!(this.enabled && !this.paused || this.shallStop)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            time1 = System.currentTimeMillis();
            if (this.shallStop) break;
            Object object = this.synchy;
            synchronized (object) {
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.moveDown();
                if (this.currentBlock.fits(this.plate)) {
                    this.currentBlock.pasteInto(this.plate);
                    --this.dropStop;
                } else {
                    int newLevel;
                    this.dropStop = 1;
                    this.currentBlock.moveUp();
                    this.currentBlock.pasteInto(this.plate);
                    Thread.currentThread();
                    Thread.yield();
                    int countFull = 0;
                    for (int y = 0; y <= 31; y += 2) {
                        boolean full = true;
                        for (int x = 3; x <= 32 && full; ++x) {
                            if (this.plate.get(x, y) != ' ') continue;
                            full = false;
                        }
                        if (!full) continue;
                        ++countFull;
                        ++lineCount;
                        this.fadeLine(y);
                        for (int yy = y - 1; yy >= 0; --yy) {
                            for (int xx = 3; xx <= 32; ++xx) {
                                this.plate.setForce(xx, yy + 2, this.plate.get(xx, yy));
                            }
                        }
                    }
                    if (countFull > 0) {
                        if (countFull - 1 >= SCORE_FOR_LINES.length) {
                            countFull = SCORE_FOR_LINES.length;
                        }
                        this.addScore(this.level * SCORE_FOR_LINES[countFull - 1]);
                    }
                    if ((newLevel = lineCount / 6) <= 9 && newLevel > this.level) {
                        this.setLevel(newLevel);
                    }
                    this.nextBlock.removeFrom(this.plate);
                    this.currentBlock = this.nextBlock;
                    this.currentBlock.xPos = 12;
                    this.currentBlock.yPos = 0;
                    while (this.currentBlock.isInside()) {
                        this.currentBlock.moveUp();
                    }
                    this.currentBlock.moveDown();
                    if (!this.currentBlock.fits(this.plate)) {
                        RectangleAlgorithm.drawRectangle(this.plate, new Rectangle(10, 12, 17, 3), RectangleAlgorithm.getCharsForStyle(RectangleStyle.NORMAL));
                        this.plate.paste(" * Game Over * ", 11, 13);
                        this.shallStop = true;
                        this.thread = null;
                        this.repaint();
                    } else {
                        this.currentBlock.pasteInto(this.plate);
                        this.nextBlock = new AscTrisBlock();
                        this.nextBlock.xPos = 41;
                        this.nextBlock.yPos = 24;
                        this.nextBlock.pasteInto(this.plate);
                    }
                }
                this.repaint();
            }
        }
        this.document.setModified(false);
        this.thread = null;
    }

    protected final void fadeLine(int y) {
        for (int i = 0; i < 6; ++i) {
            for (int x = 3; x <= 32; ++x) {
                for (int line = 0; line <= 1; ++line) {
                    int shade = " :=8OSXZBEW#M".indexOf(this.plate.get(x, y + line));
                    if (shade < 0) {
                        shade = 0;
                    }
                    this.plate.setForce(x, y + line, " :=8OSXZBEW#M".charAt(shade /= 2));
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void rotateLeft() {
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            this.currentBlock.rotateLeft();
            if (!this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveRight();
                if (!this.currentBlock.fits(this.plate)) {
                    this.currentBlock.moveLeft();
                }
            }
            if (!this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveLeft();
                if (!this.currentBlock.fits(this.plate)) {
                    this.currentBlock.moveRight();
                }
            }
            if (this.currentBlock.fits(this.plate)) {
                this.currentBlock.rotateRight();
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.rotateLeft();
                this.currentBlock.pasteInto(this.plate);
                this.repaint();
            } else {
                this.currentBlock.rotateRight();
                this.currentBlock.pasteInto(this.plate);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void moveLeft() {
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            this.currentBlock.moveLeft();
            if (this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveRight();
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.moveLeft();
                this.currentBlock.pasteInto(this.plate);
                this.repaint();
            } else {
                this.currentBlock.moveRight();
                this.currentBlock.pasteInto(this.plate);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void moveRight() {
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            this.currentBlock.moveRight();
            if (this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveLeft();
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.moveRight();
                this.currentBlock.pasteInto(this.plate);
                this.repaint();
            } else {
                this.currentBlock.moveLeft();
                this.currentBlock.pasteInto(this.plate);
            }
            return;
        }
    }

    protected final void down() {
        this.thread.interrupt();
        this.addScore(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void drop() {
        if (this.dropStop > 0) {
            return;
        }
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            int count = 0;
            do {
                this.currentBlock.moveDown();
                ++count;
            } while (this.currentBlock.fits(this.plate));
            this.currentBlock.moveUp();
            this.addScore(--count);
            this.repaint();
        }
        this.thread.interrupt();
    }

    protected final void addScore(int value) {
        this.setScore(this.score + value);
    }

    protected final void resetScore() {
        this.setScore(0);
    }

    protected final void setScore(int value) {
        this.score = value;
        this.plate.paste(this.score + "   ", 44, 3);
        this.repaint();
    }

    protected final void setLevel(int value) {
        this.level = value;
        this.plate.paste(this.level + "   ", 44, 2);
        this.repaint();
    }
}

