/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.figlet.export;

import de.jave.figlet.engine.primitives.FigFont;
import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.io.FigFontFileParser;
import de.jave.figlet.swing.ui.FigletIcons;
import de.jave.figlet.util.FigException;
import de.jave.jave.figlet.FigletFontTestDialog;
import de.jave.jave.figlet.export.AbstractFigletExportWizardPage;
import de.jave.jave.figlet.export.FigletExportModel;
import de.jave.jave.figlet.export.FigletFileExporter;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class FigletExportWizardPage4
extends AbstractFigletExportWizardPage {
    private JCheckBox[] chSmushing;
    private JComboBox chHDefaultLayout;
    private JComboBox chVDefaultLayout;
    private static final String[] SMUSHING = new String[]{"Equal character smushing", "Underscore smushing", "Hierarchy smushing", "Opposite pair smushing", "Big X smushing", "Hardblank smushing", "Equal character smushing", "Underscore smushing", "Hierarchy smushing", "Horizontal line smushing", "Vertical line supersmushing"};
    private static final int[] SMUSHING_SUMMANDS = new int[]{1, 2, 4, 8, 16, 32, 256, 512, 1024, 2048, 4096};

    public FigletExportWizardPage4(FigletExportModel model) {
        super(model, "Layout Adjustments", (IBasicMessage)new BasicMessage("Take a minute to carefully adjust the layout rules. Also don't forget to test the font and the settings."));
    }

    protected final IBasicMessage createCurrentMessage() {
        return this.getDefaultMessage();
    }

    protected final JComponent createContent() {
        JPanel pb1 = new JPanel();
        pb1.setBorder(new TitledBorder("horizontal"));
        pb1.setLayout(new GridDialogLayout(1, false));
        this.chHDefaultLayout = new JComboBox<String>(new String[]{"Smushing", "Kerning", "Full Width"});
        this.chHDefaultLayout.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                FigletExportWizardPage4.this.updateModel();
            }
        });
        JPanel pb1a = new JPanel();
        pb1a.add(new JLabel("Default layout:"));
        pb1a.add(this.chHDefaultLayout);
        pb1.add(pb1a);
        this.chSmushing = new JCheckBox[11];
        for (int i = 0; i < 6; ++i) {
            this.chSmushing[i] = new JCheckBox(SMUSHING[i], true);
            this.chSmushing[i].addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    FigletExportWizardPage4.this.updateModel();
                }
            });
            pb1.add(this.chSmushing[i]);
        }
        JPanel pb2 = new JPanel();
        pb2.setBorder(new TitledBorder("vertical"));
        pb2.setLayout(new GridDialogLayout(1, false));
        this.chVDefaultLayout = new JComboBox<String>(new String[]{"Smushing", "Fitting", "Full Height"});
        this.chVDefaultLayout.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                FigletExportWizardPage4.this.updateModel();
            }
        });
        JPanel pb2a = new JPanel();
        pb2a.add(new JLabel("Default layout:"));
        pb2a.add(this.chVDefaultLayout);
        pb2.add(pb2a);
        for (int i = 6; i < 11; ++i) {
            this.chSmushing[i] = new JCheckBox(SMUSHING[i], true);
            this.chSmushing[i].addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    FigletExportWizardPage4.this.updateModel();
                }
            });
            pb2.add(this.chSmushing[i]);
        }
        JPanel mainPanel = new JPanel(new GridLayout(0, 2));
        mainPanel.add(pb1);
        mainPanel.add(pb2);
        SmartAction bTest = new SmartAction("Verify the settings by testing the font.", FigletIcons.FIGLET_ICON){

            protected final void execute(Component parentComponent) {
                try {
                    FigletExportWizardPage4.this.testFont(parentComponent);
                    return;
                }
                catch (IOException iOException) {
                    IOException e = iOException;
                    iOException.printStackTrace();
                    return;
                }
                catch (FigException figException) {
                    FigException e = figException;
                    figException.printStackTrace();
                    return;
                }
            }
        };
        JPanel panel = new JPanel(new GridDialogLayout(1, false));
        panel.add((Component)mainPanel, GridDialogLayoutData.FILL_BOTH);
        panel.add(new JButton(bTest));
        return panel;
    }

    private void testFont(Component parentComponent) throws IOException, FigException {
        final File file = File.createTempFile("testFont", ".flf");
        file.deleteOnExit();
        FigletFileExporter.export(this.getModel(), file);
        FigFont font = new FigFontFileParser().load(new FigFileName("test font"), new IFigFileResource(this){

            public final FigFileName[] loadFigletFileNames() throws FigException {
                throw new UnsupportedOperationException();
            }

            public final InputStream openConfigurationFileInputStream(String fileName) throws FigException {
                throw new UnsupportedOperationException();
            }

            public final InputStream openFigFileInputStream(FigFileName fileName) throws FigException {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new FigException("Font file not found.", e, 7);
                }
            }

            public final String getRourceBaseDescription() {
                throw new UnsupportedOperationException();
            }
        });
        FigletFontTestDialog testFigletDialog = new FigletFontTestDialog(parentComponent, "FIGlet Editor - Test new font", font);
        testFigletDialog.setText("Testing this great\nnew Font!");
        testFigletDialog.show();
    }

    private void updateModel() {
        int hSmushing = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.chSmushing[i].isSelected()) continue;
            hSmushing += SMUSHING_SUMMANDS[i];
        }
        int vSmushing = 0;
        for (int i = 6; i < 11; ++i) {
            if (!this.chSmushing[i].isSelected()) continue;
            vSmushing += SMUSHING_SUMMANDS[i];
        }
        int oldLayout = 0;
        int fullLayout = hSmushing + vSmushing;
        switch (this.chHDefaultLayout.getSelectedIndex()) {
            case 0: {
                fullLayout += 128;
                oldLayout = hSmushing;
                break;
            }
            case 1: {
                fullLayout += 64;
                oldLayout = 0;
                break;
            }
            case 2: {
                fullLayout += 0;
                oldLayout = -1;
            }
        }
        switch (this.chVDefaultLayout.getSelectedIndex()) {
            case 0: {
                fullLayout += 16384;
                break;
            }
            case 1: {
                fullLayout += 8192;
            }
        }
        this.getModel().setLayout(oldLayout, fullLayout);
    }

    public final boolean canFinish() {
        return this.getModel().canFinish();
    }

    public final void requestFocus() {
    }
}

