/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.figlet.export;

import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.figlet.export.CharacterArrangement;
import de.jave.lib.CharacterPlate;
import de.jave.lib.Toolbox;
import de.jave.text.TextTools;
import java.util.HashSet;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.core.util.Ensure;

public final class FigletExportModel
extends AbstractChangeableModel {
    private final CharacterPlate characterPlate;
    private int characterWidth = 8;
    private int characterHeight = 5;
    private int characterDescent = 1;
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private String characterArrangement = CharacterArrangement.ALL[0].getField();
    private int fullLayout;
    private int oldLayout;
    private String comment = "Author : \nDate   : " + Toolbox.getDateString() + "\n" + "Version: 1.0\n" + "-------------------------------------------------\n" + "\n" + "-------------------------------------------------\n" + "This font has been created using JavE's FIGlet font export assistant.\n" + "Have a look at: http://www.jave.de\n" + "\n" + "Permission is hereby given to modify this font, as long as the\n" + "modifier's name is placed on a comment line.";
    private String name = "";

    public FigletExportModel(Plate plate) {
        if (plate.hasSelection()) {
            plate.dropSelection();
        }
        PlateDocument doc = plate.getDocument();
        this.characterPlate = doc.getContent();
    }

    public final CharacterPlate getCharacterPlate() {
        return this.characterPlate;
    }

    public final int getCharacterDescent() {
        return this.characterDescent;
    }

    public final void setCharacterDescent(int characterDescent) {
        if (this.characterDescent == characterDescent) {
            return;
        }
        this.characterDescent = characterDescent;
        this.fireChangeEvent();
    }

    public final int getCharacterHeight() {
        return this.characterHeight;
    }

    public final void setCharacterHeight(int characterHeight) {
        if (this.characterHeight == characterHeight) {
            return;
        }
        this.characterHeight = characterHeight;
        this.fireChangeEvent();
    }

    public final int getCharacterWidth() {
        return this.characterWidth;
    }

    public final void setCharacterWidth(int characterWidth) {
        if (this.characterWidth == characterWidth) {
            return;
        }
        this.characterWidth = characterWidth;
        this.fireChangeEvent();
    }

    public final int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public final void setHorizontalSpacing(int horizontalSpacing) {
        if (this.horizontalSpacing == horizontalSpacing) {
            return;
        }
        this.horizontalSpacing = horizontalSpacing;
        this.fireChangeEvent();
    }

    public final int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public final void setVerticalSpacing(int verticalSpacing) {
        if (this.verticalSpacing == verticalSpacing) {
            return;
        }
        this.verticalSpacing = verticalSpacing;
        this.fireChangeEvent();
    }

    public final void setCharacterArrangement(String characterArrangement) {
        Ensure.ensureArgumentNotNull(characterArrangement);
        if (this.characterArrangement.equals(characterArrangement)) {
            return;
        }
        this.characterArrangement = characterArrangement;
        this.fireChangeEvent();
    }

    public final String getCharacterArrangement() {
        return this.characterArrangement;
    }

    public final char[][] getRaster() {
        char[][] ch = TextTools.toCharField(this.characterArrangement);
        HashSet<Character> table = new HashSet<Character>();
        for (int y = 0; y < ch.length; ++y) {
            for (int x = 0; x < ch[0].length; ++x) {
                Character c = new Character(ch[y][x]);
                if (table.contains(c)) {
                    ch[y][x] = '\u0000';
                    continue;
                }
                table.add(c);
            }
        }
        return ch;
    }

    public final void setName(String name) {
        Ensure.ensureArgumentNotNull(name);
        if (this.name.equals(name)) {
            return;
        }
        this.name = name;
        this.fireChangeEvent();
    }

    public final String getName() {
        return this.name;
    }

    public final boolean canFinish() {
        return this.name.length() > 0;
    }

    public final void setLayout(int oldLayout, int fullLayout) {
        if (this.oldLayout == oldLayout && this.fullLayout == fullLayout) {
            return;
        }
        this.oldLayout = oldLayout;
        this.fullLayout = fullLayout;
        this.fireChangeEvent();
    }

    public final int getOldLayout() {
        return this.oldLayout;
    }

    public final int getFullLayout() {
        return this.fullLayout;
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String comment) {
        Ensure.ensureArgumentNotNull(comment);
        if (this.comment.equals(comment)) {
            return;
        }
        this.comment = comment;
        this.fireChangeEvent();
    }
}

