/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.figlet;

import de.jave.figlet.engine.FigDriver;
import de.jave.figlet.swing.application.JFigletEditor;
import de.jave.figlet.swing.preferences.JFigletPreferences;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.figlet.FigletConfiguration;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public final class FigletEditorDialog {
    private final JDialog dialog;
    private final JFigletEditor editor;
    private boolean isCanceled = false;

    public FigletEditorDialog(Component parentComponent, JFigletPreferences preferences, FontModel displayFontModel) {
        FigDriver figDriver = FigletConfiguration.getInstance().getFigDriver();
        this.editor = new JFigletEditor(figDriver, displayFontModel, preferences);
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(new SmartAction("&OK"){

            protected final void execute(Component parent) {
                FigletEditorDialog.this.performOk();
            }
        });
        buttonPanelBuilder.add(new SmartAction("&Cancel"){

            protected final void execute(Component parent) {
                FigletEditorDialog.this.performCancel();
            }
        });
        this.dialog = GDialog.createJDialog(parentComponent, "FIGlet Editor", true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                FigletEditorDialog.this.performCancel();
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this.editor.getContent(), "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.pack();
        GuiUtilities.centerToParent(this.dialog);
    }

    private void performOk() {
        this.dialog.dispose();
    }

    private void performCancel() {
        this.isCanceled = true;
        this.dialog.dispose();
    }

    public final void show() {
        this.isCanceled = false;
        this.dialog.setVisible(true);
    }

    public final String getResultText() {
        return this.editor.getResultText();
    }

    public final boolean isCanceled() {
        return this.isCanceled;
    }
}

