/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.clipart;

import de.jave.gui.FilenameTextField;
import de.jave.gui.GTextArea;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.clipart.ClipartGroup;
import de.jave.jave.clipart.ClipartManager;
import de.jave.jave.clipart.ClipartNewEntryModel;
import de.jave.jave.clipart.ClipartTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.input.text.ITextInputDialogConfiguration;
import net.disy.commons.swing.dialog.input.text.ITextInputDialogResult;
import net.disy.commons.swing.dialog.input.text.SmartTextInputDialog;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogPage;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.tree.SmartTree;

public final class ClipartNewEntryPage
extends AbstractDialogPage {
    private final ClipartNewEntryModel model;
    private JTextField nameTextField;
    private SmartTree tree;
    private final ClipartManager clipartManager;

    public ClipartNewEntryPage(ClipartNewEntryModel model, ClipartManager clipartManager) {
        super(new BasicMessage("In order to add the new clipart to the library please enter a name and choose a category to add the clipart to."));
        this.model = model;
        this.clipartManager = clipartManager;
    }

    public final IBasicMessage createCurrentMessage() {
        if (this.model.getGroupName() == null || this.model.getGroupName().length() == 0) {
            return new BasicMessage("There is no category chosen for the clipart. Please choose a category.", MessageType.ERROR);
        }
        if (this.model.getName() == null || this.model.getName().length() == 0) {
            return new BasicMessage("You have not entered a name for the clipart. Please enter a name.", MessageType.ERROR);
        }
        return this.getDefaultMessage();
    }

    public final String getTitle() {
        return "Add New Clipart";
    }

    public final JComponent createContent() {
        String[] groupNames = this.clipartManager.getGroupNames();
        final DefaultMutableTreeNode root = new DefaultMutableTreeNode("Clipart Library");
        for (int i = 0; i < groupNames.length; ++i) {
            DefaultMutableTreeNode ge = new DefaultMutableTreeNode(this.clipartManager.getGroup(groupNames[i]));
            root.add(ge);
        }
        this.tree = new SmartTree(root);
        this.tree.setCellRenderer(new ClipartTreeCellRenderer());
        JScrollPane treePane = new JScrollPane(this.tree);
        treePane.setPreferredSize(new Dimension(150, 250));
        JButton bNewFolder = new JButton(new SmartAction("New", JaveImageProvider.getInstance().getImageIcon("new_folder.gif")){

            protected final void execute(Component parentComponent) {
                ITextInputDialogResult result = SmartTextInputDialog.showTextInputDialog(parentComponent, new ITextInputDialogConfiguration(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public final String getTitle() {
                        return "New Clipart Category";
                    }

                    public final String getDefaultMessageText() {
                        return "Please enter a name for a new clipart category.";
                    }

                    public final IBasicMessage createCurrentMessage(String selectedText) {
                        String newCategoryName = selectedText.trim().toLowerCase();
                        if (newCategoryName.length() == 0) {
                            return new BasicMessage("The name is empty. Please specify a name for the new category.", MessageType.ERROR);
                        }
                        if (ClipartNewEntryPage.access$100(1.access$000(this.this$1)).hasGroupName(newCategoryName)) {
                            return new BasicMessage("The specified category already exists. Please specify a different name for the new category.", MessageType.ERROR);
                        }
                        if (!FilenameTextField.isValidFileName(selectedText)) {
                            return new BasicMessage("The specified category name is not valid. Only characters valid for file names are allowed, no spaces or special characters.", MessageType.ERROR);
                        }
                        return null;
                    }

                    public final String getLabelText() {
                        return "Category Name:";
                    }
                }, "category");
                if (result.isCanceled()) {
                    return;
                }
                String newCategoryName = result.getText().trim().toLowerCase();
                DefaultMutableTreeNode ge = new DefaultMutableTreeNode(new ClipartGroup(newCategoryName));
                ((DefaultTreeModel)ClipartNewEntryPage.this.tree.getModel()).insertNodeInto(ge, root, root.getChildCount());
                ClipartNewEntryPage.this.tree.setSelectionPath(new TreePath(ge.getPath()));
            }

            static final /* synthetic */ ClipartNewEntryPage access$000(1 x0) {
                return x0.ClipartNewEntryPage.this;
            }
        });
        GTextArea taPreview = new GTextArea("", 16, 45);
        taPreview.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        taPreview.setEditable(false);
        JPanel clipartPanel = new JPanel(new GridDialogLayout(2, false));
        clipartPanel.add((Component)new JLabel("Name:"), GridDialogLayoutData.RIGHT);
        this.nameTextField = new JTextField("", 15);
        this.nameTextField.setEditable(true);
        clipartPanel.add(this.nameTextField);
        clipartPanel.add((Component)new JLabel("Author:"), GridDialogLayoutData.RIGHT);
        final JTextField tfAuthor = new JTextField("", 15);
        tfAuthor.setEditable(true);
        clipartPanel.add(tfAuthor);
        clipartPanel.add((Component)new JLabel("Size:"), GridDialogLayoutData.RIGHT);
        JTextField tfSize = new JTextField("", 9);
        tfSize.setEditable(false);
        clipartPanel.add(tfSize);
        GridDialogLayoutData previewData = new GridDialogLayoutData(GridDialogLayoutData.FILL_BOTH);
        previewData.setHorizontalSpan(2);
        clipartPanel.add((Component)taPreview.getContent(), previewData);
        taPreview.setText(this.model.getCode().toString());
        tfSize.setText(this.model.getCode().getWidth() + " x " + this.model.getCode().getHeight());
        JPanel categoriesPanel = new JPanel(new GridDialogLayout(2, false));
        categoriesPanel.add(new JLabel("Category:"));
        categoriesPanel.add(bNewFolder);
        GridDialogLayoutData data = previewData;
        data.setHorizontalSpan(2);
        categoriesPanel.add((Component)treePane, data);
        JPanel panel = new JPanel(new BorderLayout(LayoutUtilities.getComponentGroupsSpacing(), LayoutUtilities.getComponentSpacing()));
        panel.add((Component)categoriesPanel, "Center");
        panel.add((Component)clipartPanel, "East");
        tfAuthor.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                ClipartNewEntryPage.this.model.setAuthor(tfAuthor.getText());
            }
        });
        this.nameTextField.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                ClipartNewEntryPage.this.model.setName(ClipartNewEntryPage.this.nameTextField.getText());
            }
        });
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public final void valueChanged(TreeSelectionEvent e) {
                ClipartNewEntryPage.this.model.setGroupName(ClipartNewEntryPage.this.getSelectedGroupName());
            }
        });
        this.model.addChangeListener(this.getCheckInputValidListener());
        return panel;
    }

    public final void requestFocus() {
        this.nameTextField.requestFocus();
    }

    private String getSelectedGroupName() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof ClipartGroup) {
            ClipartGroup group = (ClipartGroup)userObject;
            return group.getName();
        }
        return null;
    }

    static final /* synthetic */ ClipartManager access$100(ClipartNewEntryPage x0) {
        return x0.clipartManager;
    }
}

