/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.gradient;

import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import de.jave.lib.io.IoUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public final class AsciiGradientConfiguration
implements IJaveInitializable {
    private static final String[] DEFAULT_GRADIENTS = new String[]{" .'~:;!>+=icjtJY56SXDQKHNWM", " .':!+ijY6XbKHNM", " .:+j6bHM", " .:coCO8@", " .:oO8@", " .:oO8", " :+#"};
    private String[] gradients = DEFAULT_GRADIENTS;
    private static final AsciiGradientConfiguration instance = new AsciiGradientConfiguration();

    public final void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/gradients.txt");
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                lines.add(line);
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(e);
            }
            catch (Throwable throwable) {
                IoUtilities.close(br);
                throw throwable;
            }
        }
        IoUtilities.close(br);
        int size = lines.size();
        if (size == 0) {
            throw new ConfigurationException("The file seems to be empty.");
        }
        this.gradients = new String[size];
        for (int i = 0; i < size; ++i) {
            this.gradients[i] = (String)lines.get(i);
        }
    }

    private AsciiGradientConfiguration() {
    }

    public static final AsciiGradientConfiguration getInstance() {
        return instance;
    }

    public final String[] getGradients() {
        return this.gradients;
    }
}

