/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.fill;

import de.jave.jave.algorithm.fill.FillMatchMode;
import de.jave.jave.algorithm.fill.GradientStyle;
import de.jave.jave.pattern.Pattern;
import de.jave.lib.CharacterPlate;
import java.util.Vector;

public final class FillAlgorithm {
    private static CharacterPlate plate;
    private static int plateWidth;
    private static int plateHeight;
    private static FillMatchMode matchMode;
    private static char prevChar;
    private static int boundsMinX;
    private static int boundsMinY;
    private static int boundsMaxX;
    private static int boundsMaxY;
    private static Vector spans;
    private static final double[][] BAYER_MATRIX2;

    private static void addSpan(int x1, int x2, int y) {
        int[] nArray = new int[3];
        int[] span = nArray;
        nArray[0] = x1;
        span[1] = x2;
        span[2] = y;
        spans.addElement(span);
    }

    private static int[] getSpan() {
        int[] result = (int[])spans.elementAt(spans.size() - 1);
        spans.removeElementAt(spans.size() - 1);
        return result;
    }

    private static boolean matches(int x, int y) {
        char c;
        if (x < 0 || y < 0 || x >= plateWidth || y >= plateHeight) {
            return false;
        }
        if (matchMode == FillMatchMode.EQUAL_CHARACTER && plate.get(x, y) != prevChar) {
            return false;
        }
        return matchMode == FillMatchMode.EQUAL_CHARACTER || (c = plate.get(x, y)) != ' ' && c != '\u0002';
    }

    public static final void fill(int x0, int y0) {
        spans = new Vector();
        if (!FillAlgorithm.matches(x0, y0)) {
            return;
        }
        FillAlgorithm.addSpan(x0, x0, y0);
        int delta = 0;
        if (matchMode == FillMatchMode.ANY_CHARACTER_DIAGONAL) {
            delta = 1;
        }
        while (spans.size() > 0) {
            int x;
            int s2;
            int s1;
            int start;
            int[] span = FillAlgorithm.getSpan();
            int end = span[1];
            int y = span[2];
            for (start = span[0]; start > 0 && FillAlgorithm.matches(start - 1, y); --start) {
            }
            while (end < plateWidth - 1 && FillAlgorithm.matches(end + 1, y)) {
                ++end;
            }
            for (int i = start; i <= end; ++i) {
                plate.setForce(i, y, '\u0002');
            }
            if (start < boundsMinX) {
                boundsMinX = start;
            }
            if (end > boundsMaxX) {
                boundsMaxX = end;
            }
            if (y < boundsMinY) {
                boundsMinY = y;
            } else if (y > boundsMaxY) {
                boundsMaxY = y;
            }
            if (y > 0) {
                s1 = -1;
                s2 = -1;
                for (x = start - delta; x <= end + delta; ++x) {
                    if (FillAlgorithm.matches(x, y - 1)) {
                        if (s1 == -1) {
                            s1 = x;
                            s2 = x;
                            continue;
                        }
                        ++s2;
                        continue;
                    }
                    if (s1 != -1) {
                        FillAlgorithm.addSpan(s1, s2, y - 1);
                    }
                    s1 = -1;
                    s2 = -1;
                }
                if (s1 != -1) {
                    FillAlgorithm.addSpan(s1, s2, y - 1);
                }
            }
            if (y >= plateHeight - 1) continue;
            s1 = -1;
            s2 = -1;
            for (x = start - delta; x <= end + delta; ++x) {
                if (FillAlgorithm.matches(x, y + 1)) {
                    if (s1 == -1) {
                        s1 = x;
                        s2 = x;
                        continue;
                    }
                    ++s2;
                    continue;
                }
                if (s1 != -1) {
                    FillAlgorithm.addSpan(s1, s2, y + 1);
                }
                s1 = -1;
                s2 = -1;
            }
            if (s1 == -1) continue;
            FillAlgorithm.addSpan(s1, s2, y + 1);
        }
    }

    public static final void fillSolid(CharacterPlate characterPlate, int x, int y, char fillChar, FillMatchMode fillMatchMode) {
        matchMode = fillMatchMode;
        prevChar = characterPlate.get(x, y);
        plate = characterPlate;
        plateWidth = characterPlate.getWidth();
        plateHeight = characterPlate.getHeight();
        boundsMaxX = x;
        boundsMinX = x;
        boundsMaxY = y;
        boundsMinY = y;
        FillAlgorithm.fill(x, y);
        for (int xx = boundsMinX; xx <= boundsMaxX; ++xx) {
            for (int yy = boundsMinY; yy <= boundsMaxY; ++yy) {
                if (characterPlate.get(xx, yy) != '\u0002') continue;
                characterPlate.setForce(xx, yy, fillChar);
            }
        }
    }

    public static final void fillPattern(CharacterPlate characterPlate, int x, int y, Pattern pattern, FillMatchMode fillMatchMode) {
        if (pattern == null) {
            return;
        }
        matchMode = fillMatchMode;
        plate = characterPlate;
        plateWidth = characterPlate.getWidth();
        plateHeight = characterPlate.getHeight();
        char[][] fillPattern = pattern.getContent();
        int fillPatternHeight = fillPattern.length;
        if (fillPatternHeight == 0) {
            return;
        }
        int fillPatternWidth = fillPattern[0].length;
        if (fillPatternWidth == 0) {
            return;
        }
        boundsMinX = x;
        boundsMaxX = x;
        boundsMinY = y;
        boundsMaxY = y;
        prevChar = characterPlate.get(x, y);
        FillAlgorithm.fill(x, y);
        int pox = 0;
        while ((pox + x) % fillPatternWidth != 0) {
            ++pox;
        }
        int poy = 0;
        while ((poy + y) % fillPatternHeight != 0) {
            ++poy;
        }
        for (int xx = boundsMinX; xx <= boundsMaxX; ++xx) {
            for (int yy = boundsMinY; yy <= boundsMaxY; ++yy) {
                if (characterPlate.get(xx, yy) != '\u0002') continue;
                characterPlate.setForce(xx, yy, fillPattern[(yy + poy) % fillPatternHeight][(xx + pox) % fillPatternWidth]);
            }
        }
    }

    public static final void fillGradient(CharacterPlate characterPlate, int x1, int y1, int x2, int y2, char[] fillGradient, GradientStyle style, FillMatchMode fillMatchMode, boolean dither) {
        matchMode = fillMatchMode;
        plate = characterPlate;
        plateWidth = characterPlate.getWidth();
        plateHeight = characterPlate.getHeight();
        int gradientResolution = fillGradient.length;
        boundsMinX = x1;
        boundsMaxX = x1;
        boundsMinY = y1;
        boundsMaxY = y1;
        prevChar = characterPlate.get(x1, y1);
        FillAlgorithm.fill(x1, y1);
        double v1 = x2 - x1;
        double v2 = (double)(y2 - y1) * 3.5;
        double scale = Math.sqrt(v1 * v1 + v2 * v2);
        double n1 = -(v2 /= scale);
        double n2 = v1 /= scale;
        double min = 0.0;
        double max = 0.0;
        double radius = 0.0;
        for (int xx = boundsMinX; xx <= boundsMaxX; ++xx) {
            for (int yy = boundsMinY; yy <= boundsMaxY; ++yy) {
                double d;
                double d2;
                if (characterPlate.get(xx, yy) != '\u0002') continue;
                double d3 = (double)(y1 - yy) * n1 - (double)(x1 - xx) * n2;
                if (d2 < min) {
                    min = d3;
                } else if (d3 > max) {
                    max = d3;
                }
                double r = (double)((xx - x1) * (xx - x1)) + 3.5 * (double)(yy - y1) * (double)(yy - y1);
                if (!(d > radius)) continue;
                radius = r;
            }
        }
        radius = Math.sqrt(radius);
        for (int yy = boundsMinY; yy <= boundsMaxY; ++yy) {
            for (int xx = boundsMinX; xx <= boundsMaxX; ++xx) {
                int i;
                double intensity;
                if (characterPlate.get(xx, yy) != '\u0002') continue;
                double index = 0.0;
                if (style == GradientStyle.LINEAR) {
                    double d = (double)(y1 - yy) * n1 - (double)(x1 - xx) * n2;
                    intensity = (d - min) / (max - min);
                    index = intensity * (double)gradientResolution - 0.5;
                } else if (style == GradientStyle.SUNBURST) {
                    double r = Math.sqrt(3.5 * (double)(yy - y1) * (double)(yy - y1) + (double)((xx - x1) * (xx - x1)));
                    intensity = r / radius;
                    index = intensity * ((double)gradientResolution - 0.5);
                } else if (style == GradientStyle.RADIAL) {
                    double w1 = xx - x1;
                    double w2 = (double)(yy - y1) * 3.5;
                    double s = Math.sqrt(w1 * w1 + w2 * w2);
                    double angle = Math.acos((w1 /= s) * v1 + (w2 /= s) * v2);
                    double intensity2 = angle / Math.PI;
                    index = intensity2 * ((double)gradientResolution - 1.0);
                }
                if (dither) {
                    index += BAYER_MATRIX2[xx % 2][yy % 2] - 0.5;
                }
                if ((i = (int)Math.round(index)) < 0) {
                    i = 0;
                } else if (i >= gradientResolution) {
                    i = gradientResolution - 1;
                }
                char ch = fillGradient[i];
                characterPlate.setForce(xx, yy, ch);
            }
        }
    }

    static {
        matchMode = FillMatchMode.EQUAL_CHARACTER;
        BAYER_MATRIX2 = new double[][]{{0.6666666666666666, 0.3333333333333333}, {0.0, 1.0}};
    }
}

