/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.lib.CharacterPlate;

public final class CenterByTheLine
extends JaveAlgorithm {
    private static CenterByTheLine instance;

    private CenterByTheLine() {
    }

    public static final synchronized CenterByTheLine getInstance() {
        if (instance == null) {
            instance = new CenterByTheLine();
        }
        return instance;
    }

    public final String getActionName() {
        return "center by the line";
    }

    public final String getMenuItemLabel() {
        return "Center by the line";
    }

    public final CharacterPlate apply(CharacterPlate plate) {
        int width = plate.getWidth();
        int height = plate.getHeight();
        for (int y = 0; y < height; ++y) {
            int right;
            int left;
            char[] line = plate.getLine(y).toCharArray();
            for (left = 0; left < width && line[left] == ' '; ++left) {
            }
            if (left >= width) continue;
            for (right = 0; right < width && line[width - 1 - right] == ' '; ++right) {
            }
            int dx = 0;
            dx = right >= left ? (right - left) / 2 : -((left - right + 1) / 2);
            if (dx == 0) continue;
            for (int x = 0; x < width; ++x) {
                if (x - dx < 0 || x - dx >= width) {
                    plate.setForce(x, y, ' ');
                    continue;
                }
                plate.setForce(x, y, line[x - dx]);
            }
        }
        return plate;
    }
}

