/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions.performers;

import de.jave.asciimation.JmovFileChooserConfiguration;
import de.jave.gui.StatusBar;
import de.jave.gui.dialog.GDialog;
import de.jave.gui.io.AcceptAllFileFilter;
import de.jave.gui.io.ExtensionFileFilter;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import de.jave.jave.PlateDocument;
import de.jave.jave.actions.performers.IDocumentSaveListener;
import de.jave.jave.browser.IJaveDocumentTypeVisitor;
import de.jave.jave.browser.JaveDocumentType;
import de.jave.jave.plate.AnimationDocumentEditor;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.javeplayer.persistence.JaveAnimationFileWriter;
import de.jave.util.RecentFileList;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class SavePerformer {
    private static boolean performSaveDocumentAs(Component parentComponent, IDocumentEditor editor, RecentFileList recentFileList, final FileModel currentDirectoryModel, StatusBar statusDisplay, IDocumentSaveListener listener) {
        PlateDocument doc = editor.getPlate().getDocument();
        File file = FileChooserUtilities.performSaveFileChooser(parentComponent, new IFileChooserConfiguration(){

            public final FileModel getCurrentDirectoryModel() {
                return currentDirectoryModel;
            }

            public final String getSaveDialogTitle() {
                return "Save ASCII File";
            }

            public final String getOpenDialogTitle() {
                return null;
            }

            public final SmartFileFilter[] getFileFilters() {
                return new SmartFileFilter[]{new AcceptAllFileFilter(), new ExtensionFileFilter("Text Files", "txt")};
            }

            public final String getFileNameSuggestion() {
                return null;
            }

            public final boolean isMultipleOpenFileSelectionAllowed() {
                return false;
            }
        });
        if (file == null) {
            return false;
        }
        currentDirectoryModel.setFile(file.getParentFile());
        doc.setFile(file);
        boolean success = SavePerformer.performSaveDocument(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, listener);
        if (!success) {
            doc.setFile(null);
        }
        listener.savePerformed();
        return success;
    }

    private static boolean performSaveDocument(Component parentComponent, IDocumentEditor editor, RecentFileList recentFileList, FileModel currentDirectoryModel, StatusBar statusDisplay, IDocumentSaveListener listener) {
        PlateDocument doc = editor.getPlate().getDocument();
        if (!doc.hasFile()) {
            return SavePerformer.performSaveDocumentAs(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, listener);
        }
        editor.getPlate().getToolManager().getCurrentTool().prepareForSave();
        try {
            doc.save(recentFileList);
            statusDisplay.showStatus("File saved.");
            listener.savePerformed();
            return true;
        }
        catch (IOException e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error saving file.", MessageType.ERROR, e));
            return false;
        }
    }

    private static boolean performSaveAnimationAs(Component parentComponent, AnimationDocumentEditor animationEditor, RecentFileList recentFileList, FileModel currentDirectoryModel, StatusBar statusDisplay, IDocumentSaveListener listener) {
        File file = FileChooserUtilities.performSaveFileChooser(parentComponent, new JmovFileChooserConfiguration(currentDirectoryModel));
        if (file == null) {
            return false;
        }
        JaveAnimationFile animationFile = animationEditor.getModel().getAnimationFile();
        animationFile.setFile(file);
        boolean success = SavePerformer.performSaveAnimation(parentComponent, animationEditor, recentFileList, currentDirectoryModel, statusDisplay, listener);
        if (!success) {
            animationFile.setFile(null);
        }
        listener.savePerformed();
        return success;
    }

    private static boolean performSaveAnimation(Component parentComponent, AnimationDocumentEditor animationEditor, RecentFileList recentFileList, FileModel currentDirectoryModel, StatusBar statusDisplay, IDocumentSaveListener listener) {
        JaveAnimationFile animationFile = animationEditor.getModel().getAnimationFile();
        if (animationFile.getFile() == null) {
            return SavePerformer.performSaveAnimationAs(parentComponent, animationEditor, recentFileList, currentDirectoryModel, statusDisplay, listener);
        }
        try {
            new JaveAnimationFileWriter().write(animationFile, animationFile.getFile());
            animationEditor.getModel().setModified(false);
            recentFileList.add(animationFile.getFile());
            statusDisplay.showStatus("File saved.");
            listener.savePerformed();
            return true;
        }
        catch (Exception e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE Animation Editor", "Error saving file", e));
            return false;
        }
    }

    public static final boolean performSaveAs(final Component parentComponent, final IDocumentEditor editor, final RecentFileList recentFileList, final FileModel currentDirectoryModel, final StatusBar statusDisplay, final IDocumentSaveListener documentSaveListener) {
        final boolean[] success = new boolean[1];
        editor.getType().accept(new IJaveDocumentTypeVisitor(){

            public final void visitGame(JaveDocumentType type) {
                success[0] = SavePerformer.performSaveDocumentAs(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }

            public final void visitAnimation(JaveDocumentType type) {
                AnimationDocumentEditor animationEditor = (AnimationDocumentEditor)editor;
                success[0] = SavePerformer.performSaveAnimationAs(parentComponent, animationEditor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }

            public final void visitText(JaveDocumentType type) {
                success[0] = SavePerformer.performSaveDocumentAs(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }
        });
        return success[0];
    }

    public static final boolean performSave(final Component parentComponent, final IDocumentEditor editor, final RecentFileList recentFileList, final FileModel currentDirectoryModel, final StatusBar statusDisplay, final IDocumentSaveListener documentSaveListener) {
        final boolean[] success = new boolean[1];
        editor.getType().accept(new IJaveDocumentTypeVisitor(){

            public final void visitGame(JaveDocumentType type) {
                success[0] = SavePerformer.performSaveDocument(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }

            public final void visitAnimation(JaveDocumentType type) {
                AnimationDocumentEditor animationEditor = (AnimationDocumentEditor)editor;
                success[0] = SavePerformer.performSaveAnimation(parentComponent, animationEditor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }

            public final void visitText(JaveDocumentType type) {
                success[0] = SavePerformer.performSaveDocument(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }
        });
        return success[0];
    }

    public static final boolean performSaveBeforeClose(final Component parentComponent, final IDocumentEditor editor, final RecentFileList recentFileList, final FileModel currentDirectoryModel, final StatusBar statusDisplay, final IDocumentSaveListener documentSaveListener) {
        final boolean[] success = new boolean[1];
        editor.getType().accept(new IJaveDocumentTypeVisitor(){

            public final void visitGame(JaveDocumentType type) {
                success[0] = SavePerformer.performSaveBeforeCloseDocument(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }

            public final void visitAnimation(JaveDocumentType type) {
                AnimationDocumentEditor animationEditor = (AnimationDocumentEditor)editor;
                success[0] = SavePerformer.performSaveBeforeCloseAnimation(parentComponent, animationEditor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }

            public final void visitText(JaveDocumentType type) {
                success[0] = SavePerformer.performSaveBeforeCloseDocument(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
            }
        });
        return success[0];
    }

    private static boolean performSaveBeforeCloseAnimation(Component parentComponent, AnimationDocumentEditor editor, RecentFileList recentFileList, FileModel currentDirectoryModel, StatusBar statusDisplay, IDocumentSaveListener documentSaveListener) {
        if (!editor.getModel().isModified()) {
            return true;
        }
        String question = "The animation " + DocumentEditorTitleFactory.createShortEditorTitle(editor) + " has been modified.\n" + "Do you want to save changes?";
        GDialog id = new GDialog(parentComponent, "JavE Animation Editor", question, GDialog.YES_NO_CANCEL, 1);
        id.show();
        int result = id.getAnswer();
        if (result == 1) {
            editor.getModel().setModified(false);
            return true;
        }
        if (result == -1 || result == 2) {
            return false;
        }
        if (result == 0) {
            return SavePerformer.performSaveAnimation(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
        }
        return true;
    }

    private static boolean performSaveBeforeCloseDocument(Component parentComponent, IDocumentEditor editor, RecentFileList recentFileList, FileModel currentDirectoryModel, StatusBar statusDisplay, IDocumentSaveListener documentSaveListener) {
        PlateDocument doc = editor.getPlate().getDocument();
        String question = "Document " + DocumentEditorTitleFactory.createShortEditorTitle(editor) + " has been modified.\n" + "Do you want to save changes?";
        GDialog id = new GDialog(parentComponent, "JavE", question, GDialog.YES_NO_CANCEL, 1);
        id.show();
        int result = id.getAnswer();
        if (result == -1 || result == 2) {
            return false;
        }
        if (result == 1) {
            doc.setModified(false);
            return true;
        }
        return SavePerformer.performSaveDocument(parentComponent, editor, recentFileList, currentDirectoryModel, statusDisplay, documentSaveListener);
    }
}

