/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.gui.dialog.GDialog;
import de.jave.jave.Jave;
import de.jave.jave.actions.AbstractJaveAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextAndAnimationEditorEnabledStrategy;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.browser.JaveDocumentType;
import de.jave.jave.plate.AnimationDocumentEditor;
import de.jave.jave.plate.IDocumentEditor;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.disy.commons.swing.layout.grid.GridDialogLayout;

public final class ResizeDocumentAction
extends AbstractJaveAction {
    public ResizeDocumentAction(Jave jave) {
        super(jave.getMainPanel(), "Resize Document", JaveImageProvider.getInstance().getImageIcon("resize.gif"));
        this.setToolTipText("Resize Document");
    }

    protected final IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextAndAnimationEditorEnabledStrategy.getInstance();
    }

    protected final void ececute(Component parentComponent, IDocumentEditor editor) {
        Dimension documentSize = editor.getPlate().getDocument().getSize();
        JPanel gbNew = new JPanel(new GridDialogLayout(2, false));
        gbNew.setBorder(new TitledBorder("New size"));
        gbNew.add(new JLabel("Width:"));
        SpinnerNumberModel itfWidth = new SpinnerNumberModel(documentSize.width, 1, 1000, 1);
        gbNew.add(new JSpinner(itfWidth));
        gbNew.add(new JLabel("Height:"));
        SpinnerNumberModel itfHeight = new SpinnerNumberModel(documentSize.height, 1, 9999, 1);
        gbNew.add(new JSpinner(itfHeight));
        GDialog id = new GDialog(parentComponent, "Resize plate", gbNew, GDialog.OK_CANCEL);
        id.show();
        int result = id.getAnswer();
        if (result != 0) {
            return;
        }
        int newWidth = itfWidth.getNumber().intValue();
        int newHeight = itfHeight.getNumber().intValue();
        if (newWidth == documentSize.width && newHeight == documentSize.height) {
            return;
        }
        if (editor.getType() == JaveDocumentType.TEXT) {
            this.getMainPanel().setPlateSize(newWidth, newHeight);
        } else if (editor.getType() == JaveDocumentType.ANIMATION) {
            AnimationDocumentEditor animationEditor = (AnimationDocumentEditor)editor;
            animationEditor.getModel().setNewFrameSize(new Dimension(newWidth, newHeight));
        } else {
            throw new UnsupportedOperationException();
        }
        this.getMainPanel().saveCurrentState("resize plate");
    }
}

