/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.jave.Jave;
import de.jave.jave.actions.ButtonToolbarBuilder;
import de.jave.jave.actions.JaveActions;
import de.jave.jave.application.resources.JaveImageProvider;
import java.awt.Component;
import javax.swing.JComponent;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.ActionWidgetFactory;
import net.disy.commons.swing.action.SmartAction;

public final class JaveTopToolbar {
    private final JComponent content;
    private final SmartAction undoAction;
    private final SmartAction redoAction;

    public JaveTopToolbar(final Jave jave, JaveActions actions) {
        Ensure.ensureArgumentNotNull(jave);
        SmartAction cutAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("cut.gif")){

            protected final void execute(Component parentComponent) {
                jave.doCut();
            }
        };
        cutAction.setDisabledIcon(JaveImageProvider.getInstance().getImageIcon("cut_.gif"));
        cutAction.setToolTipText("Cut");
        SmartAction copyAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("copy.gif")){

            protected final void execute(Component parentComponent) {
                jave.doCopy();
            }
        };
        copyAction.setDisabledIcon(JaveImageProvider.getInstance().getImageIcon("copy_.gif"));
        copyAction.setToolTipText("Copy");
        SmartAction pasteAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("paste.gif")){

            protected final void execute(Component parentComponent) {
                jave.doPaste();
            }
        };
        pasteAction.setDisabledIcon(JaveImageProvider.getInstance().getImageIcon("paste_.gif"));
        pasteAction.setToolTipText("Paste");
        this.undoAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("undo.gif")){

            protected final void execute(Component parentComponent) {
                jave.doUndo();
            }
        };
        this.undoAction.setDisabledIcon(JaveImageProvider.getInstance().getImageIcon("undo_.gif"));
        this.undoAction.setToolTipText("Undo");
        this.redoAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("redo.gif")){

            protected final void execute(Component parentComponent) {
                jave.doRedo();
            }
        };
        this.redoAction.setDisabledIcon(JaveImageProvider.getInstance().getImageIcon("redo_.gif"));
        this.redoAction.setToolTipText("Redo");
        SmartAction zoomPlusAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("zoomplus.gif")){

            protected final void execute(Component parentComponent) {
                jave.doZoomPlus();
            }
        };
        zoomPlusAction.setToolTipText("Zoom in");
        SmartAction zoomMinusAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("zoomminus.gif")){

            protected final void execute(Component parentComponent) {
                jave.doZoomMinus();
            }
        };
        zoomMinusAction.setToolTipText("Zoom out");
        SmartAction exportAction = new SmartAction(this, JaveImageProvider.getInstance().getImageIcon("export.gif")){

            protected final void execute(Component parentComponent) {
                jave.doExport();
            }
        };
        exportAction.setToolTipText("Export Result");
        ButtonToolbarBuilder builder = new ButtonToolbarBuilder();
        builder.add(actions.getNewDocumentAction());
        builder.add(actions.getNewAnimationAction());
        builder.addSeparator();
        builder.add(actions.getBrowseAction());
        builder.add(actions.getOpenAction());
        builder.add(actions.getSaveAction());
        builder.addSeparator();
        builder.add(ActionWidgetFactory.createToggleButton(actions.getToolOptionsDialogToggleAction()));
        builder.addSeparator();
        builder.add(cutAction);
        builder.add(copyAction);
        builder.add(pasteAction);
        builder.addSeparator();
        builder.add(this.undoAction);
        builder.add(this.redoAction);
        builder.addSeparator();
        builder.add(actions.getResizeAction());
        builder.addSeparator();
        builder.add(actions.getFigletAction());
        builder.add(actions.getImage2AsciiAction());
        builder.add(actions.getCamelizerAction());
        builder.add(actions.getClipartLibraryAction());
        builder.add(actions.getTextBoxAction());
        builder.add(actions.getMathematicalExpressionsAction());
        builder.addSeparator();
        builder.add(zoomMinusAction);
        builder.add(zoomPlusAction);
        builder.addSeparator();
        builder.add(exportAction);
        builder.addSeparator();
        builder.add(actions.getAboutAction());
        this.content = builder.createPanel();
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void updateUndoRedo(boolean canUndo, boolean canRedo) {
        this.undoAction.setEnabled(canUndo);
        this.redoAction.setEnabled(canRedo);
    }
}

