/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.jave.CompressedDocumentState;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveLogFile;
import de.jave.jave.PlateDocument;
import de.jave.jave.Selection;
import de.jave.jave.actions.AbstractJaveAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextEditorOnlyEnabledStrategy;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.plate.TextDocumentEditor;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.lib.BooleanPlate;
import de.jave.lib.CharacterPlate;
import de.jave.lib.Toolbox;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class ConvertMakingOfToAnimationAction
extends AbstractJaveAction {
    private final Jave jave;
    private final JaveApplicationPreferences preferences;

    public ConvertMakingOfToAnimationAction(JaveApplicationPreferences preferences, Jave jave, JaveMainPanel mainPanel) {
        super(mainPanel, "Convert 'Making Of' to Animation", null);
        this.preferences = preferences;
        this.jave = jave;
    }

    protected final IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextEditorOnlyEnabledStrategy.getInstance();
    }

    protected final void ececute(Component parentComponent, IDocumentEditor editor) {
        TextDocumentEditor textEditor = (TextDocumentEditor)editor;
        PlateDocument doc = textEditor.getPlate().getDocument();
        if (!doc.isLogging()) {
            return;
        }
        String logFileName = doc.getLogFileName();
        if (!new File(logFileName).exists()) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE - Export 'making of'", "The current document has not been edited.\nNo 'making of' can be exported.", MessageType.INFORMATION));
            return;
        }
        CompressedDocumentState[] frames = JaveLogFile.load(new File(logFileName));
        if (frames == null) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error while exporting to 'making of': Unable to load logfile.", MessageType.ERROR));
            return;
        }
        AnimationMetaData metaData = new AnimationMetaData();
        metaData.setAuthorName(this.preferences.getAuthorName());
        metaData.setAuthorEmail(this.preferences.getAuthorMail());
        metaData.setDate(Toolbox.getDateString());
        metaData.setTitle(DocumentEditorTitleFactory.createShortEditorTitle(this.getMainPanel().getEditor()));
        metaData.setSoftware(JaveTitleProvider.JAVE + " - Making of");
        ColorScheme colorScheme = JaveGlobalRessources.getColorSchemeModel().getColorScheme();
        AnimationProperties properties = new AnimationProperties();
        properties.setForegroundColor(colorScheme.getColorText());
        properties.setBackgroundColor(colorScheme.getColorPlateBackground());
        JaveAnimationFile animationFile = new JaveAnimationFile();
        animationFile.setMetaData(metaData);
        animationFile.setProperties(properties);
        for (int i = 0; i < frames.length; ++i) {
            JaveAnimationFrame frame = new JaveAnimationFrame();
            if (frames[i].hasSelection()) {
                CharacterPlate cp = new CharacterPlate(frames[i].getContent());
                if (frames[i].hasSelectionMask()) {
                    BooleanPlate mask = frames[i].getSelectionMask();
                    char[][] content = frames[i].getSelectionContent();
                    Point location = frames[i].getSelectionLocation();
                    Selection sel = new Selection();
                    sel.set(location, content, mask);
                    sel.pasteIntoNormal(cp);
                } else {
                    char[][] content = frames[i].getSelectionContent();
                    Point location = frames[i].getSelectionLocation();
                    Selection sel = new Selection();
                    sel.set(location, new CharacterPlate(content));
                    sel.pasteIntoNormal(cp);
                }
                frame.setContent(cp);
            } else {
                frame.setContent(frames[i].getPackedContent());
            }
            frame.setScrollX(frames[i].getScrollX());
            frame.setScrollY(frames[i].getScrollY());
            frame.setCursorX(frames[i].getCursorX());
            frame.setCursorY(frames[i].getCursorY());
            frame.setTool(frames[i].getToolName());
            frame.setAction(frames[i].getAction());
            animationFile.add(frame);
        }
        this.jave.openJaveAnimation(parentComponent, animationFile);
    }
}

