/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.gui.layout.Gap;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonToolbarBuilder {
    private static final Dimension TOOLBAR_BUTTON_SIZE = new Dimension(24, 23);
    private JPanel panel = new JPanel(new FlowLayout(0, 0, 2));

    public ButtonToolbarBuilder() {
        this.panel.add(new Gap(5, 1));
    }

    public final void add(Action action) {
        this.panel.add(ButtonToolbarBuilder.createToolbarButton(action));
    }

    public static final JButton createToolbarButton(Action action) {
        JButton button = new JButton(action);
        if (action.getValue("SmallIcon") != null) {
            button.setText(null);
        }
        ButtonToolbarBuilder.adjustButton(button);
        return button;
    }

    public final void add(AbstractButton button) {
        ButtonToolbarBuilder.adjustButton(button);
        this.panel.add(button);
    }

    public final void add(JComponent component) {
        this.panel.add(component);
    }

    private static void adjustButton(AbstractButton button) {
        if (button.getIcon() != null) {
            button.setText(null);
        }
        button.setPreferredSize(TOOLBAR_BUTTON_SIZE);
        button.setFocusPainted(false);
    }

    public final void addSeparator() {
        this.panel.add(new Gap(10, 1));
    }

    public final JComponent createPanel() {
        return this.panel;
    }
}

