/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GSliderArrangement;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.ISourceFilePanelConfiguration;
import de.jave.gui.io.SourceFilePanel;
import de.jave.gui.layout.VFlowLayout;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.MoveResizeRectangle;
import de.jave.jave.Tool;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.watermark.IWatermarkPainter;
import de.jave.jave.watermark.ImageIOUtilities;
import de.jave.jave.watermark.WatermarkData;
import de.jave.jave.watermark.WatermarkImageFile;
import de.jave.lib.Toolbox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class WatermarkTool
extends Tool
implements ActionListener,
ItemListener,
IWatermarkPainter {
    private WatermarkData data;
    private JButton bFit;
    private JTextField tfSize;
    private JTextField tfPosition;
    private GSliderArrangement slaBrightness;
    private JCheckBox cbNegative;
    private double xPos;
    private double yPos;
    private double wPos;
    private double hPos;
    private int mode;
    private MoveResizeRectangle imageRegion;
    private boolean enabled;
    private SourceFilePanel sourceFilePanel;
    private Point point1;

    public WatermarkTool(JaveMainPanel mainPanel, Jave asciiPainter) {
        super(mainPanel, asciiPainter);
        mainPanel.addWatermarkPainter(this);
    }

    public final String getName() {
        return "Watermark";
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/watermark.gif");
    }

    public final JComponent createOptionsComponent() {
        this.bFit = new JButton(new SmartAction("Fit"){

            protected final void execute(Component parentComponent) {
                WatermarkTool.this.fit();
            }
        });
        this.tfSize = new JTextField(10);
        this.tfSize.setEditable(false);
        this.tfPosition = new JTextField(10);
        this.tfPosition.setEditable(false);
        this.slaBrightness = new GSliderArrangement("Brightness:", -100, 100, 50, 5, 100);
        this.slaBrightness.getModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                if (WatermarkTool.this.data == null) {
                    return;
                }
                double brightness = WatermarkTool.this.slaBrightness.getDValue();
                boolean negative = WatermarkTool.this.cbNegative.isSelected();
                Image image2 = WatermarkTool.lighten(WatermarkTool.this.data.getOriginalImage(), brightness, negative);
                if (image2 != null) {
                    WatermarkTool.this.data.setVisibleImage(image2);
                    WatermarkTool.this.repaintAll();
                }
            }
        });
        this.cbNegative = new JCheckBox("Negative", false);
        this.cbNegative.addItemListener(this);
        JPanel optionsPanel = new JPanel(new GridDialogLayout(2, false));
        optionsPanel.add((Component)new JLabel("Position:"), GridDialogLayoutData.RIGHT);
        optionsPanel.add(this.tfPosition);
        optionsPanel.add((Component)new JLabel("Size:"), GridDialogLayoutData.RIGHT);
        optionsPanel.add(this.tfSize);
        optionsPanel.add(this.bFit);
        optionsPanel.add(this.cbNegative);
        final IFileChooserConfiguration fileChooserConfiguration = ImageIOUtilities.createImageOpenFileChooserConfiguration(this.jave.getDocumentManager().getCurrentDirectoryModel());
        ISourceFilePanelConfiguration configuration = new ISourceFilePanelConfiguration(this){

            public final String getLabel() {
                return "Image:";
            }

            public final boolean isCloseAvailable() {
                return true;
            }

            public final IFileChooserConfiguration getFileChooserConfiguration() {
                return fileChooserConfiguration;
            }

            public final String getOpenButtonToolTipText() {
                return "Open Image File as Watermark";
            }

            public final String getCloseButtonToolTipText() {
                return "Close Current Watermark Image";
            }
        };
        this.sourceFilePanel = new SourceFilePanel(new FileModel(), configuration){

            protected final boolean performOpenFile(Component parentComponent, File file) {
                return WatermarkTool.this.performLoadImage(parentComponent, file);
            }

            protected final boolean performCloseFile(Component parentComponent) {
                return WatermarkTool.this.performCloseImage();
            }
        };
        this.mainPanel.getActiveEditorModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                if (WatermarkTool.this.sourceFilePanel != null) {
                    WatermarkTool.this.sourceFilePanel.setEnabled(WatermarkTool.this.mainPanel.getActiveEditorModel().getActiveEditor() != null);
                }
            }
        });
        JPanel p = new JPanel(new VFlowLayout(0, 0));
        p.add(optionsPanel);
        p.add(this.slaBrightness.createPanel());
        p.add(this.sourceFilePanel.createPanel());
        this.bFit.setEnabled(false);
        this.cbNegative.setEnabled(false);
        this.slaBrightness.setEnabled(false);
        return p;
    }

    public final void takeToHand() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.jave.getToolBar().setWatermarkVisible(true);
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
    }

    public final boolean containsScreenPoint(Point point) {
        return this.imageRegion != null && this.imageRegion.contains(point);
    }

    public final void paint(Graphics g, Point plateOrigin, ColorScheme colorScheme, int charWidth, int charHeight) {
        if (this.data == null) {
            return;
        }
        int ww = (int)(this.wPos * (double)charWidth);
        int hh = (int)(this.hPos * (double)charHeight);
        Point p0 = this.getPlate().getScreenPointFor(this.xPos, this.yPos);
        int x0 = p0.x;
        int y0 = p0.y;
        this.imageRegion = new MoveResizeRectangle(x0, y0, ww, hh);
        if (!this.enabled) {
            return;
        }
        g.drawImage(this.data.getVisibleImage(), x0, y0, ww, hh, this.getPlate());
    }

    private boolean performCloseImage() {
        this.data = null;
        this.imageRegion = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaintAll();
        this.bFit.setEnabled(false);
        this.cbNegative.setEnabled(false);
        this.slaBrightness.setEnabled(false);
        return true;
    }

    public final boolean performLoadImage(Component parentComponent, File file) {
        BufferedImage loadedImage;
        try {
            loadedImage = ImageIO.read(file);
        }
        catch (IOException e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error loading image.", e));
            return false;
        }
        if (loadedImage == null) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error loading image. The file format is not supported.", MessageType.ERROR));
            return false;
        }
        if (!this.setImage(new WatermarkImageFile(loadedImage, file))) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error loading image: Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).", MessageType.ERROR));
            return false;
        }
        return true;
    }

    public final boolean setImage(WatermarkImageFile imageFile) {
        int imageWidth = imageFile.getImage().getWidth();
        int imageHeight = imageFile.getImage().getHeight();
        if (imageWidth == -1 || imageHeight == -1) {
            return false;
        }
        this.bFit.setEnabled(true);
        this.cbNegative.setEnabled(true);
        this.slaBrightness.setEnabled(true);
        this.wPos = this.getPlate().getDocumentSize().getWidth();
        if (this.wPos < 5.0) {
            this.wPos = 5.0;
        }
        this.hPos = (double)imageHeight * this.wPos / (double)imageWidth / 1.98;
        this.jave.getToolBar().setWatermarkVisible(true);
        this.updateLabels();
        double brightness = this.slaBrightness.getDValue();
        boolean negative = this.cbNegative.isSelected();
        Image image2 = WatermarkTool.lighten(imageFile.getImage(), brightness, negative);
        this.data = new WatermarkData(imageFile.getImage(), image2);
        this.repaintAll();
        this.sourceFilePanel.getFileModel().setFile(imageFile.getFile());
        return true;
    }

    protected final void fit() {
        if (this.data == null) {
            return;
        }
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.wPos = this.getPlate().getDocumentWidth();
        this.hPos = this.getPlate().getDocumentHeight();
        this.updateLabels();
        this.repaintAll();
    }

    public final void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.data == null || this.imageRegion == null) {
            return;
        }
        g.setColor(colorScheme.getColorToolRegion());
        this.imageRegion.paint(g);
        g.setColor(colorScheme.getColorToolRegion());
        int x0 = this.imageRegion.x;
        int y0 = this.imageRegion.y;
        int ww = this.imageRegion.width;
        int hh = this.imageRegion.height;
        g.setFont(JaveGlobalRessources.FONT_SMALL);
        FontMetrics fm = this.jave.getFrame().getFontMetrics(JaveGlobalRessources.FONT_SMALL);
        int labelWidth = fm.stringWidth("Watermark") + 10;
        int[] nArray = new int[4];
        int[] xPoints = nArray;
        nArray[0] = x0 + ww - labelWidth - 5;
        xPoints[1] = x0 + ww - labelWidth + 5;
        xPoints[2] = x0 + ww - 10;
        xPoints[3] = x0 + ww;
        int[] nArray2 = new int[4];
        int[] yPoints = nArray2;
        nArray2[0] = y0 + hh;
        yPoints[1] = y0 + hh + 20;
        yPoints[2] = y0 + hh + 20;
        yPoints[3] = y0 + hh;
        g.setColor(colorScheme.getColorPlateBackground());
        g.fillPolygon(xPoints, yPoints, 4);
        g.setColor(colorScheme.getColorToolRegion());
        g.drawPolygon(xPoints, yPoints, 4);
        g.drawString("Watermark", x0 + ww - labelWidth + 3, y0 + hh + 13);
    }

    public final void mouseMoved(Point point, Point location, MouseEvent evt) {
        if (this.data == null || this.imageRegion == null) {
            return;
        }
        this.setCursor(this.imageRegion.getCursorFor(point));
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        if (this.data == null || this.imageRegion == null) {
            return;
        }
        this.mode = this.imageRegion.getPlace(point);
        this.point1 = point;
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.data == null || this.imageRegion == null || this.point1 == null) {
            return;
        }
        if (this.mode == 0) {
            return;
        }
        int dx = point.x - this.point1.x;
        int dy = point.y - this.point1.y;
        int charWidth = this.getPlate().getCharWidth();
        int charHeight = this.getPlate().getCharHeight();
        double ddx = (double)dx / (double)charWidth;
        double ddy = (double)dy / (double)charHeight;
        this.point1 = point;
        if (this.mode == 1) {
            this.xPos += ddx;
            this.yPos += ddy;
        } else if (this.mode == 2) {
            this.yPos += ddy;
            this.hPos -= ddy;
            if (shiftDown) {
                this.wPos = this.hPos / (double)this.data.getImageSize().height * (double)this.data.getImageSize().width * 1.98;
            }
        } else if (this.mode == 4) {
            this.hPos += ddy;
            if (shiftDown) {
                this.wPos = this.hPos / (double)this.data.getImageSize().height * (double)this.data.getImageSize().width * 1.98;
            }
        } else if (this.mode == 5) {
            this.wPos += ddx;
            if (shiftDown) {
                this.hPos = (double)this.data.getImageSize().height * this.wPos / (double)this.data.getImageSize().width / 1.98;
            }
        } else if (this.mode == 3) {
            this.xPos += ddx;
            this.wPos -= ddx;
            if (shiftDown) {
                this.hPos = (double)this.data.getImageSize().height * this.wPos / (double)this.data.getImageSize().width / 1.98;
            }
        } else if (this.mode == 7) {
            this.yPos += ddy;
            this.hPos -= ddy;
            this.xPos += ddx;
            this.wPos -= ddx;
            if (shiftDown) {
                double dw = this.wPos - this.hPos / (double)this.data.getImageSize().height * (double)this.data.getImageSize().width * 1.98;
                this.wPos -= dw;
                this.xPos += dw;
            }
        } else if (this.mode == 6) {
            this.yPos += ddy;
            this.hPos -= ddy;
            this.wPos += ddx;
            if (shiftDown) {
                this.wPos = this.hPos / (double)this.data.getImageSize().height * (double)this.data.getImageSize().width * 1.98;
            }
        } else if (this.mode == 8) {
            this.hPos += ddy;
            this.wPos += ddx;
            if (shiftDown) {
                this.hPos = (double)this.data.getImageSize().height * this.wPos / (double)this.data.getImageSize().width / 1.98;
            }
        } else if (this.mode == 9) {
            this.hPos += ddy;
            this.xPos += ddx;
            this.wPos -= ddx;
            if (shiftDown) {
                this.hPos = (double)this.data.getImageSize().height * this.wPos / (double)this.data.getImageSize().width / 1.98;
            }
        }
        if (this.wPos < 2.0) {
            this.wPos = 2.0;
        }
        if (this.hPos < 2.0) {
            this.hPos = 2.0;
        }
        this.updateLabels();
        this.repaintAll();
    }

    public static final Image lighten(BufferedImage sourceImage, double value, boolean negative) {
        int i;
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(sourceImage, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Internal Error: " + e.toString());
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new RuntimeException("Internal Error: Image fetch aborted or errored.");
        }
        double v1 = 1.0 - value;
        double v255 = value * 255.0;
        if (value < 0.0) {
            v1 = value + 1.0;
            v255 = 0.0;
        }
        if (!negative) {
            for (i = 0; i < pixels.length; ++i) {
                pixels[i] = pixels[i] & 0xFF000000 | (int)((double)(pixels[i] >> 16 & 0xFF) * v1 + v255) << 16 | (int)((double)(pixels[i] >> 8 & 0xFF) * v1 + v255) << 8 | (int)((double)(pixels[i] & 0xFF) * v1 + v255);
            }
        } else {
            for (i = 0; i < pixels.length; ++i) {
                pixels[i] = pixels[i] & 0xFF000000 | (int)((double)(255 - (pixels[i] >> 16 & 0xFF)) * v1 + v255) << 16 | (int)((double)(255 - (pixels[i] >> 8 & 0xFF)) * v1 + v255) << 8 | (int)((double)(255 - (pixels[i] & 0xFF)) * v1 + v255);
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        image.getRaster().setDataElements(0, 0, width, height, pixels);
        return image;
    }

    public final void itemStateChanged(ItemEvent evt) {
        if (this.data == null) {
            return;
        }
        if (evt.getSource() == this.cbNegative) {
            double brightness = this.slaBrightness.getDValue();
            boolean negative = this.cbNegative.isSelected();
            this.data.setVisibleImage(WatermarkTool.lighten(this.data.getOriginalImage(), brightness, negative));
        }
        this.repaintAll();
    }

    protected final void updateLabels() {
        double dx = Toolbox.round(this.xPos, 2);
        double dy = Toolbox.round(this.yPos, 2);
        double dw = Toolbox.round(this.wPos, 2);
        double dh = Toolbox.round(this.hPos, 2);
        this.tfPosition.setText(dx + "; " + dy);
        this.tfSize.setText(dw + "; " + dh);
    }
}

