/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.lib.Toolbox;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public abstract class Tool
implements ItemListener,
ActionListener {
    protected JaveMainPanel mainPanel;
    protected Jave jave;
    protected JComponent optionsComponent;
    protected JLabel toolLabel;
    protected static boolean altDown = false;
    protected static boolean shiftDown = false;
    protected static boolean controlDown = false;
    protected static boolean metaDown = false;
    protected boolean debug = false;
    protected static boolean insert = false;
    protected PixelPlate markPlate;
    protected Cursor cursor;

    protected final void requestPlateFocus() {
        Plate plate = this.getPlate();
        if (plate != null) {
            plate.requestFocus();
        }
    }

    protected final PlateDocument getDocument() {
        Plate plate = this.getPlate();
        if (plate == null) {
            return null;
        }
        return plate.getDocument();
    }

    public final Point getCursorLocation() {
        PlateDocument document = this.getDocument();
        if (document != null) {
            return document.getCursorLocation();
        }
        return null;
    }

    protected final Plate getPlate() {
        IDocumentEditor activeEditor = this.mainPanel.getActiveEditorModel().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        return activeEditor.getPlate();
    }

    public void cursorUp(int lines) {
    }

    public void cursorDown(int lines) {
    }

    public static final boolean isInsert() {
        return insert;
    }

    public void setInsert(boolean what) {
        insert = what;
    }

    public boolean containsScreenPoint(Point point) {
        return false;
    }

    public boolean containsLocation(Point location) {
        return false;
    }

    public Tool(JaveMainPanel mainPanel, Jave jave) {
        this.mainPanel = mainPanel;
        this.jave = jave;
        this.toolLabel = new JLabel("- no options available -");
        this.toolLabel.setFont(JaveGlobalRessources.FONT_ITALIC);
    }

    public void prepareForSave() {
    }

    public final boolean isActiveTool() {
        return this.mainPanel.getCurrentTool() == this;
    }

    public static final void setMetaDown(boolean what) {
        metaDown = what;
    }

    protected final Rectangle getAutoSelectRegion(int x, int y) {
        boolean[][] marks = new boolean[this.mainPanel.getDocumentSize().width][this.mainPanel.getDocumentSize().height];
        marks[x][y] = true;
        Rectangle region = new Rectangle(x, y, 0, 0);
        this.crawl(x + 1, y, marks, region);
        this.crawl(x - 1, y, marks, region);
        this.crawl(x, y + 1, marks, region);
        this.crawl(x, y - 1, marks, region);
        ++region.width;
        ++region.height;
        return region;
    }

    protected final void crawl(int x, int y, boolean[][] marks, Rectangle region) {
        if (x < 0 || y < 0 || x >= this.mainPanel.getDocumentSize().width || y >= this.mainPanel.getDocumentSize().height || marks[x][y]) {
            return;
        }
        marks[x][y] = true;
        if (this.mainPanel.getDocument().getContent().get(x, y) == ' ') {
            return;
        }
        if (x < region.x) {
            --region.x;
            ++region.width;
        } else if (y < region.y) {
            --region.y;
            ++region.height;
        } else if (x > region.x + region.width) {
            ++region.width;
        } else if (y > region.y + region.height) {
            ++region.height;
        }
        this.crawl(x + 1, y, marks, region);
        this.crawl(x - 1, y, marks, region);
        this.crawl(x, y + 1, marks, region);
        this.crawl(x, y - 1, marks, region);
    }

    public final void shiftReleased() {
        if (!shiftDown) {
            return;
        }
        shiftDown = false;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public final void shiftPressed() {
        if (shiftDown) {
            return;
        }
        shiftDown = true;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public final void altReleased() {
        altDown = false;
    }

    public final void altPressed() {
        altDown = true;
    }

    public void controlReleased() {
        this.debug = false;
        controlDown = false;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public void controlPressed() {
        this.debug = true;
        controlDown = true;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public static final Point getQuadraticLocation(Point location1, Point location2, boolean shiftDown) {
        Point location3 = new Point(location2.x, location2.y);
        if (shiftDown) {
            int dx = location2.x - location1.x;
            int dy = location2.y - location1.y;
            if (Toolbox.abs(dx) > Toolbox.abs((int)Math.round((double)dy * 1.98))) {
                location3.y = location1.y + Toolbox.abs((int)Math.round((double)dx / 1.98)) * Tool.sgn(dy);
            } else {
                location3.x = location1.x + Toolbox.abs((int)Math.round((double)dy * 1.98)) * Tool.sgn(dx);
            }
        }
        return location3;
    }

    public static final Point getQuadraticPointFor(Point point1, Point point2, boolean shiftDown) {
        if (!shiftDown) {
            return point2;
        }
        Point point3 = new Point(point2.x, point2.y);
        int dx = point2.x - point1.x;
        int dy = point2.y - point1.y;
        if (Toolbox.abs(dx) > Toolbox.abs(dy)) {
            point3.y = point1.y + Toolbox.abs(dx) * Tool.sgn(dy);
        } else {
            point3.x = point1.x + Toolbox.abs(dy) * Tool.sgn(dx);
        }
        return point3;
    }

    public void checkSize() {
    }

    public static final int sgn(int x) {
        if (x < 0) {
            return -1;
        }
        return 1;
    }

    public void itemStateChanged(ItemEvent evt) {
        this.mainPanel.requestFocus();
    }

    public void actionPerformed(ActionEvent evt) {
        this.mainPanel.requestFocus();
    }

    public final void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public final void packOptionsDialog() {
        this.jave.packOptionsDialog();
    }

    public abstract Icon getIcon();

    public abstract String getName();

    protected final void setCursor(Cursor c) {
        this.cursor = c;
        Plate plate = this.mainPanel.getPlate();
        if (plate != null) {
            plate.setCursor(this.cursor);
        }
    }

    public final Cursor getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION);
    }

    public final void showCoordinates(Point p) {
        this.mainPanel.getPlate().showCoordinates(p);
    }

    public void mouseExited(Point point, Point location, MouseEvent evt) {
    }

    public void mouseMoved(Point point, Point location, MouseEvent evt) {
    }

    public void mouseDragged(Point point, Point location, MouseEvent evt) {
    }

    public void mousePressed(Point point, Point location, MouseEvent evt) {
    }

    public void mouseReleased(Point point, Point location, MouseEvent evt) {
    }

    public void mouseClicked(Point point, Point location, MouseEvent evt) {
    }

    public final void setMixMode(boolean what) {
        Plate plate = this.mainPanel.getPlate();
        if (plate != null) {
            plate.setMix(what);
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyPressed(int code, KeyEvent evt) {
    }

    public void keyTyped(char ch, KeyEvent evt) {
    }

    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
    }

    public final void repaintCursor() {
        this.mainPanel.repaintCursor();
    }

    public final void repaintAll() {
        this.mainPanel.repaint();
    }

    public final void saveCurrentState(String shortDescription) {
        this.mainPanel.saveCurrentState(shortDescription);
    }

    public final char getMouseChar() {
        return this.getMouseCharacterModel().getCharacter(this.isMouseRightButton());
    }

    protected final MouseCharacterModel getMouseCharacterModel() {
        return this.mainPanel.getMouseCharacterModel();
    }

    protected final BooleanModel getMixCharactersModel() {
        return this.mainPanel.getMixCharactersModel();
    }

    protected final boolean isMix() {
        return this.getMixCharactersModel().getValue();
    }

    public final boolean isMouseRightButton() {
        return this.mainPanel.getPlate().isMouseRightButton();
    }

    public abstract void putAside(boolean var1);

    public abstract void takeToHand();

    public final void reset() {
        this.putAside(false);
        this.takeToHand();
    }

    public JComponent createOptionsComponent() {
        return this.toolLabel;
    }

    public JComponent getOptionsComponent() {
        if (this.optionsComponent == null) {
            this.optionsComponent = this.createOptionsComponent();
        }
        return this.optionsComponent;
    }

    protected final void showStatus(String text) {
        this.mainPanel.showStatus(text);
    }

    protected final Point getScreenPointFor(int x, int y) {
        return this.mainPanel.getPlate().getScreenPointFor(x, y);
    }

    public static final Rectangle getRectangleFor(Point location1, Point location2) {
        return new Rectangle(location1.x < location2.x ? location1.x : location2.x, location1.y < location2.y ? location1.y : location2.y, 1 + (location1.x < location2.x ? location2.x - location1.x : location1.x - location2.x), 1 + (location1.y < location2.y ? location2.y - location1.y : location1.y - location2.y));
    }
}

