/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.Jave;
import de.jave.jave.Plate;
import de.jave.jave.Selection;
import de.jave.jave.Tool;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.lib.CharacterPlate;
import de.jave.text.TextTools;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class SelectionTool
extends Tool
implements ActionListener,
ItemListener,
Runnable {
    private Thread blinkThread;
    private boolean shallStop;
    protected Point location1;
    private Point point1;
    protected Point location2;
    protected int mode = 1;
    private boolean movedByCursor = false;
    private boolean resizedByCursor = false;
    private int keySelectionAnchorH = 5;
    private int keySelectionAnchorV = 3;
    private boolean selectionMoved = false;
    private boolean selectionResized = false;
    private JCheckBox cbMix;
    private JCheckBox cb3d;
    private JComboBox chSelectionLayer;
    private JCheckBox cbCollision;
    private int dx;
    private int dy;
    private int gdx;
    private int gdy;

    public SelectionTool(JaveMainPanel mainPanel, Jave jave) {
        super(mainPanel, jave);
    }

    public final boolean containsLocation(Point location) {
        return this.hasSelection() && this.getPlate().getSelection().contains(location);
    }

    public final JComponent createOptionsComponent() {
        this.cb3d = new JCheckBox("3D View", true);
        this.cb3d.addItemListener(this);
        this.cbMix = new JCheckBox("Mix Characters", false);
        this.cbMix.addItemListener(this);
        this.chSelectionLayer = new JComboBox<String>(Selection.STR_LAYER);
        this.chSelectionLayer.addItemListener(this);
        this.chSelectionLayer.setSelectedIndex(1);
        this.cbCollision = new JCheckBox("Collision", false);
        this.cbMix.setEnabled(this.chSelectionLayer.getSelectedIndex() == 2);
        JPanel optionsPanel = new JPanel(new GridDialogLayout(2, false));
        optionsPanel.add((Component)new JLabel("Paste mode:"), GridDialogLayoutData.RIGHT);
        optionsPanel.add(this.chSelectionLayer);
        optionsPanel.add(this.cbCollision);
        optionsPanel.add(this.cb3d);
        GridDialogLayoutData data = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        data.setHorizontalSpan(2);
        optionsPanel.add((Component)this.cbMix, data);
        return optionsPanel;
    }

    public String getName() {
        return "Selection";
    }

    public Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/selection.gif");
    }

    public final void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        if (this.cbMix != null) {
            this.setMixMode(this.cbMix.isSelected());
        } else {
            this.setMixMode(false);
        }
        this.blinkThread = new Thread((Runnable)this, "SelectionBorder");
        this.shallStop = false;
        this.blinkThread.setPriority(1);
        this.blinkThread.start();
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
        this.shallStop = true;
        if (!nextToolIsSelectionTool && this.hasSelection()) {
            this.getPlate().dropSelection();
            this.getPlate().saveCurrentState("drop selection");
        }
        this.point1 = null;
        this.location1 = null;
        this.location2 = null;
    }

    public final void prepareForSave() {
        if (this.hasSelection()) {
            this.dropSelection();
        }
    }

    public final void run() {
        boolean sleepTime = false;
        long time0 = System.currentTimeMillis();
        while (!this.shallStop) {
            long time1 = time0;
            while (time1 - time0 < (long)600) {
                try {
                    Thread.sleep((long)600 - (time1 - time0));
                }
                catch (InterruptedException interruptedException) {}
                time1 = System.currentTimeMillis();
            }
            time0 = time1;
            if (!this.hasSelection()) continue;
            this.repaintCursor();
        }
    }

    public final void actionPerformed(ActionEvent evt) {
        this.getPlate().requestFocus();
    }

    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.location1 != null && this.location2 != null) {
            Rectangle r = SelectionTool.getRectangleFor(this.location1, this.location2);
            this.showStatus("(" + r.x + "," + r.y + ") -> (" + (r.x + r.width) + "," + r.y + r.height + ") = (" + r.width + "," + r.height + ")");
            g.setColor(colorScheme.getColorTool());
            Point p = this.getScreenPointFor(r.x, r.y);
            g.drawRect(p.x, p.y, r.width * this.getPlate().getCharWidth(), r.height * this.getPlate().getCharHeight());
        }
    }

    public final void itemStateChanged(ItemEvent evt) {
        if (evt != null && evt.getSource() == this.cbMix) {
            this.setMixMode(this.cbMix.isSelected());
        }
        if (!this.hasSelection()) {
            return;
        }
        this.cbMix.setEnabled(this.chSelectionLayer.getSelectedIndex() == 2);
        this.synchronizeToSelection();
        this.getPlate().requestFocus();
    }

    private boolean hasSelection() {
        Plate plate = this.getPlate();
        if (plate == null) {
            return false;
        }
        return plate.hasSelection();
    }

    public final void synchronizeToSelection() {
        Plate plate = this.getPlate();
        Selection sel = plate == null ? null : plate.getSelection();
        if (sel == null) {
            this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
            return;
        }
        sel.setLayer(this.chSelectionLayer.getSelectedIndex());
        sel.set3dView(this.cb3d.isSelected());
        this.repaintAll();
    }

    protected void selectionCanceled() {
        this.mode = 1;
        this.location1 = null;
        this.repaintCursor();
    }

    public final void keyPressed(int code, KeyEvent evt) {
        if (this.hasSelection()) {
            if (shiftDown) {
                this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_PLUS));
            } else if (controlDown) {
                this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_MINUS));
            }
        }
        if (!(code != 27 || this.hasSelection() && this.mode != 11 && this.mode != 12)) {
            this.selectionCanceled();
            return;
        }
        if (!this.hasSelection()) {
            return;
        }
        if (altDown && code == 38) {
            this.chSelectionLayer.setSelectedIndex((this.chSelectionLayer.getSelectedIndex() + 1) % 3);
            this.itemStateChanged(null);
            return;
        }
        if (altDown && code == 40) {
            int sel = this.chSelectionLayer.getSelectedIndex() - 1;
            if (sel < 0) {
                sel = 2;
            }
            this.chSelectionLayer.setSelectedIndex(sel);
            this.itemStateChanged(null);
            return;
        }
        if (code == 127) {
            this.jave.doSelectionDelete();
            this.jave.switchToTextTool();
            return;
        }
        if (!(controlDown || shiftDown || code != 38 && code != 40 && code != 37 && code != 39)) {
            Rectangle r = this.getPlate().getSelectionRegion();
            this.dropSelection();
            int x = 0;
            int y = 0;
            if (code == 38 || code == 40) {
                x = this.keySelectionAnchorH == 4 ? r.x : r.x + r.width - 1;
                y = code == 38 ? r.y : r.y + r.height;
            } else {
                y = this.keySelectionAnchorV == 2 ? r.y : r.y + r.height - 1;
                x = code == 37 ? r.x : r.x + r.width;
            }
            boolean ok = true;
            if (x >= this.getPlate().getDocumentSize().width) {
                ok = false;
                x = this.getPlate().getDocumentSize().width - 1;
            }
            if (y >= this.getPlate().getDocumentSize().height) {
                ok = false;
                y = this.getPlate().getDocumentSize().height - 1;
            }
            if (!ok) {
                this.beep();
            }
            this.jave.switchToTextTool(x, y);
            return;
        }
        if (code == 10 || code == 27) {
            Rectangle r = this.getPlate().getSelectionRegion();
            this.dropSelection();
            this.jave.switchToTextTool(r.x, r.y);
            return;
        }
        if (shiftDown && (code == 38 || code == 40 || code == 37 || code == 39)) {
            Rectangle region = this.getPlate().getSelectionRegion();
            switch (code) {
                case 38: {
                    if (region.height == 1) {
                        this.getPlate().getSelection().resizeByCursorN_UP();
                        this.ensureSelectionTopVisible();
                        this.keySelectionAnchorV = 2;
                        break;
                    }
                    if (this.keySelectionAnchorV == 2) {
                        this.getPlate().getSelection().resizeByCursorN_UP();
                        this.ensureSelectionTopVisible();
                        break;
                    }
                    this.getPlate().getSelection().resizeByCursorS_UP();
                    this.ensureSelectionBottomVisible();
                    break;
                }
                case 40: {
                    if (region.height == 1) {
                        this.getPlate().getSelection().resizeByCursorS_DOWN();
                        this.ensureSelectionBottomVisible();
                        this.keySelectionAnchorV = 3;
                        break;
                    }
                    if (this.keySelectionAnchorV == 2) {
                        this.getPlate().getSelection().resizeByCursorN_DOWN();
                        this.ensureSelectionTopVisible();
                        break;
                    }
                    this.getPlate().getSelection().resizeByCursorS_DOWN();
                    this.ensureSelectionBottomVisible();
                    this.keySelectionAnchorV = 3;
                    break;
                }
                case 37: {
                    if (region.width == 1) {
                        this.getPlate().getSelection().resizeByCursorW_LEFT();
                        this.keySelectionAnchorH = 4;
                        this.ensureSelectionLeftVisible();
                        break;
                    }
                    if (this.keySelectionAnchorH == 4) {
                        this.getPlate().getSelection().resizeByCursorW_LEFT();
                        this.ensureSelectionLeftVisible();
                        break;
                    }
                    this.getPlate().getSelection().resizeByCursorE_LEFT();
                    this.ensureSelectionRightVisible();
                    break;
                }
                case 39: {
                    if (region.width == 1) {
                        this.getPlate().getSelection().resizeByCursorE_RIGHT();
                        this.ensureSelectionRightVisible();
                        this.keySelectionAnchorH = 5;
                        break;
                    }
                    if (this.keySelectionAnchorH == 4) {
                        this.getPlate().getSelection().resizeByCursorW_RIGHT();
                        this.ensureSelectionLeftVisible();
                        break;
                    }
                    this.ensureSelectionRightVisible();
                    this.getPlate().getSelection().resizeByCursorE_RIGHT();
                }
            }
            this.getPlate().repaint();
            this.resizedByCursor = true;
            return;
        }
        switch (code) {
            case 38: {
                this.moveSelectionByCursor(0, -1);
                this.ensureSelectionTopVisible();
                evt.consume();
                return;
            }
            case 40: {
                this.moveSelectionByCursor(0, 1);
                this.ensureSelectionBottomVisible();
                evt.consume();
                return;
            }
            case 37: {
                this.moveSelectionByCursor(-1, 0);
                this.ensureSelectionLeftVisible();
                evt.consume();
                return;
            }
            case 39: {
                this.moveSelectionByCursor(1, 0);
                this.ensureSelectionRightVisible();
                evt.consume();
            }
        }
    }

    private void ensureSelectionTopVisible() {
        this.getPlate().ensureVisible(this.getPlate().getSelection().getLocation());
    }

    private void ensureSelectionBottomVisible() {
        this.getPlate().ensureVisible(new Point(this.getPlate().getSelection().getLocation().x, this.getPlate().getSelection().getLocation().y + this.getPlate().getSelection().getHeight() - 1));
    }

    private void ensureSelectionLeftVisible() {
        this.getPlate().ensureVisible(this.getPlate().getSelection().getLocation());
    }

    private void ensureSelectionRightVisible() {
        this.getPlate().ensureVisible(new Point(this.getPlate().getSelection().getLocation().x + this.getPlate().getSelection().getWidth() - 1, this.getPlate().getSelection().getLocation().y));
    }

    private void moveSelectionByCursor(int dx, int dy) {
        this.getPlate().moveSelection(dx, dy, this.cbCollision.isSelected());
        Rectangle region = this.getPlate().getSelectionRegion();
        Point location = new Point(region.x + region.width / 2, region.y + region.height / 2);
        this.getPlate().ensureVisible(location);
        this.movedByCursor = true;
    }

    public final void keyReleased(KeyEvent evt) {
        if (this.movedByCursor) {
            this.movedByCursor = false;
            this.saveCurrentState("move selection");
        }
        if (this.resizedByCursor) {
            this.resizedByCursor = false;
            this.saveCurrentState("resize selection");
        }
        if (this.mode == 11 || this.mode == 12) {
            this.mode = 1;
            this.location1 = null;
            this.location2 = null;
            this.repaintCursor();
        }
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    public final void keyTyped(char ch, KeyEvent evt) {
        if (controlDown && ch != '@' && ch != '~' && ch != '|' && ch != '\\') {
            return;
        }
        if (this.hasSelection()) {
            Rectangle r = this.getPlate().getSelectionRegion();
            this.jave.doSelectionDelete();
            this.jave.switchToTextTool(ch, r.x, r.y);
            return;
        }
    }

    protected final void dropSelection() {
        this.getPlate().dropSelection();
        this.mode = 1;
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        this.saveCurrentState("drop selection");
        this.repaintAll();
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        this.location2 = null;
        this.location1 = location;
        this.point1 = point;
        if (evt.isMetaDown()) {
            this.location1 = null;
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintCursor();
            }
        }
        if (this.hasSelection() && shiftDown) {
            this.mode = 11;
            this.selectionMousePressedStarted(location);
            return;
        }
        if (this.hasSelection() && controlDown) {
            this.mode = 12;
            this.selectionMousePressedStarted(location);
            return;
        }
        if (this.hasSelection() && (evt.isMetaDown() || !this.getPlate().selectionContains(location))) {
            this.dropSelection();
            this.mode = 10;
            this.selectionMousePressedStarted(location);
            return;
        }
        if (location == null) {
            return;
        }
        if (this.hasSelection()) {
            Selection sel = this.getPlate().getSelection();
            int place = sel.getPlace(point);
            if (place == 1) {
                this.mode = 0;
            } else if (place == 0) {
                this.mode = 10;
                this.selectionMousePressedStarted(location);
            } else if (place == 2) {
                this.mode = 2;
            } else if (place == 4) {
                this.mode = 3;
            } else if (place == 3) {
                this.mode = 4;
            } else if (place == 5) {
                this.mode = 5;
            } else if (place == 7) {
                this.mode = 7;
            } else if (place == 6) {
                this.mode = 6;
            } else if (place == 9) {
                this.mode = 9;
            } else if (place == 8) {
                this.mode = 8;
            }
            return;
        }
        this.mode = 10;
        this.selectionMousePressedStarted(location);
    }

    protected void selectionMousePressedStarted(Point location) {
        this.location1 = location;
    }

    protected void selectionMouseDragged(Point location) {
        if (location.equals(this.location2)) {
            return;
        }
        this.location2 = location;
        this.repaintCursor();
    }

    protected void selectionMouseReleasedFinished(Point location) {
        Rectangle region = SelectionTool.getRectangleFor(this.location1, location);
        this.dx = 0;
        this.dy = 0;
        this.location1 = null;
        if (this.mode == 10) {
            CharacterPlate content = this.getPlate().cut(region);
            this.getPlate().getSelection().set(region, content);
            this.jave.updateSelectionMenu();
            this.synchronizeToSelection();
            this.repaintAll();
            this.getPlate().saveCurrentState("select");
        } else if (this.mode == 11) {
            boolean success = this.getPlate().getSelection().add(region);
            if (!success) {
                this.repaintCursor();
            } else {
                this.repaintAll();
                this.getPlate().saveCurrentState("modify selection");
            }
        } else if (this.mode == 12) {
            boolean success = this.getPlate().getSelection().remove(region);
            if (!success) {
                this.repaintCursor();
            } else {
                this.repaintAll();
                if (this.hasSelection()) {
                    this.getPlate().saveCurrentState("modify selection");
                } else {
                    this.getPlate().saveCurrentState("drop selection");
                    this.jave.switchToTextTool();
                }
            }
        }
        this.mode = 1;
    }

    public final void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (location != null) {
            this.showStatus("(" + location.x + "," + location.y + ")");
        }
        if (this.mode == 11) {
            if (this.location1 == null || location == null || evt.isMetaDown()) {
                this.mode = 1;
                this.location1 = null;
                return;
            }
            this.selectionMouseReleasedFinished(location);
            return;
        }
        if (this.mode == 12) {
            if (this.location1 == null || location == null || evt.isMetaDown()) {
                this.mode = 1;
                this.location1 = null;
                return;
            }
            this.selectionMouseReleasedFinished(location);
            return;
        }
        if (this.hasSelection()) {
            this.dx = 0;
            this.dy = 0;
            this.gdx = 0;
            this.gdy = 0;
            this.location1 = null;
            this.point1 = null;
            if (this.selectionResized) {
                this.getPlate().saveCurrentState("resize selection");
                this.selectionResized = false;
            }
            if (this.selectionMoved) {
                this.getPlate().saveCurrentState("move selection");
                this.selectionMoved = false;
            }
            return;
        }
        if (evt.isMetaDown() && this.location2 != null) {
            this.location2 = null;
            this.location1 = null;
            this.repaintCursor();
            return;
        }
        if (this.location1 == null || location == null || evt.isMetaDown()) {
            return;
        }
        if (GfxTools.distance(point, this.point1) >= 3.0) {
            this.selectionMouseReleasedFinished(location);
            return;
        }
        int x = location.x;
        int y = location.y;
        this.location1 = null;
        this.location2 = null;
        this.jave.switchToTextTool(x, y);
    }

    public final void mouseClicked(Point point, Point location, MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.hasSelection()) {
            Selection sel = this.getPlate().getSelection();
            if (sel.contains(location) && sel.isTextbox()) {
                char[][] ch = sel.getContent().getContent();
                char[][] content = new char[ch.length - 2][ch[0].length - 2];
                for (int x = 0; x < content.length; ++x) {
                    for (int y = 0; y < content[0].length; ++y) {
                        content[x][y] = ch[x + 1][y + 1];
                    }
                }
                this.jave.editTextBox(TextTools.toString(content), sel.getLocation(), sel.getTextboxStyle());
            }
            return;
        }
        if (evt.isMetaDown() || !this.getPlate().selectionContains(location)) {
            if (this.hasSelection()) {
                this.dropSelection();
            }
            if (location != null) {
                this.jave.switchToTextTool(location.x, location.y);
            }
            return;
        }
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.mode == 1 || evt.isMetaDown()) {
            return;
        }
        if (this.mode == 12 || this.mode == 11) {
            this.selectionMouseDragged(location);
            return;
        }
        if (this.hasSelection()) {
            if (location == null || this.point1 == null) {
                return;
            }
            int ddx = (point.x - this.point1.x) / this.getPlate().getCharWidth();
            int ddy = (point.y - this.point1.y) / this.getPlate().getCharHeight();
            if (ddx != this.dx || ddy != this.dy) {
                if (this.mode == 0) {
                    int xx = ddx - this.dx;
                    int yy = ddy - this.dy;
                    while (xx < 0 && this.gdx > 0) {
                        ++xx;
                        --this.gdx;
                    }
                    while (xx > 0 && this.gdx < 0) {
                        --xx;
                        ++this.gdx;
                    }
                    while (yy < 0 && this.gdy > 0) {
                        ++yy;
                        --this.gdy;
                    }
                    while (yy > 0 && this.gdy < 0) {
                        --yy;
                        ++this.gdy;
                    }
                    Point tat = this.getPlate().moveSelection(xx, yy, this.cbCollision.isSelected());
                    this.getPlate().ensureVisible(location);
                    this.gdx += xx - tat.x;
                    this.gdy += yy - tat.y;
                    this.selectionMoved = true;
                } else {
                    this.resize(ddx - this.dx, ddy - this.dy);
                    this.selectionResized = true;
                }
                this.dx = ddx;
                this.dy = ddy;
                StringBuffer s = new StringBuffer("[");
                if (this.dx > 0) {
                    s.append('+');
                }
                s.append(this.dx);
                s.append(',');
                if (this.dy > 0) {
                    s.append('+');
                }
                s.append(this.dy);
                s.append(']');
                this.showStatus(s.toString());
            }
            return;
        }
        if (location == null) {
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintAll();
            }
            return;
        }
        this.selectionMouseDragged(location);
    }

    private void resize(int dx, int dy) {
        Selection sel = this.getPlate().getSelection();
        switch (this.mode) {
            case 2: {
                sel.resizeTextboxN(dy);
                return;
            }
            case 3: {
                sel.resizeTextboxS(dy);
                return;
            }
            case 4: {
                sel.resizeTextboxW(dx);
                return;
            }
            case 5: {
                sel.resizeTextboxE(dx);
                return;
            }
            case 6: {
                sel.resizeTextboxN(dy);
                sel.resizeTextboxE(dx);
                return;
            }
            case 7: {
                sel.resizeTextboxN(dy);
                sel.resizeTextboxW(dx);
                return;
            }
            case 8: {
                sel.resizeTextboxS(dy);
                sel.resizeTextboxE(dx);
                return;
            }
            case 9: {
                sel.resizeTextboxS(dy);
                sel.resizeTextboxW(dx);
            }
        }
    }

    public final void mouseMoved(Point point, Point location, MouseEvent evt) {
        if (this.hasSelection() && location != null) {
            Selection sel = this.getPlate().getSelection();
            int place = sel.getPlace(point);
            if (place == 1) {
                if (shiftDown) {
                    this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_PLUS));
                } else if (controlDown) {
                    this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_MINUS));
                } else if (sel.contains(location)) {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
                }
            } else if (place == 0) {
                if (shiftDown) {
                    this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_PLUS));
                } else if (controlDown) {
                    this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_MINUS));
                } else {
                    this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
                }
            } else if (place == 2) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (place == 4) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else if (place == 3) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (place == 5) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (place == 7) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (place == 6) {
                this.setCursor(Cursor.getPredefinedCursor(7));
            } else if (place == 9) {
                this.setCursor(Cursor.getPredefinedCursor(4));
            } else if (place == 8) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            }
            return;
        }
        if (this.hasSelection()) {
            if (shiftDown) {
                this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_PLUS));
                return;
            }
            if (controlDown) {
                this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION_MINUS));
                return;
            }
            this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
            return;
        }
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    static {
        String[] stringArray = new String[]{"MOVE", "NONE", "N_RESIZE", "S_RESIZE", "W_RESIZE", "E_RESIZE", "NE_RESIZE", "NW_RESIZE", "SE_RESIZE", "SW_RESIZE", "SELECT", "SELECT_PLUS", "SELECT_MINUS"};
    }
}

