/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.ascii.plate.CharacterMetrics;
import de.jave.awt.clipboard.JaveClipboardSelection;
import de.jave.gfx.GfxTools;
import de.jave.jave.JaveSelection;
import de.jave.jave.Plate;
import de.jave.jave.TextboxDialog;
import de.jave.jave.algorithm.rectangle.RectangleStyle;
import de.jave.jave.preferences.ColorScheme;
import de.jave.lib.BooleanPlate;
import de.jave.lib.CharacterPlate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public final class Selection {
    private Rectangle region;
    private CharacterPlate content;
    private BooleanPlate mask;
    private CharacterPlate originalContent;
    private int originalContentX;
    private int originalContentY;
    private Plate plate;
    private RectangleStyle textboxStyle;
    private int layer = 1;
    private boolean d3View = true;
    public static final String[] STR_LAYER = new String[]{"Background", "Normal", "Foreground", "Difference"};

    public final void setPlate(Plate plate) {
        this.plate = plate;
    }

    public final boolean isTextbox() {
        return this.getTextboxStyle() != null;
    }

    public final RectangleStyle getTextboxStyle() {
        if (this.textboxStyle == null) {
            this.textboxStyle = TextboxDialog.getTextboxStyle(this.content.getContent());
        }
        return this.textboxStyle;
    }

    public final boolean hasSelection() {
        return this.region != null && this.content != null;
    }

    public final Point getLocation() {
        return this.region.getLocation();
    }

    public final boolean contains(Point location) {
        if (this.region == null || location == null) {
            return false;
        }
        if (this.mask == null) {
            return this.region.contains(location);
        }
        return this.region.contains(location) && this.mask.isSet(location.x - this.region.x, location.y - this.region.y);
    }

    public final int getPlace(Point point) {
        Point p0 = this.plate.getScreenPointFor(this.region.x, this.region.y);
        Point p1 = this.plate.getScreenPointFor(this.region.x + this.region.width, this.region.y + this.region.height);
        if (p0.x > point.x || p0.y > point.y || p1.x < point.x || p1.y < point.y) {
            return 0;
        }
        if (!this.isTextbox()) {
            return 1;
        }
        int x0 = p0.x;
        int y0 = p0.y;
        int x1 = p1.x + 2;
        int y1 = p1.y + 2;
        boolean b = false;
        if (Selection.contains((x0 + x1 - 7) / 2, y0, 7, 7, point.x, point.y)) {
            return 2;
        }
        if (Selection.contains((x0 + x1 - 7) / 2, y1 - 7, 7, 7, point.x, point.y)) {
            return 4;
        }
        if (Selection.contains(x0, (y0 + y1 - 7) / 2, 7, 7, point.x, point.y)) {
            return 3;
        }
        if (Selection.contains(x1 - 7, (y0 + y1 - 7) / 2, 7, 7, point.x, point.y)) {
            return 5;
        }
        if (Selection.contains(x0, y1 - 7, 7, 7, point.x, point.y)) {
            return 9;
        }
        if (Selection.contains(x1 - 7, y1 - 7, 7, 7, point.x, point.y)) {
            return 8;
        }
        if (Selection.contains(x0, y0, 7, 7, point.x, point.y)) {
            return 7;
        }
        if (Selection.contains(x1 - 7, y0, 7, 7, point.x, point.y)) {
            return 6;
        }
        return 1;
    }

    private static final boolean contains(int x0, int y0, int w, int h, int x, int y) {
        return x0 <= x && y0 <= y && x0 + w >= x && y0 + h >= y;
    }

    public final void delete() {
        this.region = null;
        this.content = null;
        this.mask = null;
    }

    public final CharacterPlate getContent() {
        return this.content;
    }

    public final BooleanPlate getMask() {
        return this.mask;
    }

    public final JaveSelection getJaveSelection() {
        return new JaveSelection(this.content, this.mask);
    }

    public final Rectangle getRegion() {
        return this.region;
    }

    public final int getWidth() {
        return this.region.width;
    }

    public final int getHeight() {
        return this.region.height;
    }

    public final void setLocation(int x, int y) {
        if (this.region == null) {
            return;
        }
        this.region.x = x;
        this.region.y = y;
    }

    public final void resizeByCursorN_UP() {
        this.content.addLinesTop(1);
        --this.region.y;
        ++this.region.height;
        CharacterPlate line = this.plate.cut(new Rectangle(this.region.x, this.region.y, this.region.width, 1));
        this.content.paste(line, 0, 0, this.region.width, 1);
        if (this.mask != null) {
            this.mask.addLinesTop(1, true);
        }
    }

    public final void resizeByCursorS_DOWN() {
        this.content.addLinesBottom(1);
        ++this.region.height;
        CharacterPlate line = this.plate.cut(new Rectangle(this.region.x, this.region.y + this.region.height - 1, this.region.width, 1));
        this.content.paste(line, 0, this.region.height - 1, this.region.width, 1);
        if (this.mask != null) {
            this.mask.addLinesBottom(1, true);
        }
    }

    public final void resizeByCursorS_UP() {
        char[][] line = this.content.getCopy(0, this.region.height - 1, this.region.width, 1).getContent();
        try {
            this.plate.getContent().paste(line, this.region.x, this.region.y + this.region.height - 1, this.region.width, 1);
        }
        catch (Exception exception) {}
        this.content.setSize(this.content.getWidth(), this.content.getHeight() - 1);
        --this.region.height;
        if (this.mask != null) {
            this.mask.removeLinesBottom(1);
        }
    }

    public final void resizeByCursorN_DOWN() {
        char[][] line = this.content.getCopy(0, 0, this.region.width, 1).getContent();
        try {
            this.plate.getContent().paste(line, this.region.x, this.region.y, this.region.width, 1);
        }
        catch (Exception exception) {}
        this.content.removeLinesTop(1);
        --this.region.height;
        ++this.region.y;
        if (this.mask != null) {
            this.mask.removeLinesTop(1);
        }
    }

    public final void resizeByCursorW_LEFT() {
        this.content.addColumnsLeft(1);
        --this.region.x;
        ++this.region.width;
        CharacterPlate line = this.plate.cut(new Rectangle(this.region.x, this.region.y, 1, this.region.height));
        this.content.paste(line, 0, 0, 1, this.region.height);
        if (this.mask != null) {
            this.mask.addColumnsLeft(1, true);
        }
    }

    public final void resizeByCursorE_RIGHT() {
        this.content.addColumnsRight(1);
        ++this.region.width;
        CharacterPlate line = this.plate.cut(new Rectangle(this.region.x + this.region.width - 1, this.region.y, 1, this.region.height));
        this.content.paste(line, this.region.width - 1, 0, 1, this.region.height);
        if (this.mask != null) {
            this.mask.addColumnsRight(1, true);
        }
    }

    public final void resizeByCursorE_LEFT() {
        char[][] line = this.content.getCopy(this.region.width - 1, 0, 1, this.region.height).getContent();
        try {
            this.plate.getContent().paste(line, this.region.x + this.region.width - 1, this.region.y, 1, this.region.width);
        }
        catch (Exception exception) {}
        this.content.removeColumnsRight(1);
        --this.region.width;
        if (this.mask != null) {
            this.mask.removeColumnsRight(1);
        }
    }

    public final void resizeByCursorW_RIGHT() {
        char[][] line = this.content.getCopy(0, 0, 1, this.region.height).getContent();
        try {
            this.plate.getContent().paste(line, this.region.x, this.region.y, 1, this.region.height);
        }
        catch (Exception exception) {}
        this.content.removeColumnsLeft(1);
        --this.region.width;
        ++this.region.x;
        if (this.mask != null) {
            this.mask.removeColumnsLeft(1);
        }
    }

    public final void set(Rectangle region, CharacterPlate content) {
        this.set(region, content, (BooleanPlate)null);
    }

    public final void set(Rectangle region, BooleanPlate mask) {
        CharacterPlate content1 = new CharacterPlate(region.width, region.height);
        for (int y = 0; y < region.height; ++y) {
            for (int x = 0; x < region.width; ++x) {
                if (!mask.isSet(x, y) || !this.plate.getContent().contains(region.x + x, region.y + y)) continue;
                content1.set(x, y, this.plate.getChar(region.x + x, region.y + y));
                this.plate.setCharForce(region.x + x, region.y + y, ' ');
            }
        }
        this.set(region, content1, mask);
        this.optimizeSelectionRegion();
    }

    public final void set(Rectangle region, JaveSelection sel) {
        this.set(region, sel.getContent(), sel.getMask());
    }

    private void set(Rectangle region, CharacterPlate content, BooleanPlate mask) {
        this.mask = mask;
        this.region = region;
        this.content = content;
        this.textboxStyle = null;
        this.originalContentX = 0;
        this.originalContentY = 0;
        this.originalContent = content.getClone();
    }

    public final void set(Point origin, char[][] content, BooleanPlate mask) {
        if (origin == null || content == null) {
            this.region = null;
            this.content = null;
            this.mask = null;
            this.textboxStyle = null;
            return;
        }
        this.set(new Rectangle(origin.x, origin.y, content[0].length, content.length), new CharacterPlate(content), mask);
    }

    public final void set(Point origin, CharacterPlate content) {
        if (origin == null || content == null) {
            this.region = null;
            this.mask = null;
            this.content = null;
            this.textboxStyle = null;
            return;
        }
        this.set(new Rectangle(origin.x, origin.y, content.getWidth(), content.getHeight()), content);
    }

    public final void set(Point origin, JaveClipboardSelection sel) {
        if (origin == null || sel == null) {
            this.region = null;
            this.mask = null;
            this.content = null;
            this.textboxStyle = null;
            return;
        }
        this.set(new Rectangle(origin.x, origin.y, sel.getContent().getWidth(), sel.getContent().getHeight()), sel.getContent(), sel.getMask());
    }

    public final boolean add(Rectangle addRegion) {
        return this.add(addRegion, null);
    }

    public final boolean add(Rectangle addRegion, BooleanPlate addMask) {
        int bottom;
        int right;
        int left;
        CharacterPlate addContent = new CharacterPlate(addRegion.width, addRegion.height);
        for (int y = 0; y < addRegion.height; ++y) {
            for (int x = 0; x < addRegion.width; ++x) {
                if (addMask != null && !addMask.isSet(x, y) || !this.plate.contains(addRegion.x + x, addRegion.y + y)) continue;
                addContent.set(x, y, this.plate.getChar(addRegion.x + x, addRegion.y + y));
                this.plate.setCharForce(addRegion.x + x, addRegion.y + y, ' ');
            }
        }
        int top = this.region.y - addRegion.y;
        if (top < 0) {
            top = 0;
        }
        if ((left = this.region.x - addRegion.x) < 0) {
            left = 0;
        }
        if ((right = addRegion.x + addRegion.width - (this.region.x + this.region.width)) < 0) {
            right = 0;
        }
        if ((bottom = addRegion.y + addRegion.height - (this.region.y + this.region.height)) < 0) {
            bottom = 0;
        }
        if (top > 0 || bottom > 0 || right > 0 || left > 0) {
            if (this.mask == null) {
                this.mask = new BooleanPlate(this.region.width, this.region.height);
                this.mask.setAll(true);
            }
            if (top > 0) {
                this.content.addLinesTop(top);
                this.mask.addLinesTop(top, false);
                this.region.y -= top;
                this.region.height += top;
            }
            if (bottom > 0) {
                this.content.addLinesBottom(bottom);
                this.mask.addLinesBottom(bottom, false);
                this.region.height += bottom;
            }
            if (left > 0) {
                this.content.addColumnsLeft(left);
                this.mask.addColumnsLeft(left, false);
                this.region.x -= left;
                this.region.width += left;
            }
            if (right > 0) {
                this.content.addColumnsRight(right);
                this.mask.addColumnsRight(right, false);
                this.region.width += right;
            }
        }
        if (this.mask == null) {
            return false;
        }
        boolean success = false;
        for (int y = 0; y < addRegion.height; ++y) {
            for (int x = 0; x < addRegion.width; ++x) {
                int maskX = addRegion.x - this.region.x + x;
                int maskY = addRegion.y - this.region.y + y;
                if (this.mask.isSet(maskX, maskY) || addMask != null && !addMask.isSet(x, y)) continue;
                this.mask.set(maskX, maskY, true);
                this.content.setForce(maskX, maskY, addContent.get(x, y));
                success = true;
            }
        }
        if (success && this.mask.isAllSet()) {
            this.mask = null;
        }
        return success;
    }

    public final boolean remove(Rectangle removeRegion) {
        return this.remove(removeRegion, null);
    }

    public final boolean remove(Rectangle removeRegion, BooleanPlate removeMask) {
        if (removeRegion.y > this.region.y + this.region.height - 1 || removeRegion.x > this.region.x + this.region.width - 1 || removeRegion.y + removeRegion.height - 1 < this.region.y || removeRegion.x + removeRegion.width - 1 < this.region.x) {
            return false;
        }
        if (this.mask == null) {
            this.mask = new BooleanPlate(this.region.width, this.region.height);
            this.mask.setAll(true);
        }
        int rdx = 0;
        int rdy = 0;
        int d = removeRegion.x + removeRegion.width - (this.region.x + this.region.width);
        if (d > 0) {
            removeRegion.width -= d;
        }
        if ((d = removeRegion.y + removeRegion.height - (this.region.y + this.region.height)) > 0) {
            removeRegion.height -= d;
        }
        if ((d = this.region.x - removeRegion.x) > 0) {
            removeRegion.x += d;
            removeRegion.width -= d;
            rdx = d;
        }
        if ((d = this.region.y - removeRegion.y) > 0) {
            removeRegion.y += d;
            removeRegion.height -= d;
            rdy = d;
        }
        boolean success = false;
        for (int y = 0; y < removeRegion.height; ++y) {
            for (int x = 0; x < removeRegion.width; ++x) {
                int maskX = removeRegion.x - this.region.x + x;
                int maskY = removeRegion.y - this.region.y + y;
                if (!this.mask.isSet(maskX, maskY) || removeMask != null && !removeMask.isSet(x + rdx, y + rdy)) continue;
                this.mask.set(maskX, maskY, false);
                char ch = this.content.get(maskX, maskY);
                this.content.setForce(maskX, maskY, ' ');
                this.plate.setCharForce(removeRegion.x + x, removeRegion.y + y, ch);
                success = true;
            }
        }
        this.optimizeSelectionRegion();
        return success;
    }

    private void optimizeSelectionRegion() {
        if (this.mask == null) {
            return;
        }
        if (this.mask.isEmpty()) {
            this.mask = null;
            this.content = null;
            this.region = null;
            return;
        }
        Insets in = this.mask.getEmptyInsets(false);
        if (in.top > 0) {
            this.content.removeLinesTop(in.top);
            this.mask.removeLinesTop(in.top);
            this.region.y += in.top;
            this.region.height -= in.top;
        }
        if (in.left > 0) {
            this.content.removeColumnsLeft(in.left);
            this.mask.removeColumnsLeft(in.left);
            this.region.x += in.left;
            this.region.width -= in.left;
        }
        if (in.right > 0) {
            this.content.removeColumnsRight(in.right);
            this.mask.removeColumnsRight(in.right);
            this.region.width -= in.right;
        }
        if (in.bottom > 0) {
            this.content.removeLinesBottom(in.bottom);
            this.mask.removeLinesBottom(in.bottom);
            this.region.height -= in.bottom;
        }
    }

    public final void paste() {
        switch (this.layer) {
            case 1: {
                this.pasteNormal();
                return;
            }
            case 0: {
                this.pasteBackground();
                return;
            }
            case 2: {
                this.pasteForeground();
                return;
            }
            case 3: {
                this.pasteDifference();
            }
        }
    }

    private void pasteNormal() {
        this.pasteIntoNormal(this.plate.getContent());
        this.plate.repaint();
    }

    public final void pasteIntoNormal(CharacterPlate plate1) {
        for (int y = 0; y < this.region.height; ++y) {
            for (int x = 0; x < this.region.width; ++x) {
                if (this.mask != null && !this.mask.isSet(x, y)) continue;
                plate1.set(this.region.x + x, this.region.y + y, this.content.get(x, y));
            }
        }
    }

    private void pasteForeground() {
        CharacterPlate plateContent = this.plate.getContent();
        for (int x = 0; x < this.region.width; ++x) {
            for (int y = 0; y < this.region.height; ++y) {
                if (this.mask != null && !this.mask.isSet(x, y) || this.content.get(x, y) == ' ') continue;
                plateContent.set(this.region.x + x, this.region.y + y, this.content.get(x, y));
            }
        }
        this.plate.repaint();
    }

    private void pasteBackground() {
        CharacterPlate plateContent = this.plate.getContent();
        for (int y = 0; y < this.region.height; ++y) {
            for (int x = 0; x < this.region.width; ++x) {
                if (this.mask != null && !this.mask.isSet(x, y) || this.content.get(x, y) == ' ' || plateContent.get(this.region.x + x, this.region.y + y) != ' ') continue;
                plateContent.set(this.region.x + x, this.region.y + y, this.content.get(x, y));
            }
        }
        this.plate.repaint();
    }

    private void pasteDifference() {
        CharacterPlate plateContent = this.plate.getContent();
        for (int y = 0; y < this.region.height; ++y) {
            for (int x = 0; x < this.region.width; ++x) {
                if (this.mask != null && !this.mask.isSet(x, y) || this.content.get(x, y) == ' ') continue;
                char ch = this.content.get(x, y);
                if (ch == plateContent.get(this.region.x + x, this.region.y + y)) {
                    plateContent.setForce(this.region.x + x, this.region.y + y, ' ');
                    continue;
                }
                if (ch == ' ') continue;
                plateContent.setForce(this.region.x + x, this.region.y + y, ch);
            }
        }
        this.plate.repaint();
    }

    public final Point move(int dx, int dy, boolean collisionDetection) {
        int x;
        int y;
        int y2;
        int x2;
        if (!collisionDetection) {
            this.region.x += dx;
            this.region.y += dy;
            return new Point(dx, dy);
        }
        int rdx = 0;
        int rdy = 0;
        boolean ok = true;
        while (dx > 0 && ok) {
            x2 = this.region.x + this.region.width;
            for (y2 = this.region.y; y2 < this.region.y + this.region.height; ++y2) {
                if (!this.plate.isInside(x2, y2) || this.plate.getChar(x2, y2) == ' ') continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            ++this.region.x;
            --dx;
            ++rdx;
        }
        ok = true;
        while (dx < 0 && ok) {
            x2 = this.region.x - 1;
            for (y2 = this.region.y; y2 < this.region.y + this.region.height; ++y2) {
                if (!this.plate.isInside(x2, y2) || this.plate.getChar(x2, y2) == ' ') continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            --this.region.x;
            ++dx;
            --rdx;
        }
        ok = true;
        while (dy < 0 && ok) {
            y = this.region.y - 1;
            for (x = this.region.x; x < this.region.x + this.region.width; ++x) {
                if (!this.plate.isInside(x, y) || this.plate.getChar(x, y) == ' ') continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            --this.region.y;
            ++dy;
            --rdy;
        }
        ok = true;
        while (dy > 0 && ok) {
            y = this.region.y + this.region.height;
            for (x = this.region.x; x < this.region.x + this.region.width; ++x) {
                if (!this.plate.isInside(x, y) || this.plate.getChar(x, y) == ' ') continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            ++this.region.y;
            --dy;
            ++rdy;
        }
        return new Point(rdx, rdy);
    }

    public final void paintBorder(Graphics2D g, ColorScheme colorScheme) {
        if (this.region == null) {
            return;
        }
        Point p0 = this.plate.getScreenPointFor(this.region.x, this.region.y);
        int w = this.region.width * this.plate.getCharWidth();
        int h = this.region.height * this.plate.getCharHeight();
        int blinkOffset = (int)(System.currentTimeMillis() / 600L % 6L);
        if (this.mask == null) {
            GfxTools.drawBrokenRectangle(g, Color.white, Color.black, p0.x, p0.y, w, h, blinkOffset);
            if (this.d3View) {
                if (this.layer == 0) {
                    g.setColor(colorScheme.getColorPlateBackground().darker());
                    g.drawLine(p0.x + 1, p0.y + 1, p0.x + w - 1, p0.y + 1);
                    g.drawLine(p0.x + 1, p0.y + 1, p0.x + 1, p0.y + h - 1);
                    return;
                }
                if (this.layer == 2) {
                    g.setColor(colorScheme.getColorPlateBackground().darker());
                    g.drawLine(p0.x + 1, p0.y + h + 1, p0.x + w + 1, p0.y + h + 1);
                    g.drawLine(p0.x + w + 1, p0.y + 1, p0.x + w + 1, p0.y + h + 1);
                    return;
                }
            }
        } else {
            int y1;
            int x1;
            int y0;
            int x0;
            int y;
            int x;
            for (x = 0; x < this.region.width; ++x) {
                for (y = 0; y < this.region.height; ++y) {
                    if (!this.mask.isSet(x, y)) continue;
                    if (y == 0 || !this.mask.isSet(x, y - 1)) {
                        x0 = p0.x + x * this.plate.getCharWidth();
                        y0 = p0.y + y * this.plate.getCharHeight();
                        x1 = x0 + this.plate.getCharWidth();
                        y1 = y0;
                        g.setColor(Color.black);
                        g.drawLine(x0, y0, x1, y1);
                        g.setColor(Color.white);
                        GfxTools.drawBrokenLine(g, x0, y0, x1, y1, blinkOffset);
                    }
                    if (y == this.region.height - 1 || !this.mask.isSet(x, y + 1)) {
                        x0 = p0.x + x * this.plate.getCharWidth();
                        y0 = p0.y + (y + 1) * this.plate.getCharHeight();
                        x1 = x0 + this.plate.getCharWidth();
                        y1 = y0;
                        g.setColor(Color.black);
                        g.drawLine(x0, y0, x1, y1);
                        g.setColor(Color.white);
                        GfxTools.drawBrokenLine(g, x0, y0, x1, y1, blinkOffset);
                    }
                    if (x == this.region.width - 1 || !this.mask.isSet(x + 1, y)) {
                        x0 = p0.x + (x + 1) * this.plate.getCharWidth();
                        y0 = p0.y + y * this.plate.getCharHeight();
                        x1 = x0;
                        y1 = y0 + this.plate.getCharHeight();
                        g.setColor(Color.black);
                        g.drawLine(x0, y0, x1, y1);
                        g.setColor(Color.white);
                        GfxTools.drawBrokenLine(g, x0, y0, x1, y1, blinkOffset);
                    }
                    if (x != 0 && this.mask.isSet(x - 1, y)) continue;
                    x0 = p0.x + x * this.plate.getCharWidth();
                    y0 = p0.y + y * this.plate.getCharHeight();
                    x1 = x0;
                    y1 = y0 + this.plate.getCharHeight();
                    g.setColor(Color.black);
                    g.drawLine(x0, y0, x1, y1);
                    g.setColor(Color.white);
                    GfxTools.drawBrokenLine(g, x0, y0, x1, y1, blinkOffset);
                }
            }
            if (this.d3View) {
                if (this.layer == 0) {
                    g.setColor(colorScheme.getColorPlateBackground().darker());
                    for (x = 0; x < this.region.width; ++x) {
                        for (y = 0; y < this.region.height; ++y) {
                            if (!this.mask.isSet(x, y)) continue;
                            if (y == 0 || !this.mask.isSet(x, y - 1)) {
                                x0 = p0.x + x * this.plate.getCharWidth() + 1;
                                y0 = p0.y + y * this.plate.getCharHeight() + 1;
                                x1 = x0 + this.plate.getCharWidth() - 1;
                                y1 = y0;
                                g.drawLine(x0, y0, x1, y1);
                            }
                            if (x != 0 && this.mask.isSet(x - 1, y)) continue;
                            x0 = p0.x + x * this.plate.getCharWidth() + 1;
                            y0 = p0.y + y * this.plate.getCharHeight() + 1;
                            x1 = x0;
                            y1 = y0 + this.plate.getCharHeight() - 1;
                            g.drawLine(x0, y0, x1, y1);
                        }
                    }
                    return;
                }
                if (this.layer == 2) {
                    g.setColor(colorScheme.getColorPlateBackground().darker());
                    for (x = 0; x < this.region.width; ++x) {
                        for (y = 0; y < this.region.height; ++y) {
                            if (!this.mask.isSet(x, y)) continue;
                            if (y == this.region.height - 1 || !this.mask.isSet(x, y + 1)) {
                                x0 = p0.x + x * this.plate.getCharWidth() + 1;
                                y0 = p0.y + (y + 1) * this.plate.getCharHeight() + 1;
                                x1 = x0 + this.plate.getCharWidth() - 1;
                                y1 = y0;
                                g.drawLine(x0, y0, x1, y1);
                            }
                            if (x != this.region.width - 1 && this.mask.isSet(x + 1, y)) continue;
                            x0 = p0.x + (x + 1) * this.plate.getCharWidth() + 1;
                            y0 = p0.y + y * this.plate.getCharHeight() + 1;
                            x1 = x0;
                            y1 = y0 + this.plate.getCharHeight() - 1;
                            g.drawLine(x0, y0, x1, y1);
                        }
                    }
                }
            }
        }
    }

    public final void paint(Graphics g, ColorScheme colorScheme) {
        int yy;
        int xx;
        int height;
        int width;
        if (this.region == null || this.content == null) {
            return;
        }
        CharacterMetrics characterMetrics = this.plate.getCharacterMetrics();
        int charWidth = characterMetrics.getWidth();
        int charHeight = characterMetrics.getHeight();
        int charAscent = characterMetrics.getAscent();
        Point p0 = this.plate.getScreenPointFor(this.region.x, this.region.y);
        int w = this.region.width * charWidth;
        int h = this.region.height * charHeight;
        if (this.layer == 3) {
            int y;
            int x;
            width = this.content.getWidth();
            height = this.content.getHeight();
            int plateWidth = this.plate.getDocumentWidth();
            int plateHeight = this.plate.getDocumentHeight();
            if (this.d3View) {
                g.setColor(colorScheme.getColorSelectionBackground());
            } else {
                g.setColor(colorScheme.getColorPlateBackground());
            }
            for (x = 0; x < width; ++x) {
                for (y = 0; y < height; ++y) {
                    int ix = this.region.x + x;
                    int iy = this.region.y + y;
                    if (ix >= 0 && ix < plateWidth && iy >= 0 && iy < plateHeight && this.content.get(x, y) == ' ') continue;
                    g.fillRect(p0.x + x * charWidth, p0.y + y * charHeight, charWidth + 1, charHeight + 1);
                }
            }
            if (this.d3View) {
                g.setColor(colorScheme.getColorSelectionText());
            } else {
                g.setColor(colorScheme.getColorText());
            }
            for (x = 0; x < width; ++x) {
                for (y = 0; y < height; ++y) {
                    char ch = this.content.get(x, y);
                    if (ch == ' ') continue;
                    int ix = this.region.x + x;
                    int iy = this.region.y + y;
                    if (ix >= 0 && ix < plateWidth && iy >= 0 && iy < plateHeight && this.plate.getChar(ix, iy) == ch) continue;
                    xx = p0.x + x * charWidth;
                    yy = p0.y + y * charHeight;
                    g.drawString(String.valueOf(ch), xx, yy + charAscent);
                }
            }
        } else if (this.layer == 2) {
            width = this.content.getWidth();
            height = this.content.getHeight();
            if (this.d3View) {
                g.setColor(colorScheme.getColorSelectionBackground());
            } else {
                g.setColor(colorScheme.getColorPlateBackground());
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (this.content.get(x, y) <= ' ') continue;
                    g.fillRect(p0.x + x * charWidth, p0.y + y * charHeight, charWidth + 1, charHeight + 1);
                }
            }
            if (this.d3View) {
                Color shade = colorScheme.getColorPlateBackground().darker();
                Color light = colorScheme.getColorPlateBackground().brighter();
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (this.content.get(x, y) <= ' ') continue;
                        xx = p0.x + x * charWidth;
                        yy = p0.y + y * charHeight;
                        if (x >= width - 1 || this.content.get(x + 1, y) == ' ') {
                            g.setColor(shade);
                            g.drawLine(xx + charWidth, yy + 1, xx + charWidth, yy + charHeight);
                        }
                        if (y >= height - 1 || this.content.get(x, y + 1) == ' ') {
                            g.setColor(shade);
                            g.drawLine(xx + 1, yy + charHeight, xx + charWidth, yy + charHeight);
                        }
                        if (x == 0 || this.content.get(x - 1, y) == ' ') {
                            g.setColor(light);
                            g.drawLine(xx, yy + 1, xx, yy + charHeight);
                        }
                        if (y != 0 && this.content.get(x, y - 1) != ' ') continue;
                        g.setColor(light);
                        g.drawLine(xx, yy, xx + charWidth, yy);
                    }
                }
            }
            if (this.d3View) {
                g.setColor(colorScheme.getColorSelectionText());
            } else {
                g.setColor(colorScheme.getColorText());
            }
            for (int y = 0; y < height; ++y) {
                g.drawString(String.valueOf(this.content.getContent()[y]), p0.x, p0.y + y * charHeight + charAscent);
            }
        } else if (this.layer == 1) {
            int width2 = this.content.getWidth();
            int height2 = this.content.getHeight();
            if (this.d3View) {
                g.setColor(colorScheme.getColorSelectionBackground());
            } else {
                g.setColor(colorScheme.getColorPlateBackground());
            }
            if (this.mask == null) {
                g.fillRect(p0.x, p0.y, w, h);
            } else {
                for (int x = 0; x < width2; ++x) {
                    for (int y = 0; y < height2; ++y) {
                        if (!this.mask.isSet(x, y)) continue;
                        g.fillRect(p0.x + x * charWidth, p0.y + y * charHeight, charWidth + 1, charHeight + 1);
                    }
                }
            }
            if (this.d3View) {
                g.setColor(colorScheme.getColorSelectionText());
            } else {
                g.setColor(colorScheme.getColorText());
            }
            for (int y = 0; y < height2; ++y) {
                g.drawString(String.valueOf(this.content.getContent()[y]), p0.x, p0.y + y * charHeight + charAscent);
            }
        } else if (this.layer == 0) {
            width = this.content.getWidth();
            height = this.content.getHeight();
            int plateWidth = this.plate.getDocumentWidth();
            int plateHeight = this.plate.getDocumentHeight();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int ix = this.region.x + x;
                    int iy = this.region.y + y;
                    if (ix >= 0 && ix < plateWidth && iy >= 0 && iy < plateHeight && this.plate.getChar(ix, iy) != ' ') continue;
                    xx = p0.x + x * charWidth;
                    yy = p0.y + y * charHeight;
                    if (this.mask == null || this.mask.isSet(x, y)) {
                        if (this.d3View) {
                            g.setColor(colorScheme.getColorSelectionBackground());
                        } else {
                            g.setColor(colorScheme.getColorPlateBackground());
                        }
                        g.fillRect(xx, yy, charWidth + 1, charHeight + 1);
                    }
                    if (this.content.get(x, y) <= ' ') continue;
                    if (this.d3View) {
                        g.setColor(colorScheme.getColorSelectionText());
                    } else {
                        g.setColor(colorScheme.getColorText());
                    }
                    g.drawString(String.valueOf(this.content.get(x, y)), xx, yy + charAscent);
                }
            }
            if (this.d3View) {
                Color shade = colorScheme.getColorPlateBackground().darker();
                Color light = colorScheme.getColorPlateBackground().brighter();
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int ix = this.region.x + x;
                        int iy = this.region.y + y;
                        if (ix < 0 || ix >= plateWidth || iy < 0 || iy >= plateHeight || this.mask != null && !this.mask.isSet(x, y) || this.plate.getChar(ix, iy) == ' ') continue;
                        xx = p0.x + x * charWidth;
                        yy = p0.y + y * charHeight;
                        if (ix + 1 >= plateWidth || this.plate.getChar(ix + 1, iy) == ' ') {
                            g.setColor(shade);
                            g.drawLine(xx + charWidth, yy + 1, xx + charWidth, yy + charHeight);
                        }
                        if (iy + 1 >= plateHeight || this.plate.getChar(ix, iy + 1) == ' ') {
                            g.setColor(shade);
                            g.drawLine(xx + 1, yy + charHeight, xx + charWidth, yy + charHeight);
                        }
                        if (ix == 0 || this.plate.getChar(ix - 1, iy) == ' ') {
                            g.setColor(light);
                            g.drawLine(xx, yy, xx, yy + charHeight);
                        }
                        if (iy != 0 && this.plate.getChar(ix, iy - 1) != ' ') continue;
                        g.setColor(light);
                        g.drawLine(xx, yy, xx + charWidth, yy);
                    }
                }
            }
        }
        if (this.isTextbox()) {
            g.setColor(colorScheme.getColorToolRegion());
            int x0 = p0.x + 1;
            int y0 = p0.y + 1;
            int x1 = p0.x + w;
            int y1 = p0.y + h;
            g.drawRect(x0, y0, w - 2, h - 2);
            g.fillRect(x0, y0, 5, 5);
            g.fillRect(x0, y1 - 5, 5, 5);
            g.fillRect(x1 - 5, y0, 5, 5);
            g.fillRect(x1 - 5, y1 - 5, 5, 5);
            g.fillRect((x0 + x1 - 5) / 2, y0, 5, 5);
            g.fillRect((x0 + x1 - 5) / 2, y1 - 5, 5, 5);
            g.fillRect(x0, (y0 + y1 - 5) / 2, 5, 5);
            g.fillRect(x1 - 5, (y0 + y1 - 5) / 2, 5, 5);
        }
    }

    public final void setLayer(int layer) {
        this.layer = layer;
    }

    public final void set3dView(boolean d3View) {
        this.d3View = d3View;
    }

    public final synchronized void resizeTextboxE(int dx) {
        if (dx == 0 || this.region.width + dx < 3) {
            return;
        }
        int w = this.region.width + dx;
        int h = this.region.height;
        CharacterPlate newContent = new CharacterPlate(w, h);
        if (dx > 0) {
            int y;
            int x;
            for (x = 0; x < w - dx - 1; ++x) {
                for (y = 0; y < h; ++y) {
                    newContent.setForce(x, y, this.content.get(x, y));
                }
            }
            for (int y2 = 0; y2 < h; ++y2) {
                newContent.setForce(w - 1, y2, this.content.get(w - dx - 1, y2));
            }
            for (x = w - dx - 1; x < w - 1; ++x) {
                for (y = 1; y < h - 1; ++y) {
                    char chOld = this.getOriginalCharAt(x, y);
                    if (chOld == '\u0000') {
                        chOld = ' ';
                    }
                    newContent.setForce(x, y, chOld);
                }
                newContent.setForce(x, 0, this.content.get(w - dx - 2, 0));
                newContent.setForce(x, h - 1, this.content.get(w - dx - 2, h - 1));
            }
        } else {
            for (int x = 0; x < w - 1; ++x) {
                for (int y = 0; y < h; ++y) {
                    newContent.setForce(x, y, this.content.get(x, y));
                }
            }
            for (int y = 0; y < h; ++y) {
                newContent.setForce(w - 1, y, this.content.get(w - dx - 1, y));
            }
        }
        this.content = newContent;
        this.region.width = w;
        this.plate.repaint();
    }

    public final synchronized void resizeTextboxW(int dx) {
        if (dx == 0 || this.region.width - dx < 3) {
            return;
        }
        int w = this.region.width - dx;
        int h = this.region.height;
        CharacterPlate newContent = new CharacterPlate(w, h);
        if (dx > 0) {
            for (int y = 0; y < h; ++y) {
                newContent.setForce(0, y, this.content.get(0, y));
            }
            for (int x = 1; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    newContent.setForce(x, y, this.content.get(x + dx, y));
                }
            }
        } else {
            int y;
            int x;
            for (int y2 = 0; y2 < h; ++y2) {
                newContent.setForce(0, y2, this.content.get(0, y2));
            }
            for (x = 1; x < -dx + 1; ++x) {
                for (y = 1; y < h - 1; ++y) {
                    char chOld = this.getOriginalCharAt(x + dx, y);
                    if (chOld == '\u0000') {
                        chOld = ' ';
                    }
                    newContent.setForce(x, y, chOld);
                }
                newContent.setForce(x, 0, this.content.get(1, 0));
                newContent.setForce(x, h - 1, this.content.get(1, h - 1));
            }
            for (x = -dx + 1; x < w; ++x) {
                for (y = 0; y < h; ++y) {
                    newContent.setForce(x, y, this.content.get(x + dx, y));
                }
            }
        }
        this.originalContentX += dx;
        this.content = newContent;
        this.region.width = w;
        this.region.x += dx;
        this.plate.repaint();
    }

    public final synchronized void resizeTextboxN(int dy) {
        if (dy == 0 || this.region.height - dy < 3) {
            return;
        }
        int w = this.region.width;
        int h = this.region.height - dy;
        CharacterPlate newContent = new CharacterPlate(w, h);
        if (dy > 0) {
            for (int x = 0; x < w; ++x) {
                newContent.setForce(x, 0, this.content.get(x, 0));
            }
            for (int y = 1; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    newContent.setForce(x, y, this.content.get(x, y + dy));
                }
            }
        } else {
            int x;
            int y;
            for (int x2 = 0; x2 < w; ++x2) {
                newContent.setForce(x2, 0, this.content.get(x2, 0));
            }
            for (y = 1; y < -dy + 1; ++y) {
                for (x = 1; x < w - 1; ++x) {
                    char chOld = this.getOriginalCharAt(x, y + dy);
                    if (chOld == '\u0000') {
                        chOld = ' ';
                    }
                    newContent.setForce(x, y, chOld);
                }
                newContent.setForce(0, y, this.content.get(0, 1));
                newContent.setForce(w - 1, y, this.content.get(w - 1, 1));
            }
            for (y = -dy + 1; y < h; ++y) {
                for (x = 0; x < w; ++x) {
                    newContent.setForce(x, y, this.content.get(x, y + dy));
                }
            }
        }
        this.originalContentY += dy;
        this.content = newContent;
        this.region.height = h;
        this.region.y += dy;
        this.plate.repaint();
    }

    public final synchronized void resizeTextboxS(int dy) {
        if (dy == 0 || this.region.height + dy < 3) {
            return;
        }
        int w = this.region.width;
        int h = this.region.height + dy;
        CharacterPlate newContent = new CharacterPlate(w, h);
        if (dy > 0) {
            int x;
            int y;
            for (y = 0; y < h - dy - 1; ++y) {
                for (x = 0; x < w; ++x) {
                    newContent.setForce(x, y, this.content.get(x, y));
                }
            }
            for (int x2 = 0; x2 < w; ++x2) {
                newContent.setForce(x2, h - 1, this.content.get(x2, h - dy - 1));
            }
            for (y = h - dy - 1; y < h - 1; ++y) {
                for (x = 1; x < w - 1; ++x) {
                    char chOld = this.getOriginalCharAt(x, y);
                    if (chOld == '\u0000') {
                        chOld = ' ';
                    }
                    newContent.setForce(x, y, chOld);
                }
                newContent.setForce(0, y, this.content.get(0, h - dy - 2));
                newContent.setForce(w - 1, y, this.content.get(w - 1, h - dy - 2));
            }
        } else {
            for (int y = 0; y < h - 1; ++y) {
                for (int x = 0; x < w; ++x) {
                    newContent.setForce(x, y, this.content.get(x, y));
                }
            }
            for (int x = 0; x < w; ++x) {
                newContent.setForce(x, h - 1, this.content.get(x, h - dy - 1));
            }
        }
        this.content = newContent;
        this.region.height = h;
        this.plate.repaint();
    }

    private char getOriginalCharAt(int x, int y) {
        if ((x += this.originalContentX) < 1 || (y += this.originalContentY) < 1 || x >= this.originalContent.getWidth() - 1 || y >= this.originalContent.getHeight() - 1) {
            return '\u0000';
        }
        return this.originalContent.get(x, y);
    }
}

