/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CompressedDocumentState;
import de.jave.jave.DocumentListener;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Selection;
import de.jave.jave.preferences.ColorScheme;
import de.jave.lib.CharacterPlate;
import de.jave.undo.UndoManager;
import de.jave.util.RecentFileList;
import de.jave.util.RelativeTimeClock;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import net.disy.commons.core.io.IOUtilities;

public final class PlateDocument {
    private boolean modified;
    private UndoManager undoManager;
    private RelativeTimeClock clock;
    private File file;
    private CharacterPlate content;
    private Point scrollOrigin;
    private Selection selection;
    private Point cursorLocation;
    private ColorScheme colorScheme;
    private Vector documentListeners;

    protected PlateDocument(int width, int height) {
        this(new Dimension(width, height));
    }

    public PlateDocument(Dimension size) {
        this.content = new CharacterPlate(size);
        this.selection = new Selection();
        this.cursorLocation = new Point(0, 0);
    }

    public final void setFile(File file) {
        this.file = file;
    }

    public final CharacterPlate getContent() {
        return this.content;
    }

    public final void setContent(CharacterPlate cp) {
        this.content = cp;
    }

    public final Point getCursorLocation() {
        return this.cursorLocation;
    }

    public final void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public final ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public final synchronized void setDocumentState(CompressedDocumentState state) {
        this.content.setContent(state.getContent());
        this.selection.set(state.getSelectionLocation(), state.getSelectionContent(), state.getSelectionMask());
        this.scrollOrigin = state.getScrollOrigin();
        this.colorScheme = state.getColorScheme();
    }

    public final void setRelativeTimeClock(RelativeTimeClock clock) {
        this.clock = clock;
    }

    public final RelativeTimeClock getRelativeTimeClock() {
        return this.clock;
    }

    public final boolean isEmpty() {
        return this.content == null || this.content.isEmpty();
    }

    public final Selection getSelection() {
        return this.selection;
    }

    public final Dimension getSize() {
        return this.content.getSize();
    }

    public final Point getScrollOrigin() {
        if (this.scrollOrigin != null) {
            return this.scrollOrigin;
        }
        return new Point(0, 0);
    }

    public static final PlateDocument createNew(Dimension size) {
        PlateDocument doc = new PlateDocument(size);
        new PlateDocument(size).modified = false;
        doc.colorScheme = JaveGlobalRessources.getColorSchemeModel().getColorScheme();
        return doc;
    }

    public static final PlateDocument load(File file) throws IOException {
        PlateDocument doc = new PlateDocument(1, 1);
        new PlateDocument(1, 1).file = file;
        doc.modified = false;
        doc.colorScheme = JaveGlobalRessources.getColorSchemeModel().getColorScheme();
        String[] lines = PlateDocument.readAsciiFileLines(file);
        doc.content = new CharacterPlate(lines);
        return doc;
    }

    public static final String[] readAsciiFileLines(File file) throws IOException {
        String[] lineStrings;
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new FileReader(file));
            ArrayList<String> lines = new ArrayList<String>();
            while ((s = reader.readLine()) != null) {
                lines.add(s);
            }
            lineStrings = lines.toArray(new String[lines.size()]);
        }
        catch (IOException iOException) {
            try {
                IOException e = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                IOUtilities.close(reader);
                throw throwable;
            }
        }
        IOUtilities.close(reader);
        return lineStrings;
    }

    public final void save(RecentFileList recentFileList) throws IOException {
        if (this.file == null) {
            throw new RuntimeException("No name specified  for Document.save()!");
        }
        this.saveInternal(this.file, recentFileList);
        this.setModified(false);
    }

    protected final void saveInternal(File file, RecentFileList recentFileList) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            String[] lines = this.content.toStringArray();
            for (int i = 0; i < lines.length - 1; ++i) {
                bw.write(lines[i]);
                bw.newLine();
            }
            bw.write(lines[lines.length - 1]);
            bw.close();
            recentFileList.add(file);
        }
        catch (IOException iOException) {
            try {
                IOException e = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                if (bw != null) {
                    bw.close();
                }
                throw throwable;
            }
        }
        bw.close();
        return;
    }

    public final boolean isModified() {
        return this.modified;
    }

    public final void setModified(boolean what) {
        this.modified = what;
    }

    public final boolean hasFile() {
        return this.file != null;
    }

    public final boolean isLogging() {
        return this.undoManager.isLogging();
    }

    public final String getLogFileName() {
        String result = this.undoManager.getLogFileName();
        if (result == null) {
            return "";
        }
        return result;
    }

    public final File getFile() {
        if (!this.hasFile()) {
            return null;
        }
        return this.file;
    }

    public final synchronized void addDocumentListener(DocumentListener l) {
        if (this.documentListeners == null) {
            this.documentListeners = new Vector(2, 2);
        }
        this.documentListeners.addElement(l);
    }

    public final void documentClosing() {
        if (this.documentListeners != null) {
            for (int i = 0; i < this.documentListeners.size(); ++i) {
                ((DocumentListener)this.documentListeners.elementAt(i)).documentClosing();
            }
        }
    }

    public final void documentHiding() {
        if (this.documentListeners != null) {
            for (int i = 0; i < this.documentListeners.size(); ++i) {
                ((DocumentListener)this.documentListeners.elementAt(i)).documentHiding();
            }
        }
    }

    public final void documentShowing() {
        if (this.documentListeners != null) {
            for (int i = 0; i < this.documentListeners.size(); ++i) {
                ((DocumentListener)this.documentListeners.elementAt(i)).documentShowing();
            }
        }
    }

    public final void documentChanged() {
        if (this.documentListeners != null) {
            for (int i = 0; i < this.documentListeners.size(); ++i) {
                ((DocumentListener)this.documentListeners.elementAt(i)).documentChanged();
            }
        }
    }

    public final UndoManager getUndoManager() {
        return this.undoManager;
    }

    public final void setUndoManager(UndoManager manager) {
        this.undoManager = manager;
    }
}

