/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Jave;
import de.jave.jave.Tool;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.plate.JaveMainPanel;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public final class PanTool
extends Tool {
    protected int panDX = 0;
    protected int panDY = 0;
    protected Point location1;

    public PanTool(JaveMainPanel plate, Jave asciiPainter) {
        super(plate, asciiPainter);
    }

    public final String getName() {
        return "Pan";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/pan.gif");
    }

    public final void takeToHand() {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        this.location1 = location;
        this.panDX = 0;
        this.panDY = 0;
        this.showStatus("[0,0]");
    }

    public final void mouseReleased(Point point, Point location, MouseEvent evt) {
        this.panDX = 0;
        this.panDY = 0;
        this.showStatus("");
        this.getPlate().saveCurrentState("pan");
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (location == null || this.location1 == null) {
            this.showStatus("");
            return;
        }
        int dx = location.x - this.location1.x;
        int dy = location.y - this.location1.y;
        StringBuffer s = new StringBuffer("[");
        if (dx > 0) {
            s.append('+');
        }
        s.append(dx);
        s.append(',');
        if (dy > 0) {
            s.append('+');
        }
        s.append(dy);
        s.append(']');
        this.showStatus(s.toString());
        this.getPlate().pan(dx - this.panDX, dy - this.panDY);
        this.panDX = dx;
        this.panDY = dy;
    }
}

