/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.DocumentListener;
import de.jave.jave.Jave;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.preferences.ColorScheme;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.SwingUtilities;

public abstract class JaveGame
implements KeyListener,
DocumentListener {
    protected Jave jave;
    protected CharacterPlate plate;
    protected PlateDocument document;
    protected boolean enabled;
    private Plate javePlate;

    public JaveGame(Jave jave) {
        this.jave = jave;
        this.enabled = true;
        this.plate = new CharacterPlate(this.getPreferredSize());
        this.javePlate = jave.pasteAsNewGameDocument(this.plate, this.getTitle());
        this.document = this.javePlate.getDocument();
        this.document.addDocumentListener(this);
        this.document.setModified(false);
        jave.performSetColorScheme(this.getPreferredColorScheme());
        this.javePlate.addKeyListener(this);
        jave.switchToSelectonTool();
        this.requestFocus();
    }

    protected abstract Dimension getPreferredSize();

    protected abstract String getTitle();

    protected abstract ColorScheme getPreferredColorScheme();

    protected abstract void keyPressed(KeyEvent var1, int var2, char var3);

    protected abstract void keyTyped(KeyEvent var1, int var2, char var3);

    public final void quit() {
        this.javePlate.removeKeyListener(this);
        this.document.setModified(false);
        this.jave.doClose(this.jave.getFrame());
    }

    protected final void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                JaveGame.this.javePlate.requestFocus();
            }
        });
    }

    protected final void repaint() {
        this.javePlate.repaint();
    }

    public final void keyReleased(KeyEvent evt) {
    }

    public final void keyPressed(KeyEvent evt) {
        if (this.enabled) {
            this.keyPressed(evt, evt.getKeyCode(), evt.getKeyChar());
        }
    }

    public final void keyTyped(KeyEvent evt) {
        if (this.enabled) {
            this.keyTyped(evt, evt.getKeyCode(), evt.getKeyChar());
        }
    }

    public final void documentClosing() {
        this.javePlate.removeKeyListener(this);
        this.document.setModified(false);
    }

    public final void documentHiding() {
        this.enabled = false;
    }

    public final void documentShowing() {
        this.requestFocus();
        this.jave.switchToSelectonTool();
        this.enabled = true;
    }

    public final void documentChanged() {
    }
}

