/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.layout.Gap;
import de.jave.jave.DialogTool;
import de.jave.jave.Jave;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class FractalTool
extends DialogTool
implements ItemListener {
    private static final String[] RESOLUTION_STR = new String[]{"Lowest", "Low (Dots)", "Normal 2by2 (J7L_\"'`()8)", "Higher 3by2", "High"};
    private JTextField dfX;
    private JTextField dfY;
    private JTextField dfXSpan;
    private JCheckBox cbNegative;
    private JComboBox chResolution;
    private JComboBox chDespecle;
    private SpinnerNumberModel depthModel;

    public FractalTool(Jave asciiPainter, JaveApplicationPreferences preferences) {
        super(asciiPainter, preferences);
        this.convert();
    }

    protected final ColorScheme getPreferredColorScheme() {
        return ColorScheme.BLACK_ON_WHITE;
    }

    protected final String getToolTitle() {
        return "Fractal Tool";
    }

    public final String getToolActionName() {
        return "fractal";
    }

    public final Component getOptionsComponent() {
        AbstractDocumentChangeListener documentListener = new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                FractalTool.this.convert();
            }
        };
        JPanel pMandel = new JPanel();
        pMandel.setBorder(new TitledBorder("Mandelbrot Set"));
        pMandel.setLayout(new GridDialogLayout(2, false));
        pMandel.add((Component)new JLabel("X:"), GridDialogLayoutData.RIGHT);
        this.dfX = new JTextField(String.valueOf(-0.3), 10);
        this.dfX.getDocument().addDocumentListener(documentListener);
        pMandel.add(this.dfX);
        pMandel.add((Component)new JLabel("Y:"), GridDialogLayoutData.RIGHT);
        this.dfY = new JTextField(String.valueOf(0.0), 10);
        this.dfY.getDocument().addDocumentListener(documentListener);
        pMandel.add(this.dfY);
        pMandel.add((Component)new JLabel("X span:"), GridDialogLayoutData.RIGHT);
        this.dfXSpan = new JTextField(String.valueOf(2.0), 10);
        this.dfXSpan.getDocument().addDocumentListener(documentListener);
        pMandel.add(this.dfXSpan);
        JButton bIn = new JButton(new SmartAction("In"){

            protected final void execute(Component parentComponent) {
                try {
                    double xSpan = Double.valueOf(FractalTool.this.dfXSpan.getText());
                    FractalTool.this.dfXSpan.setText(String.valueOf(xSpan *= 0.75));
                    FractalTool.this.convert();
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfXSpan.setForeground(Color.red);
                    return;
                }
            }
        });
        JButton bOut = new JButton(new SmartAction("Out"){

            protected final void execute(Component parentComponent) {
                try {
                    double xSpan = Double.valueOf(FractalTool.this.dfXSpan.getText());
                    FractalTool.this.dfXSpan.setText(String.valueOf(xSpan *= 1.3333333333333333));
                    FractalTool.this.convert();
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfXSpan.setForeground(Color.red);
                    return;
                }
            }
        });
        JButton bLeft = new JButton(new SmartAction("Left"){

            protected final void execute(Component parentComponent) {
                double xSpan = 0.0;
                double xCenter = 0.0;
                try {
                    xSpan = Double.valueOf(FractalTool.this.dfXSpan.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfXSpan.setForeground(Color.red);
                    return;
                }
                try {
                    xCenter = Double.valueOf(FractalTool.this.dfX.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfX.setForeground(Color.red);
                    return;
                }
                FractalTool.this.dfX.setText(String.valueOf(xCenter -= xSpan / 5.0));
                FractalTool.this.convert();
            }
        });
        JButton bRight = new JButton(new SmartAction("Right"){

            protected final void execute(Component parentComponent) {
                double xSpan = 0.0;
                double xCenter = 0.0;
                try {
                    xSpan = Double.valueOf(FractalTool.this.dfXSpan.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfXSpan.setForeground(Color.red);
                    return;
                }
                try {
                    xCenter = Double.valueOf(FractalTool.this.dfX.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfX.setForeground(Color.red);
                    return;
                }
                FractalTool.this.dfX.setText(String.valueOf(xCenter += xSpan / 5.0));
                FractalTool.this.convert();
            }
        });
        JButton bUp = new JButton(new SmartAction("Up"){

            protected final void execute(Component parentComponent) {
                double xSpan = 0.0;
                double yCenter = 0.0;
                try {
                    xSpan = Double.valueOf(FractalTool.this.dfXSpan.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfXSpan.setForeground(Color.red);
                    return;
                }
                try {
                    yCenter = Double.valueOf(FractalTool.this.dfY.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfY.setForeground(Color.red);
                    return;
                }
                double ySpan = xSpan / (double)FractalTool.this.plateWidth * (double)FractalTool.this.plateHeight * 1.5;
                FractalTool.this.dfY.setText(String.valueOf(yCenter -= ySpan / 5.0));
                FractalTool.this.convert();
            }
        });
        JButton bDown = new JButton(new SmartAction("Down"){

            protected final void execute(Component parentComponent) {
                double xSpan = 0.0;
                double yCenter = 0.0;
                try {
                    xSpan = Double.valueOf(FractalTool.this.dfXSpan.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfXSpan.setForeground(Color.red);
                    return;
                }
                try {
                    yCenter = Double.valueOf(FractalTool.this.dfY.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    FractalTool.this.dfY.setForeground(Color.red);
                    return;
                }
                double ySpan = xSpan / (double)FractalTool.this.plateWidth * (double)FractalTool.this.plateHeight * 1.5;
                FractalTool.this.dfY.setText(String.valueOf(yCenter += ySpan / 5.0));
                FractalTool.this.convert();
            }
        });
        JButton bReset = new JButton(new SmartAction("Reset"){

            protected final void execute(Component parentComponent) {
                FractalTool.this.dfX.setText(String.valueOf(-0.3));
                FractalTool.this.dfY.setText(String.valueOf(0.0));
                FractalTool.this.dfXSpan.setText(String.valueOf(2.0));
                FractalTool.this.convert();
            }
        });
        JPanel pNavigate = new JPanel();
        pNavigate.setBorder(new TitledBorder("Navigation"));
        pNavigate.setLayout(new GridLayout(0, 4, 2, 2));
        pNavigate.add(bIn);
        pNavigate.add(bOut);
        pNavigate.add(new Gap());
        pNavigate.add(new Gap());
        pNavigate.add(bLeft);
        pNavigate.add(bRight);
        pNavigate.add(bUp);
        pNavigate.add(bDown);
        pNavigate.add(bReset);
        this.depthModel = new SpinnerNumberModel(1000, 2, 50000, 1);
        this.depthModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                FractalTool.this.convert();
            }
        });
        JSpinner ifDepth = new JSpinner(this.depthModel);
        JPanel p1 = new JPanel(new FlowLayout());
        p1.add(new JLabel("Depth:"));
        p1.add(ifDepth);
        this.chResolution = new JComboBox<String>(RESOLUTION_STR);
        this.chResolution.setSelectedIndex(4);
        this.chResolution.addItemListener(this);
        p1.add(new JLabel("Resolution:"));
        p1.add(this.chResolution);
        JPanel p2 = new JPanel(new FlowLayout());
        this.cbNegative = new JCheckBox("negative", false);
        this.cbNegative.addItemListener(this);
        p2.add(this.cbNegative);
        this.chDespecle = new JComboBox<String>(new String[]{"none", "0", "1", "2", "3", "4", "5", "6", "7"});
        this.chDespecle.addItemListener(this);
        p2.add(new JLabel("Despecle:"));
        p2.add(this.chDespecle);
        JPanel pRender = new JPanel();
        pRender.setBorder(new TitledBorder("Rendering"));
        pRender.setLayout(new GridDialogLayout(1, false));
        pRender.add(p1);
        pRender.add(p2);
        JPanel p = new JPanel(new GridDialogLayout(2, false));
        p.add(pMandel);
        p.add(pNavigate);
        GridDialogLayoutData data = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        data.setHorizontalSpan(2);
        p.add((Component)pRender, data);
        return p;
    }

    private void convert() {
        if (this.depthModel == null || this.chResolution == null) {
            return;
        }
        int iter = this.depthModel.getNumber().intValue();
        boolean negative = this.cbNegative.isSelected();
        int resolution = this.chResolution.getSelectedIndex();
        int despecle = this.chDespecle.getSelectedIndex();
        if (this.markPlate == null) {
            this.markPlate = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        }
        this.markPlate.clear();
        double xCenter = 0.0;
        double yCenter = 0.0;
        double xSpan = 0.0;
        try {
            xCenter = Double.valueOf(this.dfX.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.dfX.setForeground(Color.red);
            return;
        }
        this.dfX.setForeground(Color.black);
        try {
            yCenter = Double.valueOf(this.dfY.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.dfY.setForeground(Color.red);
            return;
        }
        this.dfY.setForeground(Color.black);
        try {
            xSpan = Double.valueOf(this.dfXSpan.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.dfXSpan.setForeground(Color.red);
            return;
        }
        this.dfXSpan.setForeground(Color.black);
        FractalTool.drawMandelbrot(this.markPlate, this.plateWidth, this.plateHeight, xCenter, yCenter, xSpan, iter, negative, resolution, despecle);
        this.characterPlate.clear();
        this.markPlate.convert();
        this.markPlate.pasteResultInto(this.characterPlate);
        this.repaintPlate();
    }

    private static void drawMandelbrot(PixelPlate plate, int width, int height, double xCenter, double yCenter, double xSpan, int iter, boolean negative, int resolution, int despecle) {
        double ySpan = xSpan / (double)width * (double)height * 2.0;
        double xMin = xCenter - xSpan / 2.0;
        double yMin = yCenter - ySpan / 2.0;
        int w = width;
        int h = height;
        switch (resolution) {
            case 0: {
                plate.setMode(PixelPlateMode.CHAR);
                plate.setCharacter('8');
                break;
            }
            case 1: {
                plate.setMode(PixelPlateMode.DOT);
                w *= 1;
                h *= 2;
                break;
            }
            case 2: {
                plate.setMode(PixelPlateMode.TWO_BY_TWO);
                w *= 2;
                h *= 2;
                break;
            }
            case 3: {
                plate.setMode(PixelPlateMode.THREE_BY_TWO);
                w *= 2;
                h *= 3;
                break;
            }
            case 4: {
                plate.setMode(PixelPlateMode.THICK_THIN);
                w *= 3;
                h *= 4;
            }
        }
        iter += 3 - iter % 3;
        double dx = xSpan / (double)w;
        double dy = ySpan / (double)h;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (FractalTool.getMandelbrot(2.0 * (xMin + (double)x * dx), 2.0 * (yMin + (double)y * dy), iter) == 1 == negative) continue;
                plate.set(x, y);
            }
        }
        plate.removeNoise(despecle - 1);
    }

    public final void itemStateChanged(ItemEvent evt) {
        this.convert();
    }

    private static int getMandelbrot(double real, double imag, int iterations) {
        int iters;
        double r0 = real;
        double i0 = imag;
        for (iters = 1; iters < iterations && real * real + imag * imag < 4.0; ++iters) {
            double tmp = 2.0 * real * imag + i0;
            real = real * real - imag * imag + r0;
            imag = tmp;
        }
        if (iters % 3 == 0) {
            return 1;
        }
        return 0;
    }
}

