/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.PlateDocument;
import de.jave.util.RecentFileList;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.disy.commons.core.io.FileModel;

public final class DocumentManager {
    private final List documents = new ArrayList();
    private int currentDocumentIndex;
    private final FileModel currentDirectoryModel;

    public DocumentManager(FileModel currentDirectoryModel) {
        this.currentDirectoryModel = currentDirectoryModel;
        this.currentDocumentIndex = -1;
    }

    public final synchronized void setCurrentDocument(int index) {
        this.currentDocumentIndex = index;
    }

    public final int getIndexOf(PlateDocument doc) {
        return this.documents.indexOf(doc);
    }

    public final int getSize() {
        return this.documents.size();
    }

    public final synchronized PlateDocument createNew(Dimension size) {
        PlateDocument doc = PlateDocument.createNew(size);
        this.documents.add(doc);
        this.currentDocumentIndex = this.documents.size() - 1;
        return doc;
    }

    public final synchronized PlateDocument load(File file, RecentFileList recentFileList) throws IOException {
        PlateDocument doc = null;
        try {
            doc = PlateDocument.load(file);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError e = outOfMemoryError;
            throw outOfMemoryError;
        }
        recentFileList.add(file);
        this.getCurrentDirectoryModel().setFile(file.getParentFile());
        this.documents.add(doc);
        this.currentDocumentIndex = this.documents.size() - 1;
        return doc;
    }

    public final boolean isAlreadyOpen(File file) {
        for (int i = 0; i < this.documents.size(); ++i) {
            PlateDocument document = this.getDocument(i);
            if (!file.equals(document.getFile())) continue;
            return true;
        }
        return false;
    }

    public final synchronized void closeCurrentDocument() {
        this.closeDocument(this.currentDocumentIndex);
    }

    public final synchronized void closeDocument(int index) {
        PlateDocument doc = (PlateDocument)this.documents.get(index);
        doc.documentClosing();
        this.documents.remove(index);
        if (index <= this.currentDocumentIndex) {
            --this.currentDocumentIndex;
            if (this.currentDocumentIndex < 0 && this.getSize() > 0) {
                this.currentDocumentIndex = 0;
            }
        }
    }

    public final int getCurrentDocumentIndex() {
        return this.currentDocumentIndex;
    }

    public final PlateDocument getCurrentDocument() {
        if (this.currentDocumentIndex < 0) {
            return null;
        }
        return this.getDocument(this.currentDocumentIndex);
    }

    public final PlateDocument getDocument(int i) {
        return (PlateDocument)this.documents.get(i);
    }

    public final synchronized String[] getDocumentStatusList() {
        String[] result = new String[this.documents.size() * 2];
        for (int i = 0; i < this.documents.size(); ++i) {
            File documentFile = this.getDocument(i).getFile();
            result[i * 2] = documentFile == null ? "" : documentFile.getAbsolutePath();
            result[i * 2 + 1] = this.getDocument(i).getLogFileName();
        }
        return result;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DocumentManager(" + this.getSize() + "," + this.getCurrentDirectoryModel().getFile() + "){\n");
        for (int i = 0; i < this.getSize(); ++i) {
            sb.append("  " + this.documents.get(i) + "\n");
        }
        sb.append("};\n");
        return sb.toString();
    }

    public final FileModel getCurrentDirectoryModel() {
        return this.currentDirectoryModel;
    }
}

