/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.ArcAgorithm;
import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.Point2d;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public final class ArcToolGeneric
extends GenericTool {
    protected Point point1;
    protected Point point2;
    protected Point point3;
    protected Point movingPoint;

    public ArcToolGeneric(JaveMainPanel plate, Jave asciiPainter) {
        super(plate, asciiPainter);
    }

    public final String getName() {
        return "Arc Generic";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/arc_generic.gif");
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        if (this.point1 == null) {
            this.movingPoint = this.point1 = point;
            this.point2 = null;
            this.point3 = null;
        } else if (this.point2 == null) {
            this.movingPoint = this.point2 = point;
            this.point3 = null;
        } else if (this.point3 == null) {
            this.movingPoint = this.point3 = point;
            this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
            pixelPlateOptionsPanel.configure(this.markPlate);
            this.markPlate.setCharacter(this.getMouseChar());
        }
        this.repaintCursor();
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.movingPoint == null) {
            return;
        }
        this.movingPoint.x = point.x;
        this.movingPoint.y = point.y;
        this.repaintCursor();
    }

    public final void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.point1 == null || this.point2 == null || this.point3 == null) {
            return;
        }
        this.movingPoint = null;
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
        if (this.markPlate != null) {
            this.setMixMode(this.isMix());
            this.markPlate.convert();
            this.markPlate.pasteResultInto(this.getPlate().getContent());
            this.saveCurrentState("draw arc");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    public final void keyPressed(int code, KeyEvent evt) {
        if (code == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.point3 = null;
            this.movingPoint = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    protected static final double getAngle(double dx, double dy) {
        if (dx == 0.0) {
            if (dy > 0.0) {
                return 270.0;
            }
            return 90.0;
        }
        double alpha = Math.atan(dy / dx);
        if (dx > 0.0) {
            return (360.0 - alpha * 180.0 / Math.PI) % 360.0;
        }
        return 180.0 - alpha * 180.0 / Math.PI;
    }

    public final void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        Rectangle clip;
        Point pp2;
        Point pp1;
        if (this.point1 == null) {
            return;
        }
        g.setColor(colorScheme.getColorToolHelping());
        g.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        g.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        if (this.point3 == null) {
            return;
        }
        Point2d center = ArcAgorithm.getCenter(this.point1, this.point2, this.point3);
        if (center == null) {
            int maxY;
            int minX = this.point1.x < this.point2.x ? this.point1.x : this.point2.x;
            int minY = this.point1.y < this.point2.y ? this.point1.y : this.point2.y;
            int maxX = this.point1.x > this.point2.x ? this.point1.x : this.point2.x;
            int n = maxY = this.point1.y > this.point2.y ? this.point1.y : this.point2.y;
            if (this.point3.x >= minX && this.point3.x <= maxX && this.point3.y >= minY && this.point3.y <= maxY) {
                g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
                this.markPlate.clear();
                Point2d p1 = this.getPlate().getRealLocationForScreenPoint(this.point1);
                Point2d p2 = this.getPlate().getRealLocationForScreenPoint(this.point2);
                this.markPlate.drawLine(p1, p2);
                this.markPlate.convert();
                PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
                return;
            }
            return;
        }
        double r = Math.sqrt(Math.pow((double)this.point1.x - center.x, 2.0) + Math.pow((double)this.point1.y - center.y, 2.0));
        int radius = (int)Math.round(r);
        double angle1 = ArcToolGeneric.getAngle((double)this.point1.x - center.x, (double)this.point1.y - center.y);
        double angle2 = ArcToolGeneric.getAngle((double)this.point2.x - center.x, (double)this.point2.y - center.y);
        double angle3 = ArcToolGeneric.getAngle((double)this.point3.x - center.x, (double)this.point3.y - center.y);
        double alpha = (angle2 - angle1) / 180.0 * Math.PI;
        double h = Math.abs(r * Math.cos(alpha / 2.0));
        if (r - h < 1.0) {
            int maxY;
            int minX = this.point1.x < this.point2.x ? this.point1.x : this.point2.x;
            int minY = this.point1.y < this.point2.y ? this.point1.y : this.point2.y;
            int maxX = this.point1.x > this.point2.x ? this.point1.x : this.point2.x;
            int n = maxY = this.point1.y > this.point2.y ? this.point1.y : this.point2.y;
            if (this.point3.x >= minX && this.point3.x <= maxX && this.point3.y >= minY && this.point3.y <= maxY) {
                g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
                this.markPlate.clear();
                Point2d p1 = this.getPlate().getRealLocationForScreenPoint(this.point1);
                Point2d p2 = this.getPlate().getRealLocationForScreenPoint(this.point2);
                this.markPlate.drawLine(p1, p2);
                this.markPlate.convert();
                PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
                return;
            }
            alpha = (angle3 - angle2) / 180.0 * Math.PI;
            h = Math.abs(r * Math.cos(alpha / 2.0));
            if (r - h < 0.5) {
                return;
            }
        }
        if (GfxTools.clipLine(pp1 = new Point((int)center.x, (int)center.y), pp2 = new Point(this.point1.x, this.point1.y), clip = g.getClipBounds())) {
            GfxTools.drawBrokenLine(g, pp1.x, pp1.y, pp2.x, pp2.y);
        }
        if (GfxTools.clipLine(pp1 = new Point((int)center.x, (int)center.y), pp2 = new Point(this.point2.x, this.point2.y), clip)) {
            GfxTools.drawBrokenLine(g, pp1.x, pp1.y, pp2.x, pp2.y);
        }
        if (angle2 < angle1) {
            angle2 += 360.0;
        }
        if (angle3 < angle1) {
            angle3 += 360.0;
        }
        this.markPlate.clear();
        Point2d pCenter = this.getPlate().getRealLocationForScreenPoint(new Point((int)center.x, (int)center.y));
        Point2d rp = this.getPlate().getRealLocationForScreenPoint(new Point((int)center.x + radius, (int)center.y + radius));
        double rX = rp.x - pCenter.x;
        double rY = rp.y - pCenter.y;
        boolean b = angle3 <= angle2 && angle3 >= angle1;
        if (b) {
            GfxTools.drawArc(g, (int)center.x, (int)center.y, radius, angle1, angle2 - angle1);
            this.markPlate.drawArc(pCenter, rX, rY, angle1, angle2 - angle1);
        } else {
            GfxTools.drawArc(g, (int)center.x, (int)center.y, radius, angle2, 360.0 - (angle2 - angle1));
            this.markPlate.drawArc(pCenter, rX, rY, angle2, 360.0 - (angle2 - angle1));
        }
        this.markPlate.convert();
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
    }

    public final void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
    }
}

