/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.dialog;

import de.jave.gui.GSliderArrangement;
import de.jave.image2ascii.model.Image2AsciiOutputOptionsModel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.grid.IDialogComponent;

public final class Image2AsciiOutputOptionsPanel {
    private final JComponent content;

    public Image2AsciiOutputOptionsPanel(final Image2AsciiOutputOptionsModel model) {
        final SpinnerNumberModel ifWidth = new SpinnerNumberModel(model.getOutputWidth(), 1, 5000, 1);
        ifWidth.addChangeListener(new ChangeListener(this){

            public final void stateChanged(ChangeEvent e) {
                model.setOutputWidth(ifWidth.getNumber().intValue());
            }
        });
        final JSpinner widthWidget = new JSpinner(ifWidth);
        final GSliderArrangement slaShape = new GSliderArrangement("Shape factor:", 50, 150, (int)(model.getShapeFactor() * 100.0), 5, 100);
        slaShape.getModel().addChangeListener(new ChangeListener(this){

            public final void stateChanged(ChangeEvent e) {
                model.setShapeFactor(slaShape.getDValue());
            }
        });
        GridDialogPanel dialogPanel = new GridDialogPanel();
        dialogPanel.add(new IDialogComponent(this){

            public final int getColumnCount() {
                return 2;
            }

            public final void fillInto(JPanel panel, int columnCount) {
                panel.add((Component)new JLabel("Text width:"), GridDialogLayoutData.RIGHT);
                panel.add(widthWidget);
            }
        });
        dialogPanel.add(slaShape);
        JPanel panel = new JPanel(new GridDialogLayout(1, false));
        panel.add(dialogPanel.getContent());
        this.content = panel;
    }

    public final JComponent getContent() {
        return this.content;
    }
}

