/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm.dialog.banned;

import de.jave.image2ascii.algorithm.dialog.banned.AsciiCharacterSetModel;
import de.jave.image2ascii.algorithm.dialog.banned.BannedCharactersDialogPage;
import de.jave.image2ascii.algorithm.dialog.banned.BannedCharactersModel;
import de.jave.jave.JaveGlobalRessources;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.IDialogComponent;

public final class BannedCharactersPanel
implements IDialogComponent {
    private final JTextField bannedCharactersTextField;
    private final FontModel fontModel;
    private final BannedCharactersModel model;
    private final ChangeListener modelChangeListener;

    public BannedCharactersPanel(final BannedCharactersModel model, FontModel fontModel) {
        Ensure.ensureArgumentNotNull(model);
        Ensure.ensureArgumentNotNull(fontModel);
        this.model = model;
        this.fontModel = fontModel;
        this.bannedCharactersTextField = new JTextField(20);
        this.bannedCharactersTextField.setEditable(true);
        this.bannedCharactersTextField.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.bannedCharactersTextField.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                if (BannedCharactersPanel.this.bannedCharactersTextField.isVisible()) {
                    model.setBannedCharacters(BannedCharactersPanel.this.bannedCharactersTextField.getText());
                }
            }
        });
        this.modelChangeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                BannedCharactersPanel.this.updateView();
            }
        };
        model.addChangeListener(this.modelChangeListener);
        this.updateView();
    }

    private void updateView() {
        if (new AsciiCharacterSetModel(this.bannedCharactersTextField.getText()).equals(new AsciiCharacterSetModel(this.model.getBannedCharacters()))) {
            return;
        }
        this.bannedCharactersTextField.setText(this.model.getBannedCharacters());
    }

    public final void fillInto(JPanel panel, int columnCount) {
        panel.add((Component)new JLabel("Banned characters:"), GridDialogLayoutData.RIGHT);
        GridDialogLayoutData layoutData = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        layoutData.setHorizontalSpan(columnCount - 2);
        panel.add((Component)this.bannedCharactersTextField, layoutData);
        panel.add(new JButton(new SmartAction("Choose..."){

            protected final void execute(Component parentComponent) {
                BannedCharactersDialogPage page = new BannedCharactersDialogPage(BannedCharactersPanel.this.model.getBannedCharacters(), BannedCharactersPanel.this.fontModel.getFont());
                UserDialog dialog = new UserDialog(parentComponent, page);
                dialog.show();
                if (!dialog.isCanceled()) {
                    BannedCharactersPanel.this.model.setBannedCharacters(page.getBannedCharcaters());
                }
            }
        }));
    }

    public final int getColumnCount() {
        return 3;
    }

    public final void dispose() {
        this.model.removeChangeListener(this.modelChangeListener);
    }
}

