/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm.dialog;

import de.jave.image2ascii.algorithm.AlgorithmPixelPlateOptionsModel;
import de.jave.jave.pixelplate.PixelPlateFeltPenMode;
import de.jave.jave.pixelplate.PixelPlateMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.component.IDisposableComponentContainer;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.ui.IObjectUi;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public final class Image2AsciiAlgorithmPixelPlateOptionsPanel
implements IDisposableComponentContainer {
    private final AlgorithmPixelPlateOptionsModel optionsModel;
    private final ChangeListener optionsModelChangeListener;
    private final JComponent content;

    public Image2AsciiAlgorithmPixelPlateOptionsPanel(final AlgorithmPixelPlateOptionsModel optionsModel) {
        Ensure.ensureArgumentNotNull(optionsModel);
        this.optionsModel = optionsModel;
        PixelPlateMode[] modes = new PixelPlateMode[]{PixelPlateMode.THREE_BY_TWO, PixelPlateMode.TWO_BY_TWO, PixelPlateMode.PIXEL, PixelPlateMode.DOT, PixelPlateFeltPenMode.FELTPEN_8, PixelPlateMode.THICK_THIN};
        final JComboBox<PixelPlateMode> chStyle = new JComboBox<PixelPlateMode>(modes);
        chStyle.setSelectedItem(optionsModel.getPixelPlateMode());
        this.optionsModelChangeListener = new ChangeListener(this){

            public final void stateChanged(ChangeEvent e) {
                chStyle.setSelectedItem(optionsModel.getPixelPlateMode());
            }
        };
        optionsModel.addChangeListener(this.optionsModelChangeListener);
        chStyle.addActionListener(new ActionListener(this){

            public final void actionPerformed(ActionEvent e) {
                optionsModel.setPixelPlateMode((PixelPlateMode)chStyle.getSelectedItem());
            }
        });
        chStyle.setRenderer(new ObjectUiListCellRenderer(new IObjectUi(this){

            public final String getLabel(Object value) {
                PixelPlateMode mode = (PixelPlateMode)value;
                if (mode == PixelPlateMode.THREE_BY_TWO) {
                    return "3by2";
                }
                if (mode == PixelPlateMode.TWO_BY_TWO) {
                    return "2by2";
                }
                if (mode == PixelPlateMode.PIXEL) {
                    return "lines";
                }
                if (mode == PixelPlateMode.DOT) {
                    return "dot";
                }
                if (mode == PixelPlateFeltPenMode.FELTPEN_8) {
                    return "thick 8";
                }
                if (mode == PixelPlateMode.THICK_THIN) {
                    return "thick and thin";
                }
                throw new IllegalArgumentException();
            }

            public final Icon getIcon(Object value) {
                return null;
            }
        }));
        JPanel p = new JPanel(new GridDialogLayout(2, false));
        p.add(new JLabel("Style:"));
        p.add(chStyle);
        this.content = p;
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void dispose() {
        this.optionsModel.removeChangeListener(this.optionsModelChangeListener);
    }
}

