/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmPixelPlateOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmPixelPlateOptionsPanel;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public final class Image2AsciiAlgorithmPixelPlate
extends Image2AsciiAlgorithm {
    private final AlgorithmPixelPlateOptionsModel optionsModel = new AlgorithmPixelPlateOptionsModel();

    public final IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    public final Icon getIcon() {
        return null;
    }

    public final String getName() {
        return "B/W";
    }

    public final void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    public final void setSpecialChars(String specialCharacters) {
    }

    public final IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmPixelPlateOptionsPanel(this.optionsModel);
    }

    public final int getVerticalPixelsPerChar() {
        return this.optionsModel.getPixelPlateMode().getRasterY();
    }

    public final int getHorizontalPixelsPerChar() {
        return this.optionsModel.getPixelPlateMode().getRasterX();
    }

    public final boolean isMonochromeImageRequired() {
        return true;
    }

    public final CharacterPlate convert(IValueRaster pixels, IProgressMonitor progressMonitor) {
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        progressMonitor.beginTask("Converting...", height);
        PixelPlate plate = new PixelPlate(0, 0, width / this.getHorizontalPixelsPerChar(), height / this.getVerticalPixelsPerChar());
        plate.setMode(this.optionsModel.getPixelPlateMode());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (pixels.getValueAt(x, y) != 0) continue;
                plate.set(x, y);
            }
            progressMonitor.worked(1);
        }
        CharacterPlate result = plate.getResult();
        result.replace('\u0000', ' ');
        return result;
    }
}

