/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.asciimation.export.IAnimationExporter;
import de.jave.image.GImage;
import de.jave.image.Rotation;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.GreyscaleImageFactory;
import de.jave.image.greyscale.algorithm.dithering.DitheringAlgorithms;
import de.jave.image2ascii.IImage2AsciiAlgorithm;
import de.jave.image2ascii.ImageConversionException;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.IRunnableWithProgress;
import net.disy.commons.core.progress.NullProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;

public final class BatchConversionThread
implements IRunnableWithProgress {
    private final File[] files;
    private final IImage2AsciiAlgorithm algorithm;
    private final int resultWidth;
    private final double shapeFactor;
    private final boolean normalize;
    private final boolean invert;
    private final int highlight;
    private final int shadow;
    private final double gamma;
    private final double sharpen;
    private final int ditherMethode;
    private final Rotation rotate;
    private final IAnimationExporter exporter;

    public BatchConversionThread(File[] files, int resultWidth, double shapeFactor, boolean normalize, boolean invert, int highlight, int shadow, double gamma, double sharpen, int ditherMethode, Rotation rotate, IImage2AsciiAlgorithm algorithm, IAnimationExporter exporter) {
        this.exporter = exporter;
        this.files = files;
        this.resultWidth = resultWidth;
        this.shapeFactor = shapeFactor;
        this.normalize = normalize;
        this.invert = invert;
        this.shadow = shadow;
        this.highlight = highlight;
        this.gamma = gamma;
        this.sharpen = sharpen;
        this.ditherMethode = ditherMethode;
        this.algorithm = algorithm;
        this.rotate = rotate;
    }

    public final void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        monitor.beginTask("Batch converting...", this.files.length);
        try {
            for (int i = 0; i < this.files.length; ++i) {
                int newHeight;
                ProgressUtilities.checkInterrupted(monitor);
                monitor.subTask("Converting '" + this.files[i].getName() + "'");
                BufferedImage image = ImageIO.read(this.files[i]);
                int oldWidth = image.getWidth();
                int oldHeight = image.getHeight();
                int[] pixels2 = new int[oldWidth * oldHeight];
                PixelGrabber pg2 = new PixelGrabber(image, 0, 0, oldWidth, oldHeight, pixels2, 0, oldWidth);
                try {
                    pg2.grabPixels();
                }
                catch (InterruptedException e) {
                    System.err.println("Internal Error: " + e.toString());
                    continue;
                }
                if ((pg2.getStatus() & 0x80) != 0) {
                    System.err.println("Internal Error: image fetch aborted or errored");
                    continue;
                }
                GGreyscaleImage image2 = new GreyscaleImageFactory().createGreyscaleImage(pixels2, oldWidth, oldHeight);
                ProgressUtilities.checkInterrupted(monitor);
                image2 = (GGreyscaleImage)image2.rotate(this.rotate);
                ProgressUtilities.checkInterrupted(monitor);
                oldWidth = image2.getWidth();
                oldHeight = image2.getHeight();
                double dimFactor = 0.52 * this.shapeFactor;
                int newWidth = this.resultWidth;
                int resultHeight = newHeight = (int)((double)newWidth / (double)oldWidth * (double)oldHeight * dimFactor);
                if (newHeight < 1) {
                    newHeight = 1;
                }
                if (newWidth < 1) {
                    newWidth = 1;
                }
                ProgressUtilities.checkInterrupted(monitor);
                image2 = image2.getScaledInstance(newWidth *= this.algorithm.getHorizontalPixelsPerChar(), newHeight *= this.algorithm.getVerticalPixelsPerChar());
                ProgressUtilities.checkInterrupted(monitor);
                image2 = image2.convert(this.normalize, this.invert, this.gamma, this.highlight, this.shadow);
                ProgressUtilities.checkInterrupted(monitor);
                if (this.sharpen > 0.0) {
                    image2 = image2.sharpen(this.sharpen);
                }
                ProgressUtilities.checkInterrupted(monitor);
                GImage gi = image2;
                if (this.ditherMethode != -1) {
                    gi = new DitheringAlgorithms().dither(image2, this.ditherMethode);
                }
                ProgressUtilities.checkInterrupted(monitor);
                CharacterPlate result = this.algorithm.convert(gi, NullProgressMonitor.getInstance());
                if (i == 0) {
                    this.exporter.init(new Dimension(this.resultWidth, resultHeight), new AnimationProperties(), this.files.length, new AnimationMetaData());
                }
                this.exporter.writeFrame(result);
                monitor.worked(1);
            }
            this.exporter.finish();
            return;
        }
        catch (InterruptedException interruptedException) {
            InterruptedException e = interruptedException;
            throw interruptedException;
        }
        catch (OutOfMemoryError e) {
            this.exporter.rollBack();
            throw new InvocationTargetException(new ImageConversionException("Error exporting file: The result file is too big.", e));
        }
        catch (Throwable e) {
            this.exporter.rollBack();
            throw new InvocationTargetException(new ImageConversionException("Error exporting file.", e));
        }
    }
}

