/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image.monochrome;

import de.jave.image.GImage;
import java.awt.Color;
import java.awt.Graphics;

public final class GMonochromeImage
extends GImage {
    protected int[][] pixels;

    public GMonochromeImage(int width, int height) {
        super(width, height);
        this.pixels = new int[height][(width + 31) / 32];
    }

    protected final GImage createGImage(int width, int height) {
        return new GMonochromeImage(width, height);
    }

    public final GImage getClone() {
        int w = (this.getWidth() + 31) / 32;
        int[][] p = new int[this.getHeight()][w];
        for (int y = 0; y < this.getHeight(); ++y) {
            System.arraycopy(this.pixels[y], 0, p[y], 0, w);
        }
        GMonochromeImage g = new GMonochromeImage(this.getWidth(), this.getHeight());
        new GMonochromeImage(this.getWidth(), this.getHeight()).pixels = p;
        return g;
    }

    public final GMonochromeImage scaleY2() {
        GMonochromeImage g = new GMonochromeImage(this.getWidth(), this.getHeight() * 2);
        int w = (this.getWidth() + 31) / 32;
        g.pixels = new int[g.getHeight()][w];
        for (int y = 0; y < this.getHeight(); ++y) {
            System.arraycopy(this.pixels[y], 0, g.pixels[y * 2], 0, w);
            System.arraycopy(this.pixels[y], 0, g.pixels[y * 2 + 1], 0, w);
        }
        return g;
    }

    public final void set(int x, int y, int value) {
        int[] nArray = this.pixels[y];
        int n = x / 32;
        nArray[n] = nArray[n] & -1 - (1 << x % 32);
        int[] nArray2 = this.pixels[y];
        int n2 = x / 32;
        nArray2[n2] = nArray2[n2] | value << x % 32;
    }

    public final int get(int x, int y) {
        return this.pixels[y][x / 32] >> x % 32 & 1;
    }

    public final int getNormalizingFactor() {
        return 255;
    }

    public final int getMaxPossibleValue() {
        return 1;
    }

    public final void edgeDespecle() {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (this.get(x, y) != 0) continue;
                int count = this.getNeighbourCount(x, y);
                if (count == 0) {
                    this.set(x, y, 1);
                    continue;
                }
                if (count != 1) continue;
                if (x < this.getWidth() - 1 && this.get(x + 1, y) == 0 && this.getNeighbourCount(x + 1, y) == 1) {
                    this.set(x, y, 1);
                    this.set(x + 1, y, 1);
                } else if (y > 0 && x < this.getWidth() - 1 && this.get(x + 1, y - 1) == 0 && this.getNeighbourCount(x + 1, y - 1) == 1) {
                    this.set(x, y, 1);
                    this.set(x + 1, y - 1, 1);
                }
                if (y < this.getHeight() - 1 && x < this.getWidth() - 1 && this.get(x + 1, y + 1) == 0 && this.getNeighbourCount(x + 1, y + 1) == 1) {
                    this.set(x, y, 1);
                    this.set(x + 1, y + 1, 1);
                }
                if (y >= this.getHeight() - 1 || this.get(x, y + 1) != 0 || this.getNeighbourCount(x, y + 1) != 1) continue;
                this.set(x, y, 1);
                this.set(x, y + 1, 1);
            }
        }
    }

    public final int getNeighbourCount(int x, int y) {
        int result = 0;
        if (x > 0 && this.get(x - 1, y) == 0) {
            ++result;
        }
        if (x < this.getWidth() - 1 && this.get(x + 1, y) == 0) {
            ++result;
        }
        if (y > 0 && this.get(x, y - 1) == 0) {
            ++result;
        }
        if (y < this.getHeight() - 1 && this.get(x, y + 1) == 0) {
            ++result;
        }
        if (y > 0 && x > 0 && this.get(x - 1, y - 1) == 0) {
            ++result;
        }
        if (y > 0 && x < this.getWidth() - 1 && this.get(x + 1, y - 1) == 0) {
            ++result;
        }
        if (y < this.getHeight() - 1 && x > 0 && this.get(x - 1, y + 1) == 0) {
            ++result;
        }
        if (y < this.getHeight() - 1 && x < this.getWidth() - 1 && this.get(x + 1, y + 1) == 0) {
            ++result;
        }
        return result;
    }

    public final void paint(Graphics g, int x0, int y0) {
        if (this.pixels == null) {
            return;
        }
        g.setColor(Color.white);
        g.fillRect(x0, x0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        for (int y = this.getHeight() - 1; y >= 0; --y) {
            for (int x = this.getWidth() - 1; x >= 0; --x) {
                if (this.get(x, y) != 0) continue;
                g.drawLine(x0 + x, y0 + y, x0 + x, y0 + y);
            }
        }
    }
}

