/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image.greyscale.algorithm.dithering;

import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.algorithm.dithering.Bayer4Dithering;
import de.jave.image.greyscale.algorithm.dithering.Bayer8Dithering;
import de.jave.image.greyscale.algorithm.dithering.FloydSteinbergDithering;
import de.jave.image.greyscale.algorithm.dithering.HalftoneDithering;
import de.jave.image.greyscale.algorithm.dithering.IGreyscaleDithering;
import de.jave.image.greyscale.algorithm.dithering.JarvisJudiceNinkeDithering;
import de.jave.image.greyscale.algorithm.dithering.SierraDithering;
import de.jave.image.greyscale.algorithm.dithering.SimpleRandomDithering;
import de.jave.image.greyscale.algorithm.dithering.StevensonArceDithering;
import de.jave.image.greyscale.algorithm.dithering.StuckiDithering;
import de.jave.image.greyscale.algorithm.dithering.ThresholdDithering;
import de.jave.image.monochrome.GMonochromeImage;

public final class DitheringAlgorithms {
    public static final IGreyscaleDithering[] getAllGreyscaleDitheringAlgorithms() {
        return new IGreyscaleDithering[]{new ThresholdDithering(), new SimpleRandomDithering(), new FloydSteinbergDithering(), new StevensonArceDithering(), new StuckiDithering(), new JarvisJudiceNinkeDithering(), new SierraDithering()};
    }

    public final GMonochromeImage dither(GGreyscaleImage image, int ditherMethode) {
        switch (ditherMethode) {
            case 0: {
                return new ThresholdDithering().dither(image);
            }
            case 1: {
                return new SimpleRandomDithering().dither(image);
            }
            case 2: {
                return new FloydSteinbergDithering().dither(image);
            }
            case 3: {
                return new JarvisJudiceNinkeDithering().dither(image);
            }
            case 4: {
                return new StuckiDithering().dither(image);
            }
            case 5: {
                return new StevensonArceDithering().dither(image);
            }
            case 6: {
                return new HalftoneDithering().dither(image);
            }
            case 7: {
                return new Bayer8Dithering().dither(image);
            }
            case 8: {
                return new Bayer4Dithering().dither(image);
            }
        }
        throw new IllegalArgumentException("No such dither methode: " + ditherMethode);
    }

    static {
        String[] stringArray = new String[]{"Threshold", "Random", "Floyd-Steinberg", "Jarvis-Judice-Ninke", "Stucki", "Stevenson-Arce", "Halftoning", "Bayer 8", "Bayer 4"};
    }
}

