/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.io;

import java.io.File;

public final class FileSelection {
    private final File[] files;

    public FileSelection(File[] files) {
        this.files = files;
    }

    public FileSelection(File file) {
        this(FileSelection.toFileArray(file));
    }

    private static File[] toFileArray(File file) {
        if (file == null) {
            return new File[0];
        }
        return new File[]{file};
    }

    public final File getFile() {
        if (this.files.length > 0) {
            return this.files[0];
        }
        return null;
    }

    public final File[] getFiles() {
        return this.files;
    }

    public final boolean isEmpty() {
        return this.files.length == 0;
    }

    public static final FileSelection createEmpty() {
        return new FileSelection(new File[0]);
    }
}

