/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.io;

import de.jave.gui.io.FileSelection;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.disy.commons.core.io.FileModel;

public final class FileChooserUtilities {
    public static final File performOpenFileChooserOLD(Component parentComponent, IFileChooserConfiguration configuration) {
        FileSelection selection = FileChooserUtilities.performOpenFileChooser(parentComponent, configuration);
        return selection.getFile();
    }

    public static final FileSelection performOpenFileChooser(Component parentComponent, IFileChooserConfiguration configuration) {
        int answer;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(configuration.isMultipleOpenFileSelectionAllowed());
        fileChooser.setDialogTitle(configuration.getOpenDialogTitle());
        FileModel currentDirectoryModel = configuration.getCurrentDirectoryModel();
        File directory = currentDirectoryModel.getFile();
        if (directory != null) {
            fileChooser.setCurrentDirectory(directory);
        }
        SmartFileFilter[] fileFilters = configuration.getFileFilters();
        FileChooserUtilities.adjustFileFilters(fileChooser, fileFilters);
        String fileNameSuggestion = configuration.getFileNameSuggestion();
        if (fileNameSuggestion != null) {
            File file = directory == null ? new File(fileNameSuggestion) : new File(directory, fileNameSuggestion);
            fileChooser.setSelectedFile(file);
        }
        if ((answer = fileChooser.showOpenDialog(parentComponent)) != 0) {
            return FileSelection.createEmpty();
        }
        if (configuration.isMultipleOpenFileSelectionAllowed()) {
            File[] files = fileChooser.getSelectedFiles();
            if (files.length > 0) {
                currentDirectoryModel.setFile(files[0].getParentFile());
            }
            return new FileSelection(files);
        }
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            currentDirectoryModel.setFile(file.getParentFile());
        }
        return new FileSelection(file);
    }

    public static final File performSaveFileChooser(Component parentComponent, IFileChooserConfiguration configuration) {
        int answer;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(configuration.getSaveDialogTitle());
        FileModel currentDirectoryModel = configuration.getCurrentDirectoryModel();
        File directory = currentDirectoryModel.getFile();
        if (directory != null) {
            fileChooser.setCurrentDirectory(directory);
        }
        SmartFileFilter[] fileFilters = configuration.getFileFilters();
        FileChooserUtilities.adjustFileFilters(fileChooser, fileFilters);
        String fileNameSuggestion = configuration.getFileNameSuggestion();
        if (fileNameSuggestion != null) {
            File file = directory == null ? new File(fileNameSuggestion) : new File(directory, fileNameSuggestion);
            fileChooser.setSelectedFile(file);
        }
        if ((answer = fileChooser.showSaveDialog(parentComponent)) != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        currentDirectoryModel.setFile(file.getParentFile());
        FileFilter selectedFilter = fileChooser.getFileFilter();
        if (selectedFilter instanceof SmartFileFilter) {
            SmartFileFilter smartFilter = (SmartFileFilter)selectedFilter;
            file = smartFilter.makeComplete(file);
        }
        return file;
    }

    private static void adjustFileFilters(JFileChooser fileChooser, SmartFileFilter[] filters) {
        if (filters.length == 0) {
            return;
        }
        fileChooser.setAcceptAllFileFilterUsed(false);
        for (int i = 0; i < filters.length; ++i) {
            fileChooser.addChoosableFileFilter(filters[i]);
        }
        fileChooser.setFileFilter(filters[0]);
    }
}

