/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GSlider;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.grid.IDialogComponent;

public final class GSliderArrangement
implements IDialogComponent {
    private GSlider slider;
    private JLabel label;
    private JSpinner spinner;
    private int defaultValue;
    private int divide;
    private boolean isResetButtonAvailable = false;
    private final SpinnerNumberModel model;

    public GSliderArrangement(String labelText, int minValue, int maxValue, int defaultValue, int step, final int divide) {
        this.defaultValue = defaultValue;
        this.divide = divide;
        this.label = new JLabel(labelText);
        this.model = divide == 1 ? new SpinnerNumberModel(defaultValue, minValue, maxValue, step) : new SpinnerNumberModel((double)defaultValue / (double)divide, (double)minValue / (double)divide, (double)maxValue / (double)divide, (double)step / (double)divide);
        final SpinnerNumberModel sliderModel = new SpinnerNumberModel(defaultValue, minValue, maxValue, step);
        sliderModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                if (divide == 1) {
                    GSliderArrangement.this.model.setValue(sliderModel.getValue());
                    return;
                }
                GSliderArrangement.this.model.setValue(new Double(sliderModel.getNumber().doubleValue() / (double)divide));
            }
        });
        this.model.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                if (divide == 1) {
                    sliderModel.setValue(GSliderArrangement.this.model.getValue());
                    return;
                }
                sliderModel.setValue(new Integer((int)(GSliderArrangement.this.model.getNumber().doubleValue() * (double)divide)));
            }
        });
        this.slider = new GSlider(sliderModel);
        this.spinner = new JSpinner(this.model);
    }

    public final void setDefault() {
        this.reset();
    }

    public final void reset() {
        this.setValue(this.defaultValue);
    }

    public final void setEnabled(boolean enabled) {
        this.spinner.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public final int getValue() {
        return this.model.getNumber().intValue();
    }

    public final double getDValue() {
        return this.model.getNumber().doubleValue();
    }

    public final void setValue(int i) {
        if (this.divide == 1) {
            this.model.setValue(new Integer(i));
            return;
        }
        this.model.setValue(new Double((double)i / (double)this.divide));
    }

    public final int getColumnCount() {
        return 3 + (this.isResetButtonAvailable ? 1 : 0);
    }

    public final void fillInto(JPanel panel, int columnCount) {
        panel.add((Component)this.label, GridDialogLayoutData.RIGHT);
        panel.add((Component)this.slider, GridDialogLayoutData.FILL_HORIZONTAL);
        GridDialogLayoutData data = new GridDialogLayoutData();
        data.setHorizontalAlignment(GridAlignment.FILL);
        data.setWidthHint(55);
        panel.add((Component)this.spinner, data);
        if (this.isResetButtonAvailable) {
            panel.add(new JButton(new SmartAction("Reset"){

                protected final void execute(Component parentComponent) {
                    GSliderArrangement.this.setDefault();
                }
            }));
        }
    }

    public final Component createPanel() {
        GridDialogPanel panel = new GridDialogPanel();
        panel.add(this);
        return panel.getContent();
    }

    public final void setShowsResetButton(boolean isResetButtonAvailable) {
        this.isResetButtonAvailable = isResetButtonAvailable;
    }

    public final SpinnerNumberModel getModel() {
        return this.model;
    }
}

