/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gfx.GfxUtilities;
import de.jave.gui.GuiTools;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public abstract class GButton
extends JComponent
implements MouseListener,
FocusListener,
KeyListener {
    private transient ActionListener actionListener;
    protected Dimension preferredSize = null;
    private String name;
    private static final Dimension DEFAULT_SIZE = new Dimension(24, 23);
    protected boolean lockable = false;
    private boolean unlockable = true;
    protected boolean pressed = false;
    protected boolean locked = false;
    private boolean pressedByKey;
    private boolean focus = false;
    protected boolean focusTraversable = true;
    protected boolean isEnabled = true;
    private boolean mouseOver = false;
    private int mode3D = 0;

    public GButton() {
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.setEnabled(true);
    }

    public final void set3DMode(int mode) {
        this.mode3D = mode;
        this.repaint();
    }

    protected final void paintBorder(Graphics g) {
        Dimension d = this.getSize();
        if (!this.isEnabled) {
            if (this.mode3D == 0) {
                GuiTools.draw3dRectangleUp(g, 0, 0, d.width, d.height);
            }
            return;
        }
        if (this.pressed || this.lockable && this.locked) {
            if (this.mode3D == 0) {
                GuiTools.draw3dRectangleDown(g, 0, 0, d.width, d.height);
                return;
            }
            if (this.mode3D == 1) {
                GuiTools.drawSmall3dRectangleDown(g, 0, 0, d.width, d.height);
                return;
            }
        } else {
            if (this.mode3D == 0) {
                GuiTools.draw3dRectangleUp(g, 0, 0, d.width, d.height);
                return;
            }
            if (this.mode3D == 1 && this.mouseOver) {
                GuiTools.drawSmall3dRectangleUp(g, 0, 0, d.width, d.height);
            }
        }
    }

    public final void setEnabled(boolean what) {
        if (this.isEnabled != what) {
            this.isEnabled = what;
            this.repaint();
        }
    }

    public final void enable(boolean what) {
        this.setEnabled(what);
    }

    public final void enable() {
        this.setEnabled(true);
    }

    public final void disable() {
        this.setEnabled(false);
    }

    public final void focusGained(FocusEvent evt) {
        if (this.isFocusTraversable()) {
            this.focus = true;
            this.repaint();
        }
    }

    public final void focusLost(FocusEvent evt) {
        this.focus = false;
        this.repaint();
    }

    public final void setFocusTraversable(boolean what) {
        this.focusTraversable = what;
    }

    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public final synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public final void drawFocus(Graphics g, Dimension d) {
        if (this.focus) {
            g.setColor(Color.black);
            GfxUtilities.drawDottedRectangle(g, 3, 3, d.width - 7, d.height - 7);
        }
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return DEFAULT_SIZE;
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public final void setLocked() {
        this.setLocked(true);
    }

    public final void setLocked(boolean what) {
        if (this.locked != what) {
            this.pressed = false;
            this.pressedByKey = false;
            this.locked = what;
            this.repaint();
        }
    }

    public final void setLockable(boolean what) {
        this.lockable = what;
    }

    public final void setUnlockable(boolean what) {
        this.unlockable = what;
    }

    public final void setToggleButton(boolean what) {
        this.setLockable(what);
        this.setUnlockable(what);
    }

    public final void mouseClicked(MouseEvent e) {
    }

    public final void mouseReleased(MouseEvent e) {
        ActionEvent evt;
        if (!this.pressed) {
            return;
        }
        if (this.lockable && this.locked && !this.unlockable) {
            return;
        }
        if (this.lockable && this.locked) {
            this.pressed = false;
            evt = new ActionEvent(this, 1001, this.name + "OFF");
            this.setLocked(false);
        } else if (this.lockable && !this.locked) {
            evt = new ActionEvent(this, 1001, this.name + "ON");
            this.setLocked(true);
        } else {
            evt = new ActionEvent(this, 1001, this.name);
            this.pressed = false;
            this.repaint();
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(evt);
        }
    }

    public final void mousePressed(MouseEvent e) {
        if (this.isFocusTraversable()) {
            this.requestFocus();
        }
        if (!this.isEnabled) {
            return;
        }
        this.pressed = true;
        this.repaint();
    }

    public final void mouseEntered(MouseEvent e) {
        this.mouseOver = true;
        if (this.mode3D == 1) {
            this.repaint();
        }
    }

    public final void mouseExited(MouseEvent e) {
        if (this.pressed && !this.pressedByKey) {
            this.pressed = false;
            this.repaint();
            return;
        }
        this.mouseOver = false;
        if (this.mode3D == 1) {
            this.repaint();
        }
    }

    public final void keyPressed(KeyEvent evt) {
        if (this.isEnabled && evt.getKeyChar() == ' ' && !this.pressed) {
            this.pressed = true;
            this.pressedByKey = true;
            this.repaint();
        }
    }

    public final void keyReleased(KeyEvent evt) {
        ActionEvent e;
        if (!this.pressed || !this.pressedByKey) {
            return;
        }
        this.pressedByKey = false;
        if (this.lockable && this.locked && !this.unlockable) {
            return;
        }
        if (this.lockable && this.locked) {
            this.pressed = false;
            e = new ActionEvent(this, 1001, this.name + "OFF");
            this.setLocked(false);
        } else if (this.lockable && !this.locked) {
            e = new ActionEvent(this, 1001, this.name + "ON");
            this.setLocked(true);
        } else {
            e = new ActionEvent(this, 1001, this.name);
            this.pressed = false;
            this.repaint();
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    public final void keyTyped(KeyEvent evt) {
    }

    public final void setPreferredSize(Dimension d) {
        this.preferredSize = d;
    }
}

