/*
 * Decompiled with CFR 0.152.
 */
package de.jave.formula2;

import de.jave.text.TextTools;

public final class FormulaCharField {
    int ascent;
    int height;
    int width;
    char[][] ch;

    public FormulaCharField(int width, int height, int ascent) {
        this.width = width;
        this.height = height;
        this.ascent = ascent;
        this.ch = new char[height][width];
        for (int x = 0; x < width; ++x) {
            this.ch[0][x] = 32;
        }
        for (int y = 1; y < height; ++y) {
            System.arraycopy(this.ch[0], 0, this.ch[y], 0, width);
        }
    }

    public FormulaCharField(int width, int height) {
        this(width, height, 0);
    }

    public FormulaCharField(String line) {
        this.width = line.length();
        this.height = 1;
        this.ch = new char[this.height][this.width];
        System.arraycopy(line.toCharArray(), 0, this.ch[0], 0, this.width);
    }

    public final void set(int x, int y, char c) {
        this.ch[y][x] = c;
    }

    public final char get(int x, int y) {
        return this.ch[y][x];
    }

    public final void insert(String s, int x, int y) {
        this.insert(s.toCharArray(), x, y);
    }

    public final void insert(char[] c, int x, int y) {
        System.arraycopy(c, 0, this.ch[y], x, c.length);
    }

    public final void pasteInto(FormulaCharField f, int x0, int y0) {
        for (int y = 0; y < this.height; ++y) {
            System.arraycopy(this.ch[y], 0, f.ch[y0 + y], x0, this.width);
        }
    }

    public final boolean isTopWeak() {
        for (int x = 0; x < this.width; ++x) {
            if (this.ch[0][x] == ' ' || this.ch[0][x] == '_') continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        return TextTools.toString(this.ch);
    }
}

