/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.layout;

import de.jave.figlet.engine.layout.HorizontalAlignment;
import de.jave.figlet.swing.ui.HorizontalAlignmentUi;
import de.jave.lib.gui.GuiUtilities;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public final class HorizontalAlignmentPanel {
    private List buttons = new ArrayList();
    private List alignments = new ArrayList();
    private JPanel panel;
    private Map toggleButtonsByAlignment = new HashMap();

    public HorizontalAlignmentPanel(ActionListener listener) {
        ButtonGroup group = new ButtonGroup();
        this.panel = new JPanel(new FlowLayout(0, 0, 0));
        this.addAlignmentToggleButton(this.panel, group, HorizontalAlignment.LEFT, listener);
        this.addAlignmentToggleButton(this.panel, group, HorizontalAlignment.CENTER, listener);
        this.addAlignmentToggleButton(this.panel, group, HorizontalAlignment.RIGHT, listener);
        this.setSelectedAlignment(HorizontalAlignment.LEFT);
    }

    public final void setSelectedAlignment(HorizontalAlignment alignment) {
        JToggleButton button = (JToggleButton)this.toggleButtonsByAlignment.get(alignment);
        if (button != null) {
            button.setSelected(true);
            return;
        }
        throw new RuntimeException();
    }

    public final HorizontalAlignment getSelectedAlignment() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!((JToggleButton)this.buttons.get(i)).isSelected()) continue;
            return (HorizontalAlignment)this.alignments.get(i);
        }
        throw new RuntimeException();
    }

    private void addAlignmentToggleButton(JPanel panel, ButtonGroup group, HorizontalAlignment alignment, ActionListener listener) {
        JToggleButton button = new JToggleButton(new HorizontalAlignmentUi().getIcon(alignment));
        button.addActionListener(listener);
        button.setPreferredSize(GuiUtilities.TOOLBAR_BUTTON_SIZE);
        button.setFocusPainted(false);
        group.add(button);
        panel.add(button);
        this.toggleButtonsByAlignment.put(alignment, button);
        this.buttons.add(button);
        this.alignments.add(alignment);
    }

    public final JComponent getComponent() {
        return this.panel;
    }
}

