/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.fontchooser;

import de.jave.figlet.IFontSelectionListener;
import de.jave.figlet.engine.FigDriver;
import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.swing.action.FontSelectionActions;
import de.jave.figlet.swing.fontchooser.FixedIconListCellRenderer;
import de.jave.figlet.swing.fontchooser.FontNameFilterPanel;
import de.jave.figlet.swing.ui.FigletIcons;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class FontListView {
    private JComponent content;
    private JList list;
    private List listeners = new ArrayList();
    private FontSelectionActions actions;
    private FixedIconListCellRenderer renderer = new FixedIconListCellRenderer(FigletIcons.FONT_ICON);
    private FontNameFilterPanel filterPanel;
    private String[] currentFontNames;
    private String choosenFont;

    public FontListView(FigDriver figDriver) {
        this.actions = new FontSelectionActions(this, figDriver);
        this.list = new JList(new DefaultListModel());
        this.list.setCellRenderer(this.renderer);
        this.list.addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent event) {
                if (!FontListView.this.list.isEnabled()) {
                    return;
                }
                int index = FontListView.this.list.getUI().locationToIndex(FontListView.this.list, event.getPoint());
                if (index >= 0 && index < FontListView.this.list.getModel().getSize()) {
                    FontListView.this.list.setSelectedIndex(index);
                }
            }

            public final void mouseReleased(MouseEvent event) {
                if (!FontListView.this.list.isEnabled()) {
                    return;
                }
                if (event.isMetaDown()) {
                    FontListView.this.showPopup(event.getPoint());
                }
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                FontListView.this.updateActionsEnabled();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public final void run() {
                        if (2.access$100(this.this$1).getSelectedFont() != null) {
                            FontListView.access$202(2.access$100(this.this$1), 2.access$100(this.this$1).getSelectedFont());
                        }
                        2.access$100(this.this$1).fireFontSelectionChanged();
                    }
                });
            }

            static final /* synthetic */ FontListView access$100(2 x0) {
                return x0.FontListView.this;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setPreferredSize(new Dimension(150, 120));
        JButton infoButton = new JButton(this.actions.getFontInfoAction());
        infoButton.setPreferredSize(GuiUtilities.TOOLBAR_BUTTON_SIZE);
        infoButton.setToolTipText(this.actions.getFontInfoAction().getName());
        infoButton.setText(null);
        infoButton.setFocusPainted(false);
        JPanel filterPanel = new JPanel(new FlowLayout(1, 0, 0));
        filterPanel.add(this.createFilterPanel());
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)new JLabel("Font:", 2), "West");
        headerPanel.add((Component)filterPanel, "Center");
        headerPanel.add((Component)infoButton, "East");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)headerPanel, "North");
        contentPanel.add((Component)scrollPane, "Center");
        this.content = contentPanel;
    }

    private JComponent createFilterPanel() {
        this.filterPanel = new FontNameFilterPanel(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                FontListView.this.filterFontNames(FontListView.this.filterPanel.getFilterText());
            }
        });
        return this.filterPanel.getComponent();
    }

    protected final void filterFontNames(String filterText) {
        if (filterText == null || filterText.length() == 0) {
            this.setListModel(this.currentFontNames);
            return;
        }
        this.setListModel(FontListView.getFiltered(this.currentFontNames, filterText));
    }

    private static String[] getFiltered(String[] names, String filterText) {
        filterText = filterText.toLowerCase();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].toLowerCase().indexOf(filterText) == -1) continue;
            list.add(names[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    protected final void showPopup(Point point) {
        JPopupMenu menu = this.actions.getPopupMenu();
        if (menu != null) {
            menu.show(this.list, point.x, point.y);
        }
    }

    protected final void updateActionsEnabled() {
        this.actions.updateEnabled();
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void setFontCategory(FigFontCategory category) {
        this.filterPanel.clear();
        DefaultListModel listModel = (DefaultListModel)this.list.getModel();
        if (category == null) {
            listModel.clear();
            return;
        }
        this.currentFontNames = category.getFontNames();
        this.setListModel(this.currentFontNames);
        if (this.currentFontNames.length == 0) {
            listModel.addElement(" - category is empty -");
            this.list.setEnabled(false);
            this.filterPanel.setEnabled(false);
            this.list.setCellRenderer(new DefaultListCellRenderer());
            return;
        }
        this.list.setEnabled(true);
        this.filterPanel.setEnabled(true);
        this.list.setCellRenderer(this.renderer);
    }

    private void setListModel(String[] fontNames) {
        this.list.setValueIsAdjusting(true);
        DefaultListModel listModel = (DefaultListModel)this.list.getModel();
        listModel.clear();
        for (int i = 0; i < fontNames.length; ++i) {
            listModel.addElement(fontNames[i]);
        }
        if (this.choosenFont != null) {
            this.setSelectedFont(this.choosenFont);
        }
        this.list.setValueIsAdjusting(false);
    }

    public final String getSelectedFont() {
        if (this.list.isEnabled()) {
            return (String)this.list.getSelectedValue();
        }
        return null;
    }

    public final synchronized void addFontSelectionListener(IFontSelectionListener listener) {
        this.listeners.add(listener);
    }

    protected final synchronized void fireFontSelectionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IFontSelectionListener listener = (IFontSelectionListener)this.listeners.get(i);
            listener.fontSelectionChanged();
        }
    }

    public final void setSelectedFont(String fontName) {
        this.choosenFont = fontName;
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        if (model.contains(fontName)) {
            this.list.setSelectedValue(fontName, true);
            return;
        }
        this.list.clearSelection();
    }

    static final /* synthetic */ String access$202(FontListView x0, String x1) {
        x0.choosenFont = x1;
        return x0.choosenFont;
    }
}

